/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.collision;

import com.jme3.bullet.NativePhysicsObject;
import com.jme3.bullet.collision.ManifoldPoints;
import com.jme3.bullet.collision.PhysicsCollisionObject;
import com.jme3.math.Vector3f;
import com.jme3.scene.Spatial;
import java.util.logging.Logger;
import jme3utilities.Validate;

public class PhysicsCollisionEvent
extends NativePhysicsObject {
    public static final Logger logger = Logger.getLogger(PhysicsCollisionEvent.class.getName());
    private final PhysicsCollisionObject pcoA;
    private final PhysicsCollisionObject pcoB;

    public PhysicsCollisionEvent(PhysicsCollisionObject pcoA, PhysicsCollisionObject pcoB, long manifoldPointId) {
        Validate.nonNull((Object)pcoA, (String)"object A");
        Validate.nonNull((Object)pcoB, (String)"object B");
        Validate.nonZero((long)manifoldPointId, (String)"manifold point ID");
        this.pcoA = pcoA;
        this.pcoB = pcoB;
        super.setNativeIdNotTracked(manifoldPointId);
    }

    public Spatial getNodeA() {
        Spatial result = null;
        Object userObject = this.pcoA.getUserObject();
        if (userObject instanceof Spatial) {
            result = (Spatial)userObject;
        }
        return result;
    }

    public Spatial getNodeB() {
        Spatial result = null;
        Object userObject = this.pcoB.getUserObject();
        if (userObject instanceof Spatial) {
            result = (Spatial)userObject;
        }
        return result;
    }

    public PhysicsCollisionObject getObjectA() {
        assert (this.pcoA != null);
        return this.pcoA;
    }

    public PhysicsCollisionObject getObjectB() {
        assert (this.pcoB != null);
        return this.pcoB;
    }

    public float getAppliedImpulse() {
        long nativeId = this.nativeId();
        float result = ManifoldPoints.getAppliedImpulse(nativeId);
        return result;
    }

    public float getAppliedImpulseLateral1() {
        long nativeId = this.nativeId();
        float result = ManifoldPoints.getAppliedImpulseLateral1(nativeId);
        return result;
    }

    public float getAppliedImpulseLateral2() {
        long nativeId = this.nativeId();
        float result = ManifoldPoints.getAppliedImpulseLateral2(nativeId);
        return result;
    }

    public float getCombinedFriction() {
        long nativeId = this.nativeId();
        float result = ManifoldPoints.getCombinedFriction(nativeId);
        return result;
    }

    public float getCombinedRestitution() {
        long nativeId = this.nativeId();
        float result = ManifoldPoints.getCombinedRestitution(nativeId);
        return result;
    }

    public float getCombinedRollingFriction() {
        long nativeId = this.nativeId();
        float result = ManifoldPoints.getCombinedRollingFriction(nativeId);
        return result;
    }

    public float getCombinedSpinningFriction() {
        long nativeId = this.nativeId();
        float result = ManifoldPoints.getCombinedSpinningFriction(nativeId);
        return result;
    }

    public float getDistance1() {
        long nativeId = this.nativeId();
        float result = ManifoldPoints.getDistance1(nativeId);
        return result;
    }

    public int getFlags() {
        long nativeId = this.nativeId();
        int result = ManifoldPoints.getFlags(nativeId);
        return result;
    }

    public int getIndex0() {
        long nativeId = this.nativeId();
        int result = ManifoldPoints.getIndex0(nativeId);
        return result;
    }

    public int getIndex1() {
        long nativeId = this.nativeId();
        int result = ManifoldPoints.getIndex1(nativeId);
        return result;
    }

    public Vector3f getLateralFrictionDir1(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long nativeId = this.nativeId();
        ManifoldPoints.getLateralFrictionDir1(nativeId, result);
        return result;
    }

    public Vector3f getLateralFrictionDir2(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long nativeId = this.nativeId();
        ManifoldPoints.getLateralFrictionDir2(nativeId, result);
        return result;
    }

    public int getLifeTime() {
        long nativeId = this.nativeId();
        int result = ManifoldPoints.getLifeTime(nativeId);
        return result;
    }

    public Vector3f getLocalPointA(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long nativeId = this.nativeId();
        ManifoldPoints.getLocalPointA(nativeId, result);
        return result;
    }

    public Vector3f getLocalPointB(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long nativeId = this.nativeId();
        ManifoldPoints.getLocalPointB(nativeId, result);
        return result;
    }

    public Vector3f getNormalWorldOnB() {
        return this.getNormalWorldOnB(null);
    }

    public Vector3f getNormalWorldOnB(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long nativeId = this.nativeId();
        ManifoldPoints.getNormalWorldOnB(nativeId, result);
        return result;
    }

    public int getPartId0() {
        long nativeId = this.nativeId();
        int result = ManifoldPoints.getPartId0(nativeId);
        return result;
    }

    public int getPartId1() {
        long nativeId = this.nativeId();
        int result = ManifoldPoints.getPartId1(nativeId);
        return result;
    }

    public Vector3f getPositionWorldOnA() {
        return this.getPositionWorldOnA(null);
    }

    public Vector3f getPositionWorldOnA(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long nativeId = this.nativeId();
        ManifoldPoints.getPositionWorldOnA(nativeId, result);
        return result;
    }

    public Vector3f getPositionWorldOnB() {
        return this.getPositionWorldOnB(null);
    }

    public Vector3f getPositionWorldOnB(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long nativeId = this.nativeId();
        ManifoldPoints.getPositionWorldOnB(nativeId, result);
        return result;
    }

    public boolean isLateralFrictionInitialized() {
        int flags = this.getFlags();
        boolean result = (flags & 1) != 0;
        return result;
    }
}

