/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.collision.shapes;

import com.jme3.bullet.collision.shapes.ConvexShape;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Vector3f;
import com.jme3.util.clone.Cloner;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.util.logging.Logger;
import jme3utilities.Validate;
import jme3utilities.math.MyBuffer;
import jme3utilities.math.MyMath;
import jme3utilities.math.MyVector3f;
import jme3utilities.math.MyVolume;

public class BoxCollisionShape
extends ConvexShape {
    public static final Logger logger2 = Logger.getLogger(BoxCollisionShape.class.getName());
    private static final String tagHalfExtents = "halfExtents";
    private Vector3f halfExtents = new Vector3f(1.0f, 1.0f, 1.0f);

    protected BoxCollisionShape() {
    }

    public BoxCollisionShape(float halfExtent) {
        Validate.nonNegative((float)halfExtent, (String)"half extent");
        this.halfExtents.set(halfExtent, halfExtent, halfExtent);
        this.createShape();
    }

    public BoxCollisionShape(float xHalfExtent, float yHalfExtent, float zHalfExtent) {
        Validate.nonNegative((float)xHalfExtent, (String)"half extent on X");
        Validate.nonNegative((float)yHalfExtent, (String)"half extent on Y");
        Validate.nonNegative((float)zHalfExtent, (String)"half extent on Z");
        this.halfExtents.set(xHalfExtent, yHalfExtent, zHalfExtent);
        this.createShape();
    }

    public BoxCollisionShape(FloatBuffer buffer, int startPosition, int endPosition) {
        Validate.nonNull((Object)buffer, (String)"buffer");
        Validate.inRange((int)startPosition, (String)"start position", (int)0, (int)endPosition);
        Validate.inRange((int)endPosition, (String)"end position", (int)startPosition, (int)buffer.capacity());
        MyBuffer.maxAbs((FloatBuffer)buffer, (int)startPosition, (int)endPosition, (Vector3f)this.halfExtents);
        this.createShape();
    }

    public BoxCollisionShape(Vector3f halfExtents) {
        Validate.nonNegative((Vector3f)halfExtents, (String)"half extents");
        this.halfExtents.set(halfExtents);
        this.createShape();
    }

    public Vector3f getHalfExtents(Vector3f storeResult) {
        assert (MyVector3f.isAllNonNegative((Vector3f)this.halfExtents)) : this.halfExtents;
        if (storeResult == null) {
            return this.halfExtents.clone();
        }
        return storeResult.set(this.halfExtents);
    }

    public float unscaledVolume() {
        float result = MyVolume.boxVolume((Vector3f)this.halfExtents);
        assert (result >= 0.0f) : result;
        return result;
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        super.cloneFields(cloner, original);
        this.halfExtents = (Vector3f)cloner.clone((Object)this.halfExtents);
        this.createShape();
    }

    @Override
    public BoxCollisionShape jmeClone() {
        try {
            BoxCollisionShape clone = (BoxCollisionShape)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public float maxRadius() {
        double xx = this.scale.x * this.halfExtents.x;
        double yy = this.scale.y * this.halfExtents.y;
        double zz = this.scale.z * this.halfExtents.z;
        float result = (float)MyMath.hypotenuseDouble((double[])new double[]{xx, yy, zz});
        return result;
    }

    @Override
    public void read(JmeImporter importer) throws IOException {
        super.read(importer);
        InputCapsule capsule = importer.getCapsule((Savable)this);
        Vector3f he = (Vector3f)capsule.readSavable(tagHalfExtents, (Savable)new Vector3f(1.0f, 1.0f, 1.0f));
        this.halfExtents.set(he);
        this.createShape();
    }

    @Override
    public void write(JmeExporter exporter) throws IOException {
        super.write(exporter);
        OutputCapsule capsule = exporter.getCapsule((Savable)this);
        capsule.write((Savable)this.halfExtents, tagHalfExtents, null);
    }

    private void createShape() {
        assert (MyVector3f.isAllNonNegative((Vector3f)this.halfExtents)) : this.halfExtents;
        long shapeId = BoxCollisionShape.createShape(this.halfExtents);
        this.setNativeId(shapeId);
        this.setContactFilterEnabled(this.enableContactFilter);
        this.setScale(this.scale);
        this.setMargin(this.margin);
    }

    private static native long createShape(Vector3f var0);
}

