/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.collision.shapes;

import com.jme3.bounding.BoundingBox;
import com.jme3.bullet.NativePhysicsObject;
import com.jme3.bullet.util.DebugShapeFactory;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Matrix3f;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.util.clone.Cloner;
import com.jme3.util.clone.JmeCloneable;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jme3utilities.Validate;
import jme3utilities.math.MyVector3f;
import jme3utilities.minie.MyShape;

public abstract class CollisionShape
extends NativePhysicsObject
implements JmeCloneable,
Savable {
    public static final Logger logger = Logger.getLogger(CollisionShape.class.getName());
    private static final Quaternion rotateIdentity = new Quaternion();
    private static final String tagEnableContactFilter = "enableContactFilter";
    private static final String tagMargin = "margin";
    private static final String tagScale = "scale";
    private static final Transform transformIdentity = new Transform();
    private static final Vector3f translateIdentity = new Vector3f(0.0f, 0.0f, 0.0f);
    protected boolean enableContactFilter = true;
    private static float defaultMargin = 0.04f;
    protected float margin = defaultMargin;
    protected Vector3f scale = new Vector3f(1.0f, 1.0f, 1.0f);

    public float aabbScaledVolume() {
        BoundingBox aabb = this.boundingBox(translateIdentity, rotateIdentity, null);
        Vector3f halfExtents = aabb.getExtent(null);
        float volume = 8.0f * halfExtents.x * halfExtents.y * halfExtents.z;
        assert (volume >= 0.0f) : volume;
        assert (Float.isFinite(volume)) : volume;
        return volume;
    }

    public BoundingBox boundingBox(Vector3f translation, Matrix3f rotation, BoundingBox storeResult) {
        Validate.finite((Vector3f)translation, (String)"translation");
        Validate.nonNull((Object)rotation, (String)"rotation");
        BoundingBox result = storeResult == null ? new BoundingBox() : storeResult;
        this.recalculateAabb();
        long shapeId = this.nativeId();
        Vector3f maxima = new Vector3f();
        Vector3f minima = new Vector3f();
        CollisionShape.getAabb(shapeId, translation, rotation, minima, maxima);
        result.setMinMax(minima, maxima);
        return result;
    }

    public BoundingBox boundingBox(Vector3f translation, Quaternion rotation, BoundingBox storeResult) {
        Validate.finite((Vector3f)translation, (String)"translation");
        Validate.nonNull((Object)rotation, (String)"rotation");
        BoundingBox result = storeResult == null ? new BoundingBox() : storeResult;
        this.recalculateAabb();
        long shapeId = this.nativeId();
        Matrix3f basisMatrix = new Matrix3f().set(rotation);
        Vector3f maxima = new Vector3f();
        Vector3f minima = new Vector3f();
        CollisionShape.getAabb(shapeId, translation, basisMatrix, minima, maxima);
        result.setMinMax(minima, maxima);
        return result;
    }

    public boolean canScale(Vector3f scale) {
        boolean result = scale == null ? false : MyVector3f.isAllNonNegative((Vector3f)scale);
        return result;
    }

    public static float getDefaultMargin() {
        assert (defaultMargin > 0.0f) : defaultMargin;
        return defaultMargin;
    }

    public float getMargin() {
        assert (this.margin > 0.0f) : this.margin;
        assert (this.margin == CollisionShape.getMargin(this.nativeId()));
        return this.margin;
    }

    public final long getObjectId() {
        long shapeId = this.nativeId();
        return shapeId;
    }

    public Vector3f getScale(Vector3f storeResult) {
        Vector3f result;
        Vector3f vector3f = result = storeResult == null ? new Vector3f() : storeResult;
        assert (this.checkScale(result));
        result.set(this.scale);
        return result;
    }

    public int getShapeType() {
        long shapeId = this.nativeId();
        int result = CollisionShape.getShapeType(shapeId);
        return result;
    }

    public boolean isConcave() {
        long shapeId = this.nativeId();
        boolean result = CollisionShape.isConcave(shapeId);
        return result;
    }

    public boolean isContactFilterEnabled() {
        assert (this.enableContactFilter == CollisionShape.isContactFilterEnabled(this.nativeId())) : this.enableContactFilter;
        return this.enableContactFilter;
    }

    public boolean isConvex() {
        long shapeId = this.nativeId();
        boolean result = CollisionShape.isConvex(shapeId);
        return result;
    }

    public boolean isInfinite() {
        long shapeId = this.nativeId();
        boolean result = CollisionShape.isInfinite(shapeId);
        return result;
    }

    public boolean isNonMoving() {
        long shapeId = this.nativeId();
        boolean result = CollisionShape.isNonMoving(shapeId);
        return result;
    }

    public boolean isPolyhedral() {
        long shapeId = this.nativeId();
        boolean result = CollisionShape.isPolyhedral(shapeId);
        return result;
    }

    public float maxRadius() {
        float result = DebugShapeFactory.maxDistance(this, transformIdentity, 0);
        return result;
    }

    public void setContactFilterEnabled(boolean setting) {
        long shapeId = this.nativeId();
        CollisionShape.setContactFilterEnabled(shapeId, setting);
        this.enableContactFilter = setting;
    }

    public static void setDefaultMargin(float margin) {
        Validate.positive((float)margin, (String)tagMargin);
        defaultMargin = margin;
    }

    public void setMargin(float margin) {
        Validate.positive((float)margin, (String)tagMargin);
        long shapeId = this.nativeId();
        CollisionShape.setMargin(shapeId, margin);
        logger.log(Level.FINE, "Margining {0}.", this);
        this.margin = margin;
    }

    public void setScale(float factor) {
        Validate.nonNegative((float)factor, (String)"factor");
        Vector3f scaleVector = new Vector3f(factor, factor, factor);
        this.setScale(scaleVector);
    }

    public void setScale(Vector3f scale) {
        Validate.nonNegative((Vector3f)scale, (String)tagScale);
        if (!this.canScale(scale)) {
            String typeName = this.getClass().getCanonicalName();
            String msg = String.format("%s cannot be scaled to (%s,%s,%s)", typeName, Float.valueOf(scale.x), Float.valueOf(scale.y), Float.valueOf(scale.z));
            throw new IllegalArgumentException(msg);
        }
        long shapeId = this.nativeId();
        CollisionShape.setLocalScaling(shapeId, scale);
        logger.log(Level.FINE, "Scaling {0}.", this);
        this.scale.set(scale);
    }

    protected static final native int getShapeType(long var0);

    protected void recalculateAabb() {
    }

    protected void updateScale() {
        long shapeId = this.nativeId();
        CollisionShape.getLocalScaling(shapeId, this.scale);
    }

    public void cloneFields(Cloner cloner, Object original) {
        this.scale = (Vector3f)cloner.clone((Object)this.scale);
        this.unassignNativeObject();
    }

    public CollisionShape jmeClone() {
        try {
            CollisionShape clone = (CollisionShape)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException exception) {
            throw new RuntimeException(exception);
        }
    }

    public void read(JmeImporter importer) throws IOException {
        InputCapsule capsule = importer.getCapsule((Savable)this);
        this.enableContactFilter = capsule.readBoolean(tagEnableContactFilter, false);
        Savable s = capsule.readSavable(tagScale, (Savable)new Vector3f(1.0f, 1.0f, 1.0f));
        this.scale.set((Vector3f)s);
        this.margin = capsule.readFloat(tagMargin, 0.04f);
    }

    public void write(JmeExporter exporter) throws IOException {
        OutputCapsule capsule = exporter.getCapsule((Savable)this);
        capsule.write(this.enableContactFilter, tagEnableContactFilter, false);
        capsule.write((Savable)this.scale, tagScale, null);
        capsule.write(this.margin, tagMargin, 0.04f);
    }

    @Override
    protected void setNativeId(long shapeId) {
        super.setNativeId(shapeId);
        logger.log(Level.FINE, "Created {0}.", this);
    }

    @Override
    public String toString() {
        String result = MyShape.describeType(this);
        long shapeId = this.nativeId();
        result = result + "#" + Long.toHexString(shapeId);
        return result;
    }

    private boolean checkScale(Vector3f storeVector) {
        assert (storeVector != null);
        long shapeId = this.nativeId();
        CollisionShape.getLocalScaling(shapeId, storeVector);
        boolean result = this.scale.equals((Object)storeVector);
        if (!result) {
            logger.log(Level.WARNING, "mismatch detected: shape={0} copy={1} native={2}", new Object[]{this, this.scale, storeVector});
        }
        return result;
    }

    private static void freeNativeObject(long shapeId) {
        assert (shapeId != 0L);
        DebugShapeFactory.removeShapeFromCache(shapeId);
        CollisionShape.finalizeNative(shapeId);
    }

    private static native void finalizeNative(long var0);

    private static native void getAabb(long var0, Vector3f var2, Matrix3f var3, Vector3f var4, Vector3f var5);

    private static native void getLocalScaling(long var0, Vector3f var2);

    private static native float getMargin(long var0);

    private static native boolean isConcave(long var0);

    private static native boolean isContactFilterEnabled(long var0);

    private static native boolean isConvex(long var0);

    private static native boolean isInfinite(long var0);

    private static native boolean isNonMoving(long var0);

    private static native boolean isPolyhedral(long var0);

    private static native void setContactFilterEnabled(long var0, boolean var2);

    private static native void setLocalScaling(long var0, Vector3f var2);

    private static native void setMargin(long var0, float var2);
}

