/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.collision.shapes;

import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.collision.shapes.infos.ChildCollisionShape;
import com.jme3.bullet.util.DebugShapeFactory;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Matrix3f;
import com.jme3.math.Matrix4f;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.util.clone.Cloner;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Logger;
import jme3utilities.Validate;

public class CompoundCollisionShape
extends CollisionShape {
    private static final int defaultCapacity = 6;
    public static final Logger logger2 = Logger.getLogger(CompoundCollisionShape.class.getName());
    private static final Matrix3f matrixIdentity = new Matrix3f();
    private static final String tagChildren = "children";
    private static final Vector3f translateIdentity = new Vector3f(0.0f, 0.0f, 0.0f);
    private ArrayList<ChildCollisionShape> children;

    public CompoundCollisionShape() {
        this.children = new ArrayList(6);
        this.createEmpty(6);
    }

    public CompoundCollisionShape(int initialCapacity) {
        Validate.positive((int)initialCapacity, (String)"initial capacity");
        this.children = new ArrayList(initialCapacity);
        this.createEmpty(initialCapacity);
    }

    public void addChildShape(CollisionShape childShape) {
        Validate.nonNull((Object)childShape, (String)"child shape");
        this.addChildShape(childShape, translateIdentity, matrixIdentity);
    }

    public void addChildShape(CollisionShape childShape, Vector3f offset) {
        Validate.nonNull((Object)childShape, (String)"child shape");
        Validate.nonNull((Object)offset, (String)"offset");
        this.addChildShape(childShape, offset, matrixIdentity);
    }

    public void addChildShape(CollisionShape childShape, float offsetX, float offsetY, float offsetZ) {
        Validate.nonNull((Object)childShape, (String)"child shape");
        Vector3f offset = new Vector3f(offsetX, offsetY, offsetZ);
        this.addChildShape(childShape, offset, matrixIdentity);
    }

    public void addChildShape(CollisionShape childShape, Vector3f offset, Matrix3f rotation) {
        if (childShape instanceof CompoundCollisionShape) {
            throw new IllegalArgumentException("A CompoundCollisionShape cannot have a CompoundCollisionShape child!");
        }
        long childId = childShape.nativeId();
        ChildCollisionShape child = new ChildCollisionShape(offset, rotation, childShape);
        this.children.add(child);
        long parentId = this.nativeId();
        CompoundCollisionShape.addChildShape(parentId, childId, offset, rotation);
    }

    public void addChildShape(CollisionShape shape, Transform transform) {
        Vector3f offset = transform.getTranslation();
        Matrix3f rotation = transform.getRotation().toRotationMatrix();
        this.addChildShape(shape, offset, rotation);
    }

    public void correctAxes(Transform paTransform) {
        Matrix4f tmpMatrix4f = new Matrix4f();
        paTransform.toTransformMatrix(tmpMatrix4f);
        tmpMatrix4f.invertLocal();
        Matrix3f rotation = new Matrix3f();
        tmpMatrix4f.toRotationMatrix(rotation);
        this.rotate(rotation);
        Vector3f offset = new Vector3f();
        tmpMatrix4f.toTranslationVector(offset);
        this.translate(offset);
    }

    public int countChildren() {
        int numChildren = this.children.size();
        assert (numChildren == CompoundCollisionShape.countChildren(this.nativeId()));
        return numChildren;
    }

    public int findIndex(CollisionShape childShape) {
        int result = -1;
        for (int index = 0; index < this.children.size(); ++index) {
            ChildCollisionShape ccs = this.children.get(index);
            CollisionShape shape = ccs.getShape();
            if (shape != childShape) continue;
            result = index;
            break;
        }
        return result;
    }

    public ChildCollisionShape[] listChildren() {
        int numChildren = this.children.size();
        ChildCollisionShape[] result = new ChildCollisionShape[numChildren];
        this.children.toArray(result);
        return result;
    }

    public Transform principalAxes(FloatBuffer masses, Transform storeTransform, Vector3f storeInertia) {
        if (!masses.isDirect()) {
            throw new IllegalArgumentException("The buffer must be direct.");
        }
        Transform result = storeTransform == null ? new Transform() : storeTransform;
        Validate.nonNull((Object)storeInertia, (String)"storage for inertia");
        long shapeId = this.nativeId();
        CompoundCollisionShape.calculatePrincipalAxisTransform(shapeId, masses, result, storeInertia);
        return result;
    }

    public void removeChildShape(CollisionShape childShape) {
        long childId = childShape.nativeId();
        long parentId = this.nativeId();
        CompoundCollisionShape.removeChildShape(parentId, childId);
        Iterator<ChildCollisionShape> it = this.children.iterator();
        while (it.hasNext()) {
            ChildCollisionShape childCollisionShape = it.next();
            if (childCollisionShape.getShape() != childShape) continue;
            it.remove();
        }
    }

    public void rotate(Matrix3f rotation) {
        Vector3f offset = new Vector3f();
        Matrix3f basis = new Matrix3f();
        for (ChildCollisionShape child : this.children) {
            child.copyOffset(offset);
            rotation.mult(offset, offset);
            child.copyRotationMatrix(basis);
            rotation.mult(basis, basis);
            child.setTransform(offset, basis);
        }
        long shapeId = this.nativeId();
        CompoundCollisionShape.rotate(shapeId, rotation);
    }

    public void setChildTransform(CollisionShape childShape, Transform transform) {
        long childId = childShape.nativeId();
        long parentId = this.nativeId();
        Vector3f offset = transform.getTranslation();
        int childIndex = this.findIndex(childShape);
        assert (childIndex >= 0) : childIndex;
        assert (childIndex < this.children.size());
        Matrix3f rotation = transform.getRotation().toRotationMatrix();
        CompoundCollisionShape.setChildTransform(parentId, childId, offset, rotation);
        ChildCollisionShape child = this.children.get(childIndex);
        child.setTransform(offset, rotation);
    }

    public void translate(Vector3f amount) {
        Vector3f offset = new Vector3f();
        Matrix3f basis = new Matrix3f();
        for (ChildCollisionShape child : this.children) {
            child.copyOffset(offset);
            offset.addLocal(amount);
            child.copyRotationMatrix(basis);
            child.setTransform(offset, basis);
        }
        long shapeId = this.nativeId();
        CompoundCollisionShape.translate(shapeId, amount);
    }

    @Override
    public boolean canScale(Vector3f scale) {
        boolean result = super.canScale(scale);
        if (result) {
            for (ChildCollisionShape child : this.children) {
                CollisionShape childShape = child.getShape();
                if (childShape.canScale(scale)) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        super.cloneFields(cloner, original);
        this.children = (ArrayList)cloner.clone(this.children);
        this.createEmpty(this.children.size());
        this.loadChildren();
    }

    @Override
    public CompoundCollisionShape jmeClone() {
        try {
            CompoundCollisionShape clone = (CompoundCollisionShape)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public float maxRadius() {
        float result = 0.0f;
        Transform tmpTransform = new Transform();
        for (ChildCollisionShape child : this.children) {
            CollisionShape childShape = child.getShape();
            child.copyOffset(tmpTransform.getTranslation());
            tmpTransform.getTranslation().multLocal(this.scale);
            child.copyRotation(tmpTransform.getRotation());
            float childRadius = DebugShapeFactory.maxDistance(childShape, tmpTransform, 0);
            if (!(childRadius > result)) continue;
            result = childRadius;
        }
        return result;
    }

    @Override
    public void read(JmeImporter importer) throws IOException {
        super.read(importer);
        InputCapsule capsule = importer.getCapsule((Savable)this);
        this.children = capsule.readSavableArrayList(tagChildren, null);
        this.loadChildren();
        this.setContactFilterEnabled(this.enableContactFilter);
        this.setScale(this.scale);
        this.setMargin(this.margin);
    }

    @Override
    protected void recalculateAabb() {
        long nativeId = this.nativeId();
        CompoundCollisionShape.recalcAabb(nativeId);
    }

    @Override
    public void setScale(Vector3f scale) {
        super.setScale(scale);
        for (ChildCollisionShape child : this.children) {
            CollisionShape childShape = child.getShape();
            childShape.updateScale();
        }
    }

    @Override
    public void write(JmeExporter exporter) throws IOException {
        super.write(exporter);
        OutputCapsule capsule = exporter.getCapsule((Savable)this);
        capsule.writeSavableArrayList(this.children, tagChildren, null);
    }

    private void createEmpty(int initialCapacity) {
        assert (initialCapacity > 0) : initialCapacity;
        boolean enableAabbTree = true;
        long shapeId = CompoundCollisionShape.createShape2(enableAabbTree, initialCapacity);
        this.setNativeId(shapeId);
        this.setContactFilterEnabled(this.enableContactFilter);
        this.setScale(this.scale);
        this.setMargin(this.margin);
    }

    private void loadChildren() {
        long parentId = this.nativeId();
        for (ChildCollisionShape child : this.children) {
            CompoundCollisionShape.addChildShape(parentId, child.getShape().nativeId(), child.copyOffset(null), child.copyRotationMatrix(null));
        }
    }

    private static native void addChildShape(long var0, long var2, Vector3f var4, Matrix3f var5);

    private static native void calculatePrincipalAxisTransform(long var0, FloatBuffer var2, Transform var3, Vector3f var4);

    private static native int countChildren(long var0);

    private static native long createShape2(boolean var0, int var1);

    private static native void recalcAabb(long var0);

    private static native void removeChildShape(long var0, long var2);

    private static native void rotate(long var0, Matrix3f var2);

    private static native void setChildTransform(long var0, long var2, Vector3f var4, Matrix3f var5);

    private static native void translate(long var0, Vector3f var2);
}

