/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.collision.shapes;

import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.collision.shapes.ConvexShape;
import com.jme3.bullet.collision.shapes.HullCollisionShape;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Vector3f;
import com.jme3.util.clone.Cloner;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.util.logging.Logger;
import jme3utilities.Validate;

public class Convex2dShape
extends ConvexShape {
    public static final Logger logger2 = Logger.getLogger(Convex2dShape.class.getName());
    private static final String tagBase = "base";
    private ConvexShape base;

    protected Convex2dShape() {
    }

    public Convex2dShape(ConvexShape base) {
        this.base = base;
        this.createShape();
    }

    public Convex2dShape(FloatBuffer flippedBuffer) {
        Validate.nonNull((Object)flippedBuffer, (String)"flipped buffer");
        int numFloats = flippedBuffer.limit();
        assert (numFloats > 0) : numFloats;
        assert (numFloats % 3 == 0) : numFloats;
        this.base = new HullCollisionShape(flippedBuffer);
        this.createShape();
    }

    public CollisionShape getBaseShape() {
        assert (this.base != null);
        return this.base;
    }

    @Override
    public boolean canScale(Vector3f scale) {
        boolean result = this.base.canScale(scale);
        return result;
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        super.cloneFields(cloner, original);
        this.base = (ConvexShape)cloner.clone((Object)this.base);
        this.createShape();
    }

    @Override
    public Convex2dShape jmeClone() {
        try {
            Convex2dShape clone = (Convex2dShape)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public void read(JmeImporter importer) throws IOException {
        super.read(importer);
        InputCapsule capsule = importer.getCapsule((Savable)this);
        this.base = (ConvexShape)capsule.readSavable(tagBase, null);
        this.createShape();
    }

    @Override
    public void setScale(Vector3f scale) {
        super.setScale(scale);
        this.base.updateScale();
    }

    @Override
    public void write(JmeExporter exporter) throws IOException {
        super.write(exporter);
        OutputCapsule capsule = exporter.getCapsule((Savable)this);
        capsule.write((Savable)this.base, tagBase, null);
    }

    private void createShape() {
        long childId = this.base.nativeId();
        long shapeId = Convex2dShape.createShape(childId);
        this.setNativeId(shapeId);
        this.setContactFilterEnabled(this.enableContactFilter);
        this.setScale(this.scale);
        this.setMargin(this.margin);
    }

    private static native long createShape(long var0);
}

