/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.collision.shapes;

import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.collision.shapes.infos.CompoundMesh;
import com.jme3.bullet.collision.shapes.infos.IndexedMesh;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Vector3f;
import com.jme3.scene.Mesh;
import com.jme3.util.clone.Cloner;
import java.io.IOException;
import java.util.logging.Logger;

public class GImpactCollisionShape
extends CollisionShape {
    public static final Logger logger2 = Logger.getLogger(GImpactCollisionShape.class.getName());
    private static final String tagNativeMesh = "nativeMesh";
    private CompoundMesh nativeMesh;

    protected GImpactCollisionShape() {
    }

    public GImpactCollisionShape(IndexedMesh ... submeshes) {
        this.nativeMesh = new CompoundMesh();
        for (IndexedMesh submesh : submeshes) {
            this.nativeMesh.add(submesh);
        }
        this.createShape();
    }

    public GImpactCollisionShape(Mesh ... jmeMeshes) {
        this.nativeMesh = new CompoundMesh(jmeMeshes);
        this.createShape();
    }

    public int countMeshVertices() {
        int numVertices = this.nativeMesh.countVertices();
        return numVertices;
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        super.cloneFields(cloner, original);
        this.nativeMesh = (CompoundMesh)cloner.clone((Object)this.nativeMesh);
        this.createShape();
    }

    @Override
    public GImpactCollisionShape jmeClone() {
        try {
            GImpactCollisionShape clone = (GImpactCollisionShape)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public void read(JmeImporter importer) throws IOException {
        super.read(importer);
        InputCapsule capsule = importer.getCapsule((Savable)this);
        this.nativeMesh = (CompoundMesh)capsule.readSavable(tagNativeMesh, null);
        this.createShape();
    }

    @Override
    protected void recalculateAabb() {
        long shapeId = this.nativeId();
        GImpactCollisionShape.recalcAabb(shapeId);
    }

    @Override
    public void setScale(Vector3f scale) {
        super.setScale(scale);
        this.recalculateAabb();
    }

    @Override
    public void write(JmeExporter exporter) throws IOException {
        super.write(exporter);
        OutputCapsule capsule = exporter.getCapsule((Savable)this);
        capsule.write((Savable)this.nativeMesh, tagNativeMesh, null);
    }

    private void createShape() {
        long meshId = this.nativeMesh.nativeId();
        long shapeId = GImpactCollisionShape.createShape(meshId);
        this.setNativeId(shapeId);
        this.setContactFilterEnabled(this.enableContactFilter);
        this.setScale(this.scale);
        this.setMargin(this.margin);
    }

    private static native long createShape(long var0);

    private static native void recalcAabb(long var0);
}

