/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.collision.shapes;

import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.FastMath;
import com.jme3.math.Vector3f;
import com.jme3.terrain.Terrain;
import com.jme3.terrain.heightmap.HeightMap;
import com.jme3.util.BufferUtils;
import com.jme3.util.clone.Cloner;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.util.logging.Logger;
import jme3utilities.Validate;

public class HeightfieldCollisionShape
extends CollisionShape {
    public static final Logger logger2 = Logger.getLogger(HeightfieldCollisionShape.class.getName());
    private static final String tagFlipQuadEdges = "flipQuadEdges";
    private static final String tagFlipTriangleWinding = "flipTriangleWinding";
    private static final String tagHeightfieldData = "heightfieldData";
    private static final String tagHeightScale = "heightScale";
    private static final String tagHeightStickLength = "heightStickLength";
    private static final String tagHeightStickWidth = "heightStickWidth";
    private static final String tagMaxHeight = "maxHeight";
    private static final String tagMinHeight = "minHeight";
    private static final String tagUpAxis = "upAxis";
    private static final String tagUseDiamond = "useDiamond";
    private static final String tagUseZigzag = "useZigzag";
    private static final Vector3f scaleIdentity = new Vector3f(1.0f, 1.0f, 1.0f);
    private boolean flipQuadEdges = true;
    private boolean flipTriangleWinding = false;
    private boolean useDiamond = false;
    private boolean useZigzag = false;
    private float heightScale = 1.0f;
    private float maxHeight;
    private float minHeight;
    private float[] heightfieldData;
    private FloatBuffer directBuffer;
    private int heightStickLength;
    private int heightStickWidth;
    private int upAxis = 1;

    protected HeightfieldCollisionShape() {
    }

    public HeightfieldCollisionShape(float[] heightmap) {
        Validate.nonEmpty((float[])heightmap, (String)"heightmap");
        assert (heightmap.length >= 4) : heightmap.length;
        this.createCollisionHeightfield(heightmap, scaleIdentity);
    }

    public HeightfieldCollisionShape(HeightMap heightMap) {
        float[] array = heightMap.getHeightMap();
        if (array == null) {
            boolean success = heightMap.load();
            assert (success);
            array = heightMap.getHeightMap();
            assert (array != null);
        }
        assert (array.length >= 4) : array.length;
        this.createCollisionHeightfield(array, scaleIdentity);
    }

    public HeightfieldCollisionShape(float[] heightmap, Vector3f scale) {
        Validate.nonEmpty((float[])heightmap, (String)"heightmap");
        assert (heightmap.length >= 4) : heightmap.length;
        Validate.nonNegative((Vector3f)scale, (String)"scale");
        this.createCollisionHeightfield(heightmap, scale);
    }

    public HeightfieldCollisionShape(Terrain terrain, Vector3f scale) {
        Validate.nonNegative((Vector3f)scale, (String)"scale");
        Validate.inRange((int)terrain.getTerrainSize(), (String)"terrain size", (int)2, (int)Integer.MAX_VALUE);
        float[] heightmap = terrain.getHeightMap();
        assert (heightmap.length >= 4) : heightmap.length;
        this.createCollisionHeightfield(heightmap, scale);
    }

    public HeightfieldCollisionShape(int stickLength, int stickWidth, float[] heightmap, Vector3f scale, int upAxis, boolean flipQuadEdges, boolean flipTriangleWinding, boolean useDiamond, boolean useZigzag) {
        Validate.inRange((int)stickLength, (String)"stick length", (int)2, (int)Integer.MAX_VALUE);
        Validate.inRange((int)stickWidth, (String)"stick width", (int)2, (int)Integer.MAX_VALUE);
        Validate.nonEmpty((float[])heightmap, (String)"heightmap");
        assert (heightmap.length >= stickLength * stickWidth) : heightmap.length;
        Validate.nonNegative((Vector3f)scale, (String)"scale");
        Validate.axisIndex((int)upAxis, (String)"up axis");
        this.heightStickLength = stickLength;
        this.heightStickWidth = stickWidth;
        this.heightfieldData = (float[])heightmap.clone();
        this.scale.set(scale);
        this.upAxis = upAxis;
        this.flipQuadEdges = flipQuadEdges;
        this.flipTriangleWinding = flipTriangleWinding;
        this.useDiamond = useDiamond;
        this.useZigzag = useZigzag;
        this.calculateMinAndMax();
        this.createShape();
    }

    public int countMeshVertices() {
        int count = this.heightfieldData.length;
        assert (count > 0) : count;
        return count;
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        super.cloneFields(cloner, original);
        this.createShape();
    }

    @Override
    public HeightfieldCollisionShape jmeClone() {
        try {
            HeightfieldCollisionShape clone = (HeightfieldCollisionShape)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public void read(JmeImporter importer) throws IOException {
        super.read(importer);
        InputCapsule capsule = importer.getCapsule((Savable)this);
        this.heightStickWidth = capsule.readInt(tagHeightStickWidth, 0);
        this.heightStickLength = capsule.readInt(tagHeightStickLength, 0);
        this.heightScale = capsule.readFloat(tagHeightScale, 0.0f);
        this.minHeight = capsule.readFloat(tagMinHeight, 0.0f);
        this.maxHeight = capsule.readFloat(tagMaxHeight, 0.0f);
        this.upAxis = capsule.readInt(tagUpAxis, 1);
        this.heightfieldData = capsule.readFloatArray(tagHeightfieldData, new float[0]);
        this.flipQuadEdges = capsule.readBoolean(tagFlipQuadEdges, true);
        this.flipTriangleWinding = capsule.readBoolean(tagFlipTriangleWinding, false);
        this.useDiamond = capsule.readBoolean(tagUseDiamond, false);
        this.useZigzag = capsule.readBoolean(tagUseZigzag, false);
        this.createShape();
    }

    @Override
    public void write(JmeExporter exporter) throws IOException {
        super.write(exporter);
        OutputCapsule capsule = exporter.getCapsule((Savable)this);
        capsule.write(this.heightStickWidth, tagHeightStickWidth, 0);
        capsule.write(this.heightStickLength, tagHeightStickLength, 0);
        capsule.write(this.heightScale, tagHeightScale, 0.0f);
        capsule.write(this.minHeight, tagMinHeight, 0.0f);
        capsule.write(this.maxHeight, tagMaxHeight, 0.0f);
        capsule.write(this.upAxis, tagUpAxis, 1);
        capsule.write(this.heightfieldData, tagHeightfieldData, new float[0]);
        capsule.write(this.flipQuadEdges, tagFlipQuadEdges, true);
        capsule.write(this.flipTriangleWinding, tagFlipTriangleWinding, false);
        capsule.write(this.useDiamond, tagUseDiamond, false);
        capsule.write(this.useZigzag, tagUseZigzag, false);
    }

    private void calculateMinAndMax() {
        int elements = this.heightStickLength * this.heightStickWidth;
        assert (elements == this.heightfieldData.length) : this.heightfieldData.length;
        float min = this.heightfieldData[0];
        float max = this.heightfieldData[0];
        for (float height : this.heightfieldData) {
            if (height < min) {
                min = height;
            }
            if (!(height > max)) continue;
            max = height;
        }
        if (max < 0.0f) {
            max = -min;
        } else if (Math.abs(max) > Math.abs(min)) {
            min = -max;
        } else {
            max = -min;
        }
        this.minHeight = min;
        this.maxHeight = max;
    }

    private void createCollisionHeightfield(float[] heightmap, Vector3f worldScale) {
        this.scale.set(worldScale);
        this.heightfieldData = (float[])heightmap.clone();
        this.heightStickWidth = (int)FastMath.sqrt((float)this.heightfieldData.length);
        assert (this.heightStickWidth > 1) : this.heightStickWidth;
        this.heightStickLength = this.heightStickWidth;
        this.calculateMinAndMax();
        this.createShape();
    }

    private void createShape() {
        this.directBuffer = BufferUtils.createFloatBuffer((int)this.heightfieldData.length);
        for (float height : this.heightfieldData) {
            if (!Float.isFinite(height)) {
                throw new IllegalArgumentException("illegal height: " + height);
            }
            this.directBuffer.put(height);
        }
        long shapeId = HeightfieldCollisionShape.createShape2(this.heightStickWidth, this.heightStickLength, this.directBuffer, this.heightScale, this.minHeight, this.maxHeight, this.upAxis, this.flipQuadEdges, this.flipTriangleWinding, this.useDiamond, this.useZigzag);
        this.setNativeId(shapeId);
        this.setContactFilterEnabled(this.enableContactFilter);
        this.setScale(this.scale);
        this.setMargin(this.margin);
    }

    private static void freeNativeObject(long shapeId) {
        assert (shapeId != 0L);
        HeightfieldCollisionShape.finalizeNative(shapeId);
    }

    private static native long createShape2(int var0, int var1, FloatBuffer var2, float var3, float var4, float var5, int var6, boolean var7, boolean var8, boolean var9, boolean var10);

    private static native void finalizeNative(long var0);
}

