/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.collision.shapes;

import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.collision.shapes.infos.BoundingValueHierarchy;
import com.jme3.bullet.collision.shapes.infos.CompoundMesh;
import com.jme3.bullet.collision.shapes.infos.IndexedMesh;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.scene.Mesh;
import com.jme3.system.JmeSystem;
import com.jme3.system.Platform;
import com.jme3.util.clone.Cloner;
import java.io.IOException;
import java.util.Collection;
import java.util.logging.Logger;
import jme3utilities.Validate;

public class MeshCollisionShape
extends CollisionShape {
    public static final Logger logger2 = Logger.getLogger(MeshCollisionShape.class.getName());
    private static final String tagBvh = "bvh";
    private static final String tagNativePlatform = "nativePlatform";
    private static final String tagNativeMesh = "nativeMesh";
    private static final String tagUseCompression = "useCompression";
    private boolean useCompression;
    private BoundingValueHierarchy bvh;
    private CompoundMesh nativeMesh;

    protected MeshCollisionShape() {
    }

    public MeshCollisionShape(boolean useCompression, Collection<IndexedMesh> meshes) {
        Validate.nonEmpty(meshes, (String)"meshes");
        this.nativeMesh = new CompoundMesh();
        for (IndexedMesh submesh : meshes) {
            this.nativeMesh.add(submesh);
        }
        Validate.require((this.nativeMesh.countTriangles() > 0 ? 1 : 0) != 0, (String)"at least one triangle");
        this.useCompression = useCompression;
        this.createShape();
    }

    public MeshCollisionShape(boolean useCompression, IndexedMesh ... submeshes) {
        Validate.nonEmpty((Object[])submeshes, (String)"submeshes");
        this.nativeMesh = new CompoundMesh();
        for (IndexedMesh submesh : submeshes) {
            this.nativeMesh.add(submesh);
        }
        Validate.require((this.nativeMesh.countTriangles() > 0 ? 1 : 0) != 0, (String)"at least one triangle");
        this.useCompression = useCompression;
        this.createShape();
    }

    public MeshCollisionShape(byte[] bvhBytes, IndexedMesh ... submeshes) {
        Validate.nonNull((Object)bvhBytes, (String)"BVH data");
        Validate.nonEmpty((Object[])submeshes, (String)"submeshes");
        this.nativeMesh = new CompoundMesh();
        for (IndexedMesh submesh : submeshes) {
            this.nativeMesh.add(submesh);
        }
        Validate.require((this.nativeMesh.countTriangles() > 0 ? 1 : 0) != 0, (String)"at least one triangle");
        this.useCompression = true;
        this.bvh = new BoundingValueHierarchy(bvhBytes);
        this.createShape();
    }

    public MeshCollisionShape(Mesh ... jmeMeshes) {
        Validate.nonEmpty((Object[])jmeMeshes, (String)"JME meshes");
        this.nativeMesh = new CompoundMesh(jmeMeshes);
        Validate.require((this.nativeMesh.countTriangles() > 0 ? 1 : 0) != 0, (String)"at least one triangle");
        this.useCompression = true;
        this.createShape();
    }

    public MeshCollisionShape(Mesh mesh, boolean useCompression) {
        Validate.nonNull((Object)mesh, (String)"mesh");
        this.nativeMesh = new CompoundMesh(mesh);
        Validate.require((this.nativeMesh.countTriangles() > 0 ? 1 : 0) != 0, (String)"at least one triangle");
        this.useCompression = useCompression;
        this.createShape();
    }

    public int countMeshTriangles() {
        int result = this.nativeMesh.countTriangles();
        return result;
    }

    public int countMeshVertices() {
        int numVertices = this.nativeMesh.countVertices();
        return numVertices;
    }

    public byte[] serializeBvh() {
        byte[] result = this.bvh.serialize();
        return result;
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        super.cloneFields(cloner, original);
        this.nativeMesh = (CompoundMesh)cloner.clone((Object)this.nativeMesh);
        this.bvh = (BoundingValueHierarchy)cloner.clone((Object)this.bvh);
        this.createShape();
    }

    @Override
    public MeshCollisionShape jmeClone() {
        try {
            MeshCollisionShape clone = (MeshCollisionShape)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public void read(JmeImporter importer) throws IOException {
        super.read(importer);
        InputCapsule capsule = importer.getCapsule((Savable)this);
        Platform writePlatform = (Platform)capsule.readEnum(tagNativePlatform, Platform.class, null);
        this.bvh = writePlatform == null || writePlatform != JmeSystem.getPlatform() ? null : (BoundingValueHierarchy)capsule.readSavable(tagBvh, null);
        this.nativeMesh = (CompoundMesh)capsule.readSavable(tagNativeMesh, null);
        this.useCompression = capsule.readBoolean(tagUseCompression, true);
        this.createShape();
    }

    @Override
    protected void recalculateAabb() {
        long shapeId = this.nativeId();
        MeshCollisionShape.recalcAabb(shapeId);
    }

    @Override
    public void write(JmeExporter exporter) throws IOException {
        super.write(exporter);
        OutputCapsule capsule = exporter.getCapsule((Savable)this);
        capsule.write((Savable)this.bvh, tagBvh, null);
        Platform nativePlatform = JmeSystem.getPlatform();
        capsule.write((Enum)nativePlatform, tagNativePlatform, null);
        capsule.write((Savable)this.nativeMesh, tagNativeMesh, null);
        capsule.write(this.useCompression, tagUseCompression, true);
    }

    private void createShape() {
        int numTriangles = this.nativeMesh.countTriangles();
        assert (numTriangles > 0) : numTriangles;
        boolean buildBvh = this.bvh == null;
        long meshId = this.nativeMesh.nativeId();
        long shapeId = MeshCollisionShape.createShape(this.useCompression, buildBvh, meshId);
        this.setNativeId(shapeId);
        if (buildBvh) {
            this.bvh = new BoundingValueHierarchy(this);
        } else {
            long bvhId = this.bvh.nativeId();
            MeshCollisionShape.setOptimizedBvh(shapeId, bvhId);
        }
        this.setContactFilterEnabled(this.enableContactFilter);
        this.setScale(this.scale);
        this.setMargin(this.margin);
    }

    private static native long createShape(boolean var0, boolean var1, long var2);

    private static native void recalcAabb(long var0);

    private static native void setOptimizedBvh(long var0, long var2);
}

