/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.collision.shapes;

import com.jme3.bounding.BoundingSphere;
import com.jme3.bullet.collision.shapes.ConvexShape;
import com.jme3.bullet.util.DebugShapeFactory;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Vector3f;
import com.jme3.util.clone.Cloner;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import jme3utilities.Validate;
import jme3utilities.math.MyMath;
import jme3utilities.math.MyVector3f;
import jme3utilities.math.MyVolume;
import jme3utilities.math.RectangularSolid;

public class MultiSphere
extends ConvexShape {
    public static final Logger logger2 = Logger.getLogger(MultiSphere.class.getName());
    private static final String tagCenters = "centers";
    private static final String tagRadii = "radii";
    private float[] radii;
    private Vector3f[] centers;

    protected MultiSphere() {
    }

    public MultiSphere(float radius) {
        Validate.nonNegative((float)radius, (String)"radius");
        this.centers = new Vector3f[1];
        this.centers[0] = new Vector3f(0.0f, 0.0f, 0.0f);
        this.radii = new float[1];
        this.radii[0] = radius;
        this.createShape();
    }

    public MultiSphere(float radius, float height) {
        Validate.nonNegative((float)radius, (String)"radius");
        Validate.nonNegative((float)height, (String)"height");
        float halfHeight = height / 2.0f;
        this.centers = new Vector3f[2];
        this.centers[0] = new Vector3f(0.0f, halfHeight, 0.0f);
        this.centers[1] = new Vector3f(0.0f, -halfHeight, 0.0f);
        this.radii = new float[2];
        this.radii[0] = radius;
        this.radii[1] = radius;
        this.createShape();
    }

    public MultiSphere(float radius, float height, int axisIndex) {
        Validate.nonNegative((float)radius, (String)"radius");
        Validate.nonNegative((float)height, (String)"height");
        float halfHeight = height / 2.0f;
        this.centers = new Vector3f[2];
        switch (axisIndex) {
            case 0: {
                this.centers[0] = new Vector3f(halfHeight, 0.0f, 0.0f);
                this.centers[1] = new Vector3f(-halfHeight, 0.0f, 0.0f);
                break;
            }
            case 1: {
                this.centers[0] = new Vector3f(0.0f, halfHeight, 0.0f);
                this.centers[1] = new Vector3f(0.0f, -halfHeight, 0.0f);
                break;
            }
            case 2: {
                this.centers[0] = new Vector3f(0.0f, 0.0f, halfHeight);
                this.centers[1] = new Vector3f(0.0f, 0.0f, -halfHeight);
                break;
            }
            default: {
                throw new IllegalArgumentException("axisIndex = " + axisIndex);
            }
        }
        this.radii = new float[2];
        this.radii[0] = radius;
        this.radii[1] = radius;
        this.createShape();
    }

    public MultiSphere(BoundingSphere boundingSphere) {
        this.centers = new Vector3f[1];
        this.centers[0] = boundingSphere.getCenter().clone();
        this.radii = new float[1];
        this.radii[0] = boundingSphere.getRadius();
        this.createShape();
    }

    public MultiSphere(List<Vector3f> centers, List<Float> radii) {
        Validate.nonEmpty(centers, (String)tagCenters);
        Validate.nonEmpty(radii, (String)tagRadii);
        int numSpheres = radii.size();
        Validate.require((centers.size() == numSpheres ? 1 : 0) != 0, (String)"lists of equal length");
        this.centers = new Vector3f[numSpheres];
        this.radii = new float[numSpheres];
        for (int i = 0; i < numSpheres; ++i) {
            this.centers[i] = centers.get(i).clone();
            float radius = radii.get(i).floatValue();
            assert (radius >= 0.0f) : radius;
            this.radii[i] = radius;
        }
        this.createShape();
    }

    public MultiSphere(RectangularSolid rectangularSolid) {
        Vector3f halfExtents = rectangularSolid.halfExtents(null);
        float radius = MyMath.min((float[])new float[]{halfExtents.x, halfExtents.y, halfExtents.z});
        Vector3f max = rectangularSolid.maxima(null);
        max.subtractLocal(radius, radius, radius);
        Vector3f min = rectangularSolid.minima(null);
        min.addLocal(radius, radius, radius);
        ArrayList<Vector3f> centerLocations = new ArrayList<Vector3f>(4);
        if (radius == halfExtents.x) {
            float x = max.x;
            centerLocations.add(new Vector3f(x, max.y, max.z));
            centerLocations.add(new Vector3f(x, max.y, min.z));
            centerLocations.add(new Vector3f(x, min.y, max.z));
            centerLocations.add(new Vector3f(x, min.y, min.z));
        } else if (radius == halfExtents.y) {
            float y = max.y;
            centerLocations.add(new Vector3f(max.x, y, max.z));
            centerLocations.add(new Vector3f(max.x, y, min.z));
            centerLocations.add(new Vector3f(min.x, y, max.z));
            centerLocations.add(new Vector3f(min.x, y, min.z));
        } else {
            assert (radius == halfExtents.z);
            float z = max.z;
            centerLocations.add(new Vector3f(max.x, max.y, z));
            centerLocations.add(new Vector3f(max.x, min.y, z));
            centerLocations.add(new Vector3f(min.x, max.y, z));
            centerLocations.add(new Vector3f(min.x, min.y, z));
        }
        this.centers = new Vector3f[4];
        this.radii = new float[4];
        for (int sphereI = 0; sphereI < 4; ++sphereI) {
            Vector3f localCenter = (Vector3f)centerLocations.get(sphereI);
            this.centers[sphereI] = rectangularSolid.localToWorld(localCenter, null);
            this.radii[sphereI] = radius;
        }
        this.createShape();
    }

    public MultiSphere(RectangularSolid rectangularSolid, float fraction) {
        Vector3f halfExtents = rectangularSolid.halfExtents(null);
        float shortest = MyMath.min((float[])new float[]{halfExtents.x, halfExtents.y, halfExtents.z});
        float medium = MyMath.mid((float)halfExtents.x, (float)halfExtents.y, (float)halfExtents.z);
        float radius = MyMath.lerp((float)fraction, (float)shortest, (float)medium);
        float longest = MyMath.max((float[])new float[]{halfExtents.x, halfExtents.y, halfExtents.z});
        assert (longest >= radius);
        Vector3f max = rectangularSolid.maxima(null);
        Vector3f min = rectangularSolid.minima(null);
        Vector3f mid = MyVector3f.midpoint((Vector3f)max, (Vector3f)min, null);
        ArrayList<Vector3f> centerLocations = new ArrayList<Vector3f>(2);
        if (longest == halfExtents.z) {
            centerLocations.add(new Vector3f(mid.x, mid.y, min.z + radius));
            centerLocations.add(new Vector3f(mid.x, mid.y, max.z - radius));
        } else if (longest == halfExtents.y) {
            centerLocations.add(new Vector3f(mid.x, min.y + radius, mid.z));
            centerLocations.add(new Vector3f(mid.x, max.y - radius, mid.z));
        } else {
            assert (longest == halfExtents.x);
            centerLocations.add(new Vector3f(min.x + radius, mid.y, mid.z));
            centerLocations.add(new Vector3f(max.x - radius, mid.y, mid.z));
        }
        this.centers = new Vector3f[2];
        this.radii = new float[2];
        for (int sphereI = 0; sphereI < 2; ++sphereI) {
            Vector3f localCenter = (Vector3f)centerLocations.get(sphereI);
            this.centers[sphereI] = rectangularSolid.localToWorld(localCenter, null);
            this.radii[sphereI] = radius;
        }
        this.createShape();
    }

    public MultiSphere(Vector3f center, float radius) {
        Validate.finite((Vector3f)center, (String)"center");
        Validate.nonNegative((float)radius, (String)"radius");
        this.centers = new Vector3f[1];
        this.centers[0] = center.clone();
        this.radii = new float[1];
        this.radii[0] = radius;
        this.createShape();
    }

    public Vector3f copyCenter(int sphereIndex, Vector3f storeResult) {
        Validate.inRange((int)sphereIndex, (String)"sphere index", (int)0, (int)(this.radii.length - 1));
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        result.set(this.centers[sphereIndex]);
        return result;
    }

    public int countSpheres() {
        int count = this.radii.length;
        assert (count > 0) : count;
        return count;
    }

    public float getRadius(int sphereIndex) {
        Validate.inRange((int)sphereIndex, (String)"sphere index", (int)0, (int)(this.radii.length - 1));
        float radius = this.radii[sphereIndex];
        assert (radius >= 0.0f) : radius;
        return radius;
    }

    public float scaledVolume() {
        float volume;
        int numSpheres = this.radii.length;
        if (numSpheres == 1) {
            float radius = this.radii[0];
            float unscaledVolume = MyVolume.sphereVolume((float)radius);
            volume = unscaledVolume * this.scale.x * this.scale.y * this.scale.z;
        } else if (numSpheres == 2 && this.radii[0] == this.radii[1]) {
            float radius = this.radii[0];
            float height = this.centers[0].distance(this.centers[1]);
            float unscaledVolume = MyVolume.capsuleVolume((float)radius, (float)height);
            volume = unscaledVolume * this.scale.x * this.scale.y * this.scale.z;
        } else {
            int meshResolution = 0;
            volume = DebugShapeFactory.volumeConvex(this, meshResolution);
        }
        assert (volume >= 0.0f) : volume;
        return volume;
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        super.cloneFields(cloner, original);
        this.radii = (float[])cloner.clone((Object)this.radii);
        this.centers = (Vector3f[])cloner.clone((Object)this.centers);
        this.createShape();
    }

    @Override
    public MultiSphere jmeClone() {
        try {
            MultiSphere clone = (MultiSphere)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public void read(JmeImporter importer) throws IOException {
        super.read(importer);
        InputCapsule capsule = importer.getCapsule((Savable)this);
        Savable[] savCenters = capsule.readSavableArray(tagCenters, (Savable[])new Vector3f[0]);
        int numSpheres = savCenters.length;
        this.centers = new Vector3f[numSpheres];
        for (int sphereIndex = 0; sphereIndex < numSpheres; ++sphereIndex) {
            this.centers[sphereIndex] = (Vector3f)savCenters[sphereIndex];
        }
        this.radii = capsule.readFloatArray(tagRadii, new float[0]);
        this.createShape();
    }

    @Override
    protected void recalculateAabb() {
        long shapeId = this.nativeId();
        MultiSphere.recalcAabb(shapeId);
    }

    @Override
    public void write(JmeExporter exporter) throws IOException {
        super.write(exporter);
        OutputCapsule capsule = exporter.getCapsule((Savable)this);
        capsule.write((Savable[])this.centers, tagCenters, null);
        capsule.write(this.radii, tagRadii, null);
    }

    private void createShape() {
        int numSpheres = this.radii.length;
        assert (this.centers.length == numSpheres) : numSpheres;
        long shapeId = MultiSphere.createShape(this.centers, this.radii, numSpheres);
        this.setNativeId(shapeId);
        this.setContactFilterEnabled(this.enableContactFilter);
        this.setScale(this.scale);
        this.setMargin(this.margin);
    }

    private static native long createShape(Vector3f[] var0, float[] var1, int var2);

    private static native void recalcAabb(long var0);
}

