/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.collision.shapes;

import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Plane;
import com.jme3.math.Vector3f;
import com.jme3.util.clone.Cloner;
import java.io.IOException;
import java.util.logging.Logger;

public class PlaneCollisionShape
extends CollisionShape {
    public static final Logger logger2 = Logger.getLogger(PlaneCollisionShape.class.getName());
    private static final String tagCollisionPlane = "collisionPlane";
    private Plane plane;

    protected PlaneCollisionShape() {
    }

    public PlaneCollisionShape(Plane plane) {
        this.plane = plane.clone();
        this.createShape();
    }

    public final Plane getPlane() {
        return this.plane.clone();
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        super.cloneFields(cloner, original);
        this.plane = (Plane)cloner.clone((Object)this.plane);
        this.createShape();
    }

    @Override
    public PlaneCollisionShape jmeClone() {
        try {
            PlaneCollisionShape clone = (PlaneCollisionShape)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public float maxRadius() {
        return Float.POSITIVE_INFINITY;
    }

    @Override
    public void read(JmeImporter importer) throws IOException {
        super.read(importer);
        InputCapsule capsule = importer.getCapsule((Savable)this);
        this.plane = (Plane)capsule.readSavable(tagCollisionPlane, (Savable)new Plane());
        this.createShape();
    }

    @Override
    public void write(JmeExporter exporter) throws IOException {
        super.write(exporter);
        OutputCapsule capsule = exporter.getCapsule((Savable)this);
        capsule.write((Savable)this.plane, tagCollisionPlane, (Savable)new Plane());
    }

    private void createShape() {
        long shapeId = PlaneCollisionShape.createShape(this.plane.getNormal(), this.plane.getConstant());
        this.setNativeId(shapeId);
        this.setContactFilterEnabled(this.enableContactFilter);
        this.setScale(this.scale);
        this.setMargin(this.margin);
    }

    private static native long createShape(Vector3f var0, float var1);
}

