/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.collision.shapes;

import com.jme3.bullet.collision.shapes.ConvexShape;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Vector3f;
import com.jme3.util.clone.Cloner;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import jme3utilities.Validate;
import jme3utilities.math.MyBuffer;
import jme3utilities.math.MyVector3f;
import jme3utilities.math.MyVolume;

public class SphereCollisionShape
extends ConvexShape {
    public static final Logger logger2 = Logger.getLogger(SphereCollisionShape.class.getName());
    private static final String tagRadius = "radius";
    private float radius;

    protected SphereCollisionShape() {
    }

    public SphereCollisionShape(FloatBuffer buffer, int startPosition, int endPosition) {
        Validate.nonNull((Object)buffer, (String)"buffer");
        Validate.inRange((int)startPosition, (String)"start position", (int)0, (int)endPosition);
        Validate.inRange((int)endPosition, (String)"end position", (int)startPosition, (int)buffer.capacity());
        this.radius = MyBuffer.maxLength((FloatBuffer)buffer, (int)startPosition, (int)endPosition);
        this.createShape();
    }

    public SphereCollisionShape(float radius) {
        Validate.nonNegative((float)radius, (String)tagRadius);
        this.radius = radius;
        this.createShape();
    }

    @Override
    public float getMargin() {
        return 0.0f;
    }

    public float getRadius() {
        assert (this.radius >= 0.0f) : this.radius;
        return this.radius;
    }

    public float unscaledVolume() {
        float result = MyVolume.sphereVolume((float)this.radius);
        assert (result >= 0.0f) : result;
        return result;
    }

    @Override
    public boolean canScale(Vector3f scale) {
        boolean canScale = super.canScale(scale) && MyVector3f.isScaleUniform((Vector3f)scale);
        return canScale;
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        super.cloneFields(cloner, original);
        this.createShape();
    }

    @Override
    public SphereCollisionShape jmeClone() {
        try {
            SphereCollisionShape clone = (SphereCollisionShape)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public float maxRadius() {
        float result = this.scale.x * this.radius;
        return result;
    }

    @Override
    public void read(JmeImporter importer) throws IOException {
        super.read(importer);
        InputCapsule capsule = importer.getCapsule((Savable)this);
        this.radius = capsule.readFloat(tagRadius, 0.5f);
        this.createShape();
    }

    @Override
    public void setMargin(float margin) {
        logger2.log(Level.WARNING, "Cannot alter the margin of a SphereCollisionShape.");
    }

    @Override
    public void write(JmeExporter exporter) throws IOException {
        super.write(exporter);
        OutputCapsule capsule = exporter.getCapsule((Savable)this);
        capsule.write(this.radius, tagRadius, 0.5f);
    }

    private void createShape() {
        assert (this.radius >= 0.0f) : this.radius;
        long shapeId = SphereCollisionShape.createShape(this.radius);
        this.setNativeId(shapeId);
        this.setContactFilterEnabled(this.enableContactFilter);
        this.setScale(this.scale);
        this.margin = 0.0f;
    }

    private static native long createShape(float var0);
}

