/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.collision.shapes.infos;

import com.jme3.bullet.NativePhysicsObject;
import com.jme3.bullet.collision.shapes.MeshCollisionShape;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.util.clone.Cloner;
import com.jme3.util.clone.JmeCloneable;
import java.io.IOException;
import java.util.logging.Logger;
import jme3utilities.Validate;

public class BoundingValueHierarchy
extends NativePhysicsObject
implements JmeCloneable,
Savable {
    public static final Logger logger = Logger.getLogger(BoundingValueHierarchy.class.getName());
    private static final String tagBytes = "bytes";

    protected BoundingValueHierarchy() {
    }

    public BoundingValueHierarchy(MeshCollisionShape meshShape) {
        Validate.nonNull((Object)meshShape, (String)"mesh shape");
        long shapeId = meshShape.nativeId();
        long bvhId = BoundingValueHierarchy.getOptimizedBvh(shapeId);
        super.setNativeIdNotTracked(bvhId);
    }

    public BoundingValueHierarchy(byte[] bytes) {
        Validate.nonNull((Object)bytes, (String)tagBytes);
        long bvhId = BoundingValueHierarchy.deSerialize(bytes);
        super.setNativeId(bvhId);
    }

    public byte[] serialize() {
        long bvhId = this.nativeId();
        byte[] result = BoundingValueHierarchy.serialize(bvhId);
        assert (result != null);
        return result;
    }

    public void cloneFields(Cloner cloner, Object original) {
        BoundingValueHierarchy originalBvh = (BoundingValueHierarchy)original;
        byte[] bytes = originalBvh.serialize();
        long bvhId = BoundingValueHierarchy.deSerialize(bytes);
        this.reassignNativeId(bvhId);
    }

    public BoundingValueHierarchy jmeClone() {
        try {
            BoundingValueHierarchy clone = (BoundingValueHierarchy)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException exception) {
            throw new RuntimeException(exception);
        }
    }

    public void read(JmeImporter importer) throws IOException {
        InputCapsule capsule = importer.getCapsule((Savable)this);
        byte[] bytes = capsule.readByteArray(tagBytes, null);
        long bvhId = BoundingValueHierarchy.deSerialize(bytes);
        super.setNativeId(bvhId);
    }

    public void write(JmeExporter exporter) throws IOException {
        OutputCapsule capsule = exporter.getCapsule((Savable)this);
        byte[] bytes = this.serialize();
        capsule.write(bytes, tagBytes, null);
    }

    private static void freeNativeObject(long bvhId) {
        assert (bvhId != 0L);
        BoundingValueHierarchy.finalizeNative(bvhId);
    }

    private static native long deSerialize(byte[] var0);

    private static native void finalizeNative(long var0);

    private static native long getOptimizedBvh(long var0);

    private static native byte[] serialize(long var0);
}

