/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.collision.shapes.infos;

import com.jme3.bullet.NativePhysicsObject;
import com.jme3.bullet.collision.shapes.infos.IndexedMesh;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Vector3f;
import com.jme3.scene.Mesh;
import com.jme3.util.clone.Cloner;
import com.jme3.util.clone.JmeCloneable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import jme3utilities.Validate;

public class CompoundMesh
extends NativePhysicsObject
implements JmeCloneable,
Savable {
    public static final Logger logger = Logger.getLogger(CompoundMesh.class.getName());
    private static final String tagScale = "scale";
    private static final String tagSubmeshes = "submeshes";
    private ArrayList<IndexedMesh> submeshes = new ArrayList(4);
    private Vector3f scale = new Vector3f(1.0f, 1.0f, 1.0f);

    public CompoundMesh() {
        this.createEmpty();
    }

    public CompoundMesh(Mesh ... jmeMeshes) {
        this.createEmpty();
        for (Mesh jmeMesh : jmeMeshes) {
            IndexedMesh indexedMesh = new IndexedMesh(jmeMesh);
            this.add(indexedMesh);
        }
    }

    public final void add(IndexedMesh submesh) {
        Validate.nonNull((Object)submesh, (String)"submesh");
        this.submeshes.add(submesh);
        long compoundMeshId = this.nativeId();
        long submeshId = submesh.nativeId();
        CompoundMesh.addIndexedMesh(compoundMeshId, submeshId);
    }

    public int countTriangles() {
        int numTriangles = 0;
        for (IndexedMesh submesh : this.submeshes) {
            numTriangles += submesh.countTriangles();
        }
        assert (numTriangles >= 0) : numTriangles;
        return numTriangles;
    }

    public int countVertices() {
        int numVertices = 0;
        for (IndexedMesh submesh : this.submeshes) {
            numVertices += submesh.countVertices();
        }
        assert (numVertices >= 0) : numVertices;
        return numVertices;
    }

    public Vector3f getScale(Vector3f storeResult) {
        Vector3f result;
        Vector3f vector3f = result = storeResult == null ? new Vector3f() : storeResult;
        assert (this.checkScale(result));
        result.set(this.scale);
        return result;
    }

    public void setScale(Vector3f scale) {
        long compoundMeshId = this.nativeId();
        CompoundMesh.setScaling(compoundMeshId, scale.x, scale.y, scale.z);
        logger.log(Level.FINE, "Scaled {0}", this);
        this.scale.set(scale);
    }

    public void cloneFields(Cloner cloner, Object original) {
        this.submeshes = (ArrayList)cloner.clone(this.submeshes);
        this.scale = (Vector3f)cloner.clone((Object)this.scale);
        this.unassignNativeObject();
        this.createEmpty();
        this.setScale(this.scale);
        long compoundMeshId = this.nativeId();
        for (IndexedMesh submesh : this.submeshes) {
            long submeshId = submesh.nativeId();
            CompoundMesh.addIndexedMesh(compoundMeshId, submeshId);
        }
    }

    public CompoundMesh jmeClone() {
        try {
            CompoundMesh clone = (CompoundMesh)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException exception) {
            throw new RuntimeException(exception);
        }
    }

    public void read(JmeImporter importer) throws IOException {
        InputCapsule capsule = importer.getCapsule((Savable)this);
        this.scale = (Vector3f)capsule.readSavable(tagScale, (Savable)new Vector3f(1.0f, 1.0f, 1.0f));
        this.submeshes = capsule.readSavableArrayList(tagSubmeshes, this.submeshes);
        this.setScale(this.scale);
        long compoundMeshId = this.nativeId();
        for (IndexedMesh submesh : this.submeshes) {
            long submeshId = submesh.nativeId();
            CompoundMesh.addIndexedMesh(compoundMeshId, submeshId);
        }
    }

    public void write(JmeExporter exporter) throws IOException {
        OutputCapsule capsule = exporter.getCapsule((Savable)this);
        capsule.write((Savable)this.scale, tagScale, null);
        capsule.writeSavableArrayList(this.submeshes, tagSubmeshes, null);
    }

    private boolean checkScale(Vector3f tempVector) {
        assert (tempVector != null);
        long compoundMeshId = this.nativeId();
        CompoundMesh.getScaling(compoundMeshId, tempVector);
        boolean result = this.scale.equals((Object)tempVector);
        return result;
    }

    private void createEmpty() {
        long compoundMeshId = CompoundMesh.createEmptyTiva();
        this.setNativeId(compoundMeshId);
        logger.log(Level.FINE, "Created {0}", this);
    }

    private static void freeNativeObject(long compoundMeshId) {
        assert (compoundMeshId != 0L);
        CompoundMesh.finalizeNative(compoundMeshId);
    }

    private static native void addIndexedMesh(long var0, long var2);

    private static native long createEmptyTiva();

    private static native void finalizeNative(long var0);

    private static native void getScaling(long var0, Vector3f var2);

    private static native void setScaling(long var0, float var2, float var3, float var4);
}

