/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.collision.shapes.infos;

import com.jme3.bullet.NativePhysicsObject;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.util.DebugShapeFactory;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.mesh.IndexBuffer;
import com.jme3.util.BufferUtils;
import com.jme3.util.clone.Cloner;
import com.jme3.util.clone.JmeCloneable;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import jme3utilities.MyMesh;
import jme3utilities.Validate;
import jme3utilities.math.MyBuffer;
import jme3utilities.math.MyMath;

public class IndexedMesh
extends NativePhysicsObject
implements JmeCloneable,
Savable {
    private static final int floatBytes = 4;
    private static final int numAxes = 3;
    private static final int vpt = 3;
    public static final Logger logger = Logger.getLogger(IndexedMesh.class.getName());
    private static final String tagIndexInts = "indexInts";
    private static final String tagIndexStride = "indexStride";
    private static final String tagNumTriangles = "numTriangles";
    private static final String tagNumVertices = "numVertices";
    private static final String tagVertexStride = "vertexStride";
    private static final String tagVertices = "vertices";
    private FloatBuffer vertexPositions;
    private IndexBuffer indices;
    private int indexStride;
    private int numTriangles;
    private int numVertices;
    private int vertexStride;

    protected IndexedMesh() {
    }

    public IndexedMesh(CollisionShape shape, int resolution, boolean dedup) {
        Validate.nonNull((Object)shape, (String)"shape");
        Validate.inRange((int)resolution, (String)"resolution", (int)0, (int)1);
        FloatBuffer positionBuffer = DebugShapeFactory.getDebugTriangles(shape, resolution);
        Mesh jmeMesh = new Mesh();
        jmeMesh.setBuffer(VertexBuffer.Type.Position, 3, positionBuffer);
        if (dedup) {
            jmeMesh = MyMesh.addIndices((Mesh)jmeMesh);
        }
        this.create(jmeMesh, null);
    }

    public IndexedMesh(Mesh jmeMesh) {
        Validate.nonNull((Object)jmeMesh, (String)"JME mesh");
        Validate.require((boolean)MyMesh.hasTriangles((Mesh)jmeMesh), (String)"mode=Triangles/TriangleFan/TriangleStrip");
        this.create(jmeMesh, null);
    }

    public IndexedMesh(Mesh jmeMesh, Transform transform) {
        Validate.nonNull((Object)jmeMesh, (String)"JME mesh");
        Validate.require((boolean)MyMesh.hasTriangles((Mesh)jmeMesh), (String)"mode=Triangles/TriangleFan/TriangleStrip");
        Validate.nonNull((Object)transform, (String)"transform");
        this.create(jmeMesh, transform);
    }

    public IndexedMesh(Vector3f[] positionArray, int[] indexArray) {
        Validate.nonNull((Object)positionArray, (String)"position array");
        Validate.nonNull((Object)indexArray, (String)"index array");
        int numIndices = indexArray.length;
        Validate.require((numIndices % 3 == 0 ? 1 : 0) != 0, (String)"length a multiple of 3");
        this.numVertices = positionArray.length;
        this.vertexPositions = BufferUtils.createFloatBuffer((Vector3f[])positionArray);
        this.vertexStride = 12;
        this.numTriangles = numIndices / 3;
        IntBuffer buffer = BufferUtils.createIntBuffer((int[])indexArray);
        this.indices = IndexBuffer.wrapIndexBuffer((Buffer)buffer);
        int indexBytes = this.indices.getFormat().getComponentSize();
        this.indexStride = 3 * indexBytes;
        this.createMesh();
    }

    public IntBuffer copyIndices() {
        int numInts = this.indices.size();
        IntBuffer result = BufferUtils.createIntBuffer((int)numInts);
        for (int bufPos = 0; bufPos < numInts; ++bufPos) {
            int tmpIndex = this.indices.get(bufPos);
            result.put(tmpIndex);
        }
        return result;
    }

    public FloatBuffer copyVertexPositions() {
        int numFloats = this.vertexPositions.capacity();
        FloatBuffer result = BufferUtils.createFloatBuffer((int)numFloats);
        for (int bufPos = 0; bufPos < numFloats; ++bufPos) {
            float tmpFloat = this.vertexPositions.get(bufPos);
            result.put(tmpFloat);
        }
        return result;
    }

    public int countTriangles() {
        assert (this.numTriangles >= 0) : this.numTriangles;
        return this.numTriangles;
    }

    public int countVertices() {
        assert (this.numVertices >= 0) : this.numVertices;
        return this.numVertices;
    }

    public void cloneFields(Cloner cloner, Object original) {
        IndexedMesh originalMesh = (IndexedMesh)original;
        int numFloats = this.vertexPositions.capacity();
        this.vertexPositions = BufferUtils.createFloatBuffer((int)numFloats);
        for (int offset = 0; offset < numFloats; ++offset) {
            float tmpFloat = originalMesh.vertexPositions.get(offset);
            this.vertexPositions.put(offset, tmpFloat);
        }
        int numIndices = this.indices.getBuffer().capacity();
        this.indices = IndexBuffer.createIndexBuffer((int)this.numVertices, (int)numIndices);
        for (int offset = 0; offset < numIndices; ++offset) {
            int tmpIndex = originalMesh.indices.get(offset);
            this.indices.put(offset, tmpIndex);
        }
        this.unassignNativeObject();
        this.createMesh();
    }

    public IndexedMesh jmeClone() {
        try {
            IndexedMesh clone = (IndexedMesh)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException exception) {
            throw new RuntimeException(exception);
        }
    }

    public void read(JmeImporter importer) throws IOException {
        InputCapsule capsule = importer.getCapsule((Savable)this);
        this.indexStride = capsule.readInt(tagIndexStride, 12);
        this.numTriangles = capsule.readInt(tagNumTriangles, 0);
        this.numVertices = capsule.readInt(tagNumVertices, 0);
        this.vertexStride = capsule.readInt(tagVertexStride, 12);
        assert (this.vertexStride == 12) : this.vertexStride;
        int[] intArray = capsule.readIntArray(tagIndexInts, new int[0]);
        int numIndices = intArray.length;
        assert (numIndices == this.numTriangles * 3);
        switch (this.indexStride) {
            case 3: {
                ByteBuffer byteBuf = BufferUtils.createByteBuffer((int)numIndices);
                this.indices = IndexBuffer.wrapIndexBuffer((Buffer)byteBuf);
                break;
            }
            case 6: {
                ShortBuffer sBuf = BufferUtils.createShortBuffer((int)numIndices);
                this.indices = IndexBuffer.wrapIndexBuffer((Buffer)sBuf);
                break;
            }
            case 12: {
                IntBuffer intBuffer = BufferUtils.createIntBuffer((int)numIndices);
                this.indices = IndexBuffer.wrapIndexBuffer((Buffer)intBuffer);
                break;
            }
            default: {
                throw new RuntimeException("indexStride = " + this.indexStride);
            }
        }
        for (int offset = 0; offset < numIndices; ++offset) {
            int tmpIndex = intArray[offset];
            this.indices.put(offset, tmpIndex);
        }
        float[] floatArray = capsule.readFloatArray(tagVertices, new float[0]);
        assert (floatArray.length == this.numVertices * 3);
        this.vertexPositions = BufferUtils.createFloatBuffer((float[])floatArray);
        this.createMesh();
    }

    public void write(JmeExporter exporter) throws IOException {
        OutputCapsule capsule = exporter.getCapsule((Savable)this);
        int numIndices = this.numTriangles * 3;
        int[] intArray = new int[numIndices];
        for (int offset = 0; offset < numIndices; ++offset) {
            intArray[offset] = this.indices.get(offset);
        }
        capsule.write(intArray, tagIndexInts, null);
        capsule.write(this.indexStride, tagIndexStride, 12);
        capsule.write(this.numTriangles, tagNumTriangles, 0);
        capsule.write(this.numVertices, tagNumVertices, 0);
        capsule.write(this.vertexStride, tagVertexStride, 12);
        int numFloats = this.vertexPositions.capacity();
        float[] floatArray = new float[numFloats];
        for (int offset = 0; offset < numFloats; ++offset) {
            floatArray[offset] = this.vertexPositions.get(offset);
        }
        capsule.write(floatArray, tagVertices, null);
    }

    private void create(Mesh jmeMesh, Transform transform) {
        assert (MyMesh.hasTriangles((Mesh)jmeMesh));
        this.numVertices = jmeMesh.getVertexCount();
        if (this.numVertices <= 0) {
            this.numVertices = 0;
        }
        FloatBuffer meshVs = jmeMesh.getFloatBuffer(VertexBuffer.Type.Position);
        int numFloats = 3 * this.numVertices;
        this.vertexPositions = BufferUtils.createFloatBuffer((int)numFloats);
        for (int offset = 0; offset < numFloats; ++offset) {
            float temp = meshVs.get(offset);
            this.vertexPositions.put(offset, temp);
        }
        this.vertexStride = 12;
        if (transform != null && !MyMath.isIdentity((Transform)transform)) {
            MyBuffer.transform((FloatBuffer)this.vertexPositions, (int)0, (int)numFloats, (Transform)transform);
        }
        this.numTriangles = jmeMesh.getTriangleCount();
        if (this.numTriangles <= 0) {
            this.numTriangles = 0;
        }
        int numIndices = 3 * this.numTriangles;
        this.indices = IndexBuffer.createIndexBuffer((int)this.numVertices, (int)numIndices);
        IndexBuffer triangleIndices = jmeMesh.getIndicesAsList();
        for (int offset = 0; offset < numIndices; ++offset) {
            int index = triangleIndices.get(offset);
            assert (index >= 0) : index;
            assert (index < this.numVertices) : index;
            this.indices.put(offset, index);
        }
        int indexBytes = this.indices.getFormat().getComponentSize();
        this.indexStride = 3 * indexBytes;
        this.createMesh();
    }

    private void createMesh() {
        long meshId;
        assert (this.vertexStride == 12) : this.vertexStride;
        switch (this.indexStride) {
            case 3: {
                ByteBuffer byteBuffer = (ByteBuffer)this.indices.getBuffer();
                meshId = IndexedMesh.createByte(byteBuffer, this.vertexPositions, this.numTriangles, this.numVertices, this.vertexStride, this.indexStride);
                break;
            }
            case 6: {
                ShortBuffer shortBuffer = (ShortBuffer)this.indices.getBuffer();
                meshId = IndexedMesh.createShort(shortBuffer, this.vertexPositions, this.numTriangles, this.numVertices, this.vertexStride, this.indexStride);
                break;
            }
            case 12: {
                IntBuffer intBuffer = (IntBuffer)this.indices.getBuffer();
                meshId = IndexedMesh.createInt(intBuffer, this.vertexPositions, this.numTriangles, this.numVertices, this.vertexStride, this.indexStride);
                break;
            }
            default: {
                throw new RuntimeException("indexStride = " + this.indexStride);
            }
        }
        this.setNativeId(meshId);
        logger.log(Level.FINE, "Created {0}", this);
    }

    private static void freeNativeObject(long meshId) {
        assert (meshId != 0L);
        IndexedMesh.finalizeNative(meshId);
    }

    private static native long createByte(ByteBuffer var0, FloatBuffer var1, int var2, int var3, int var4, int var5);

    private static native long createInt(IntBuffer var0, FloatBuffer var1, int var2, int var3, int var4, int var5);

    private static native long createShort(ShortBuffer var0, FloatBuffer var1, int var2, int var3, int var4, int var5);

    private static native void finalizeNative(long var0);
}

