/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.control;

import com.jme3.bullet.PhysicsSpace;
import com.jme3.bullet.control.PhysicsControl;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import com.jme3.util.clone.Cloner;
import com.jme3.util.clone.JmeCloneable;
import java.io.IOException;
import java.util.logging.Logger;
import jme3utilities.MySpatial;

public abstract class AbstractPhysicsControl
implements JmeCloneable,
PhysicsControl {
    public static final Logger logger = Logger.getLogger(AbstractPhysicsControl.class.getName());
    private static final Quaternion rotateIdentity = new Quaternion();
    private static final String tagApplyLocalPhysics = "applyLocalPhysics";
    private static final String tagEnabled = "enabled";
    private static final String tagSpatial = "spatial";
    private static final Vector3f translateIdentity = new Vector3f(0.0f, 0.0f, 0.0f);
    protected boolean added = false;
    private boolean enabled = true;
    private boolean localPhysics = false;
    private PhysicsSpace space = null;
    private Quaternion tmpInverseWorldRotation = new Quaternion();
    private Spatial controlledSpatial;

    public Spatial getSpatial() {
        return this.controlledSpatial;
    }

    public boolean isApplyPhysicsLocal() {
        return this.localPhysics;
    }

    public void setApplyPhysicsLocal(boolean applyPhysicsLocal) {
        this.localPhysics = applyPhysicsLocal;
    }

    protected abstract void addPhysics();

    protected void applyPhysicsTransform(Vector3f physicsLocation, Quaternion physicsOrientation) {
        if (this.enabled && this.controlledSpatial != null) {
            Vector3f localLocation = this.controlledSpatial.getLocalTranslation();
            Quaternion localRotationQuat = this.controlledSpatial.getLocalRotation();
            if (!this.localPhysics && this.controlledSpatial.getParent() != null) {
                localLocation.set(physicsLocation).subtractLocal(this.controlledSpatial.getParent().getWorldTranslation());
                localLocation.divideLocal(this.controlledSpatial.getParent().getWorldScale());
                this.tmpInverseWorldRotation.set(this.controlledSpatial.getParent().getWorldRotation()).inverseLocal().multLocal(localLocation);
                localRotationQuat.set(physicsOrientation);
                this.tmpInverseWorldRotation.set(this.controlledSpatial.getParent().getWorldRotation()).inverseLocal().mult(localRotationQuat, localRotationQuat);
                this.controlledSpatial.setLocalTranslation(localLocation);
                this.controlledSpatial.setLocalRotation(localRotationQuat);
            } else {
                this.controlledSpatial.setLocalTranslation(physicsLocation);
                this.controlledSpatial.setLocalRotation(physicsOrientation);
            }
        }
    }

    protected abstract void createSpatialData(Spatial var1);

    protected Quaternion getSpatialRotation() {
        if (MySpatial.isIgnoringTransforms((Spatial)this.controlledSpatial)) {
            return rotateIdentity;
        }
        if (this.localPhysics) {
            return this.controlledSpatial.getLocalRotation();
        }
        return this.controlledSpatial.getWorldRotation();
    }

    protected Vector3f getSpatialTranslation() {
        if (MySpatial.isIgnoringTransforms((Spatial)this.controlledSpatial)) {
            return translateIdentity;
        }
        if (this.localPhysics) {
            return this.controlledSpatial.getLocalTranslation();
        }
        return this.controlledSpatial.getWorldTranslation();
    }

    protected abstract void removePhysics();

    protected abstract void removeSpatialData(Spatial var1);

    protected abstract void setPhysicsLocation(Vector3f var1);

    protected abstract void setPhysicsRotation(Quaternion var1);

    public void cloneFields(Cloner cloner, Object original) {
        this.tmpInverseWorldRotation = (Quaternion)cloner.clone((Object)this.tmpInverseWorldRotation);
        this.controlledSpatial = (Spatial)cloner.clone((Object)this.controlledSpatial);
    }

    public AbstractPhysicsControl jmeClone() {
        if (this.added) {
            String message = "Can't clone a " + this.getClass().getSimpleName() + " while it's added to a physics space.";
            throw new IllegalStateException(message);
        }
        try {
            AbstractPhysicsControl clone = (AbstractPhysicsControl)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException exception) {
            throw new RuntimeException(exception);
        }
    }

    public Control cloneForSpatial(Spatial spatial) {
        throw new UnsupportedOperationException("cloneForSpatial() isn't implemented.");
    }

    @Override
    public PhysicsSpace getPhysicsSpace() {
        return this.space;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public void read(JmeImporter importer) throws IOException {
        InputCapsule capsule = importer.getCapsule((Savable)this);
        this.enabled = capsule.readBoolean(tagEnabled, true);
        this.controlledSpatial = (Spatial)capsule.readSavable(tagSpatial, null);
        this.localPhysics = capsule.readBoolean(tagApplyLocalPhysics, false);
    }

    public void render(RenderManager rm, ViewPort vp) {
    }

    @Override
    public void setEnabled(boolean enable) {
        this.enabled = enable;
        if (this.space != null) {
            if (enable && !this.added) {
                if (this.controlledSpatial != null) {
                    this.setPhysicsLocation(this.getSpatialTranslation());
                    this.setPhysicsRotation(this.getSpatialRotation());
                }
                this.addPhysics();
                this.added = true;
            } else if (!enable && this.added) {
                this.removePhysics();
                this.added = false;
            }
        }
    }

    @Override
    public void setPhysicsSpace(PhysicsSpace newSpace) {
        if (this.space == newSpace) {
            return;
        }
        if (this.added) {
            this.removePhysics();
            this.added = false;
        }
        this.space = newSpace;
        if (newSpace != null && this.isEnabled()) {
            this.addPhysics();
            this.added = true;
        }
    }

    public void setSpatial(Spatial newSpatial) {
        if (this.controlledSpatial == newSpatial) {
            return;
        }
        if (this.controlledSpatial != null) {
            this.removeSpatialData(this.controlledSpatial);
        }
        this.controlledSpatial = newSpatial;
        if (newSpatial != null) {
            this.createSpatialData(this.controlledSpatial);
            this.setPhysicsLocation(this.getSpatialTranslation());
            this.setPhysicsRotation(this.getSpatialRotation());
        }
    }

    public void write(JmeExporter exporter) throws IOException {
        OutputCapsule capsule = exporter.getCapsule((Savable)this);
        capsule.write(this.enabled, tagEnabled, true);
        capsule.write(this.localPhysics, tagApplyLocalPhysics, false);
        capsule.write((Savable)this.controlledSpatial, tagSpatial, null);
    }
}

