/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.control;

import com.jme3.bullet.PhysicsSpace;
import com.jme3.bullet.PhysicsTickListener;
import com.jme3.bullet.collision.PhysicsRayTestResult;
import com.jme3.bullet.collision.shapes.CapsuleCollisionShape;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.collision.shapes.CompoundCollisionShape;
import com.jme3.bullet.control.AbstractPhysicsControl;
import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.Spatial;
import com.jme3.util.TempVars;
import com.jme3.util.clone.Cloner;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jme3utilities.Validate;
import jme3utilities.math.MyVector3f;

public class BetterCharacterControl
extends AbstractPhysicsControl
implements PhysicsTickListener {
    public static final Logger logger2 = Logger.getLogger(BetterCharacterControl.class.getName());
    private static final String tagBody = "body";
    private static final String tagDuckedFactor = "duckedFactor";
    private static final String tagHeight = "height";
    private static final String tagJumpForce = "jumpForce";
    private static final String tagMass = "mass";
    private static final String tagPhysicsDamping = "physicsDamping";
    private static final String tagRadius = "radius";
    private static final String tagViewDirection = "viewDirection";
    private static final String tagWalkDirection = "walkDirection";
    private boolean ducked = false;
    private boolean jump = false;
    private boolean onGround = false;
    private boolean wantToUnDuck = false;
    private float duckedFactor = 0.6f;
    private float height;
    private float mass;
    private float physicsDamping = 0.9f;
    private float radius;
    private PhysicsRigidBody rigidBody;
    private Quaternion localForwardRotation = new Quaternion(Quaternion.DIRECTION_Z);
    private Quaternion rotation = new Quaternion(Quaternion.DIRECTION_Z);
    private Vector3f jumpForce = new Vector3f();
    private Vector3f localForward = new Vector3f(0.0f, 0.0f, 1.0f);
    private Vector3f localLeft = new Vector3f(1.0f, 0.0f, 0.0f);
    private Vector3f localUp = new Vector3f(0.0f, 1.0f, 0.0f);
    private Vector3f location = new Vector3f();
    private Vector3f rotatedViewDirection = new Vector3f(0.0f, 0.0f, 1.0f);
    private Vector3f scale = new Vector3f(1.0f, 1.0f, 1.0f);
    private Vector3f velocity = new Vector3f();
    private Vector3f viewDirection = new Vector3f(0.0f, 0.0f, 1.0f);
    private Vector3f walkDirection = new Vector3f();

    protected BetterCharacterControl() {
    }

    public BetterCharacterControl(float radius, float height, float mass) {
        Validate.positive((float)radius, (String)tagRadius);
        assert (height > 2.0f * radius) : height;
        Validate.positive((float)mass, (String)tagMass);
        this.radius = radius;
        this.height = height;
        this.mass = mass;
        this.rigidBody = new PhysicsRigidBody(this.getShape(), mass);
        this.jumpForce = new Vector3f(0.0f, mass * 5.0f, 0.0f);
        this.rigidBody.setAngularFactor(0.0f);
    }

    public float getDuckedFactor() {
        return this.duckedFactor;
    }

    public Vector3f getGravity(Vector3f storeResult) {
        return this.rigidBody.getGravity(storeResult);
    }

    public Vector3f getJumpForce(Vector3f storeResult) {
        if (storeResult == null) {
            return this.jumpForce.clone();
        }
        return storeResult.set(this.jumpForce);
    }

    public float getPhysicsDamping() {
        return this.physicsDamping;
    }

    public PhysicsRigidBody getRigidBody() {
        assert (this.rigidBody != null);
        return this.rigidBody;
    }

    public Vector3f getVelocity() {
        return this.getVelocity(null);
    }

    public Vector3f getVelocity(Vector3f storeResult) {
        if (storeResult == null) {
            return this.velocity.clone();
        }
        return storeResult.set(this.velocity);
    }

    public Vector3f getViewDirection() {
        return this.getViewDirection(null);
    }

    public Vector3f getViewDirection(Vector3f storeResult) {
        if (storeResult == null) {
            return this.viewDirection.clone();
        }
        return storeResult.set(this.viewDirection);
    }

    public Vector3f getWalkDirection(Vector3f storeResult) {
        if (storeResult == null) {
            return this.walkDirection.clone();
        }
        return storeResult.set(this.walkDirection);
    }

    public boolean isDucked() {
        return this.ducked;
    }

    public boolean isOnGround() {
        return this.onGround;
    }

    public void jump() {
        if (!this.onGround) {
            return;
        }
        this.jump = true;
    }

    public void resetForward(Vector3f vec) {
        if (vec == null) {
            this.localForward.set(0.0f, 0.0f, 1.0f);
        } else {
            this.localForward.set(vec);
        }
        this.updateLocalCoordinateSystem();
    }

    public void setDucked(boolean enabled) {
        if (enabled) {
            this.setHeightPercent(this.duckedFactor);
            this.ducked = true;
            this.wantToUnDuck = false;
        } else if (this.checkCanUnDuck()) {
            this.setHeightPercent(1.0f);
            this.ducked = false;
        } else {
            this.wantToUnDuck = true;
        }
    }

    public void setDuckedFactor(float factor) {
        this.duckedFactor = factor;
    }

    public void setGravity(Vector3f gravity) {
        this.rigidBody.setGravity(gravity);
        this.localUp.set(gravity).normalizeLocal().negateLocal();
        this.updateLocalCoordinateSystem();
    }

    public void setJumpForce(Vector3f jumpForce) {
        this.jumpForce.set(jumpForce);
    }

    public void setPhysicsDamping(float physicsDamping) {
        this.physicsDamping = physicsDamping;
    }

    public void setViewDirection(Vector3f vec) {
        this.viewDirection.set(vec);
        this.updateLocalViewDirection();
    }

    public void setWalkDirection(Vector3f vec) {
        this.walkDirection.set(vec);
    }

    public void warp(Vector3f vec) {
        this.setPhysicsLocation(vec);
    }

    @Override
    protected void addPhysics() {
        PhysicsSpace space = this.getPhysicsSpace();
        space.getGravity(this.localUp).normalizeLocal().negateLocal();
        this.updateLocalCoordinateSystem();
        space.addCollisionObject(this.rigidBody);
        space.addTickListener(this);
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        super.cloneFields(cloner, original);
        this.jumpForce = (Vector3f)cloner.clone((Object)this.jumpForce);
        this.localForward = (Vector3f)cloner.clone((Object)this.localForward);
        this.localForwardRotation = (Quaternion)cloner.clone((Object)this.localForwardRotation);
        this.localLeft = (Vector3f)cloner.clone((Object)this.localLeft);
        this.localUp = (Vector3f)cloner.clone((Object)this.localUp);
        this.location = (Vector3f)cloner.clone((Object)this.location);
        this.rigidBody = (PhysicsRigidBody)cloner.clone((Object)this.rigidBody);
        this.rotatedViewDirection = (Vector3f)cloner.clone((Object)this.rotatedViewDirection);
        this.rotation = (Quaternion)cloner.clone((Object)this.rotation);
        this.scale = (Vector3f)cloner.clone((Object)this.scale);
        this.velocity = (Vector3f)cloner.clone((Object)this.velocity);
        this.viewDirection = (Vector3f)cloner.clone((Object)this.viewDirection);
        this.walkDirection = (Vector3f)cloner.clone((Object)this.walkDirection);
    }

    @Override
    protected void createSpatialData(Spatial spatial) {
        this.rigidBody.setUserObject(spatial);
    }

    @Override
    public void read(JmeImporter importer) throws IOException {
        super.read(importer);
        InputCapsule capsule = importer.getCapsule((Savable)this);
        this.radius = capsule.readFloat(tagRadius, 1.0f);
        this.height = capsule.readFloat(tagHeight, 2.0f);
        this.mass = capsule.readFloat(tagMass, 80.0f);
        this.jumpForce = (Vector3f)capsule.readSavable(tagJumpForce, (Savable)new Vector3f(0.0f, this.mass * 5.0f, 0.0f));
        this.physicsDamping = capsule.readFloat(tagPhysicsDamping, 0.9f);
        this.duckedFactor = capsule.readFloat(tagDuckedFactor, 0.6f);
        this.viewDirection = (Vector3f)capsule.readSavable(tagViewDirection, (Savable)new Vector3f(0.0f, 0.0f, 1.0f));
        this.walkDirection = (Vector3f)capsule.readSavable(tagWalkDirection, (Savable)new Vector3f(0.0f, 0.0f, 1.0f));
        this.rigidBody = (PhysicsRigidBody)capsule.readSavable(tagBody, null);
        Spatial controlled = this.getSpatial();
        this.rigidBody.setUserObject(controlled);
    }

    @Override
    protected void removePhysics() {
        PhysicsSpace space = this.getPhysicsSpace();
        space.removeCollisionObject(this.rigidBody);
        space.removeTickListener(this);
    }

    @Override
    protected void removeSpatialData(Spatial spatial) {
        this.rigidBody.setUserObject(null);
    }

    @Override
    protected void setPhysicsLocation(Vector3f location) {
        this.rigidBody.setPhysicsLocation(location);
        location.set(location);
    }

    @Override
    protected void setPhysicsRotation(Quaternion orientation) {
        this.rotation.set(orientation);
        this.rotation.multLocal(this.rotatedViewDirection.set(this.viewDirection));
        this.updateLocalViewDirection();
    }

    public void update(float tpf) {
        if (!this.isEnabled()) {
            return;
        }
        this.rigidBody.getPhysicsLocation(this.location);
        this.applyPhysicsTransform(this.location, this.rotation);
    }

    @Override
    public void write(JmeExporter exporter) throws IOException {
        super.write(exporter);
        OutputCapsule capsule = exporter.getCapsule((Savable)this);
        capsule.write(this.radius, tagRadius, 1.0f);
        capsule.write(this.height, tagHeight, 2.0f);
        capsule.write(this.mass, tagMass, 80.0f);
        capsule.write((Savable)this.jumpForce, tagJumpForce, null);
        capsule.write(this.physicsDamping, tagPhysicsDamping, 0.9f);
        capsule.write(this.duckedFactor, tagDuckedFactor, 0.6f);
        capsule.write((Savable)this.viewDirection, tagViewDirection, null);
        capsule.write((Savable)this.walkDirection, tagWalkDirection, null);
        capsule.write((Savable)this.rigidBody, tagBody, null);
    }

    @Override
    public void physicsTick(PhysicsSpace space, float timeStep) {
        this.rigidBody.getLinearVelocity(this.velocity);
    }

    @Override
    public void prePhysicsTick(PhysicsSpace space, float timeStep) {
        this.checkOnGround();
        if (this.wantToUnDuck && this.checkCanUnDuck()) {
            this.setHeightPercent(1.0f);
            this.wantToUnDuck = false;
            this.ducked = false;
        }
        TempVars vars = TempVars.get();
        Vector3f currentVelocity = vars.vect2.set(this.velocity);
        float existingLeftVelocity = this.velocity.dot(this.localLeft);
        float existingForwardVelocity = this.velocity.dot(this.localForward);
        Vector3f counter = vars.vect1;
        counter.set(-(existingLeftVelocity *= this.physicsDamping), 0.0f, -(existingForwardVelocity *= this.physicsDamping));
        this.localForwardRotation.multLocal(counter);
        this.velocity.addLocal(counter);
        float designatedVelocity = this.walkDirection.length();
        if (designatedVelocity > 0.0f) {
            Vector3f localWalkDirection = vars.vect1;
            localWalkDirection.set(this.walkDirection).normalizeLocal();
            float existingVelocity = this.velocity.dot(localWalkDirection);
            float finalVelocity = designatedVelocity - existingVelocity;
            localWalkDirection.multLocal(finalVelocity);
            this.velocity.addLocal(localWalkDirection);
        }
        if (currentVelocity.distance(this.velocity) > 1.0E-4f) {
            this.rigidBody.setLinearVelocity(this.velocity);
        }
        if (this.jump) {
            Vector3f rotatedJumpForce = vars.vect1;
            rotatedJumpForce.set(this.jumpForce);
            this.rigidBody.applyCentralImpulse(this.localForwardRotation.multLocal(rotatedJumpForce));
            this.jump = false;
        }
        vars.release();
    }

    protected void calculateNewForward(Quaternion rotation, Vector3f direction, Vector3f worldUpVector) {
        if (direction == null) {
            return;
        }
        TempVars vars = TempVars.get();
        Vector3f newLeft = vars.vect1;
        Vector3f newLeftNegate = vars.vect2;
        newLeft.set(worldUpVector).crossLocal(direction).normalizeLocal();
        if (MyVector3f.isZero((Vector3f)newLeft)) {
            if (direction.x != 0.0f) {
                newLeft.set(direction.y, -direction.x, 0.0f).normalizeLocal();
            } else {
                newLeft.set(0.0f, direction.z, -direction.y).normalizeLocal();
            }
            if (logger2.isLoggable(Level.INFO)) {
                logger2.log(Level.INFO, "Zero left for direction {0}, up {1}", new Object[]{direction, worldUpVector});
            }
        }
        newLeftNegate.set(newLeft).negateLocal();
        direction.set(worldUpVector).crossLocal(newLeftNegate).normalizeLocal();
        if (MyVector3f.isZero((Vector3f)direction)) {
            direction.set(0.0f, 0.0f, 1.0f);
            if (logger2.isLoggable(Level.INFO)) {
                logger2.log(Level.INFO, "Zero left for left {0}, up {1}", new Object[]{newLeft, worldUpVector});
            }
        }
        if (rotation != null) {
            rotation.fromAxes(newLeft, worldUpVector, direction);
        }
        vars.release();
    }

    protected boolean checkCanUnDuck() {
        TempVars vars = TempVars.get();
        Vector3f loc = vars.vect1;
        Vector3f rayVector = vars.vect2;
        loc.set(this.localUp).multLocal(1.0E-4f).addLocal(this.location);
        rayVector.set(this.localUp).multLocal(this.height + 1.0E-4f).addLocal(loc);
        List<PhysicsRayTestResult> results = this.getPhysicsSpace().rayTestRaw(loc, rayVector);
        vars.release();
        for (PhysicsRayTestResult physicsRayTestResult : results) {
            if (physicsRayTestResult.getCollisionObject().equals(this.rigidBody)) continue;
            return false;
        }
        return true;
    }

    protected void checkOnGround() {
        TempVars vars = TempVars.get();
        Vector3f loc = vars.vect1;
        Vector3f rayVector = vars.vect2;
        float scaledHeight = this.getFinalHeight();
        loc.set(this.localUp).multLocal(scaledHeight).addLocal(this.location);
        rayVector.set(this.localUp).multLocal(-scaledHeight - 0.1f).addLocal(loc);
        List<PhysicsRayTestResult> results = this.getPhysicsSpace().rayTestRaw(loc, rayVector);
        vars.release();
        for (PhysicsRayTestResult physicsRayTestResult : results) {
            if (physicsRayTestResult.getCollisionObject().equals(this.rigidBody)) continue;
            this.onGround = true;
            return;
        }
        this.onGround = false;
    }

    protected float getFinalHeight() {
        return this.height * this.scale.getY();
    }

    protected float getFinalRadius() {
        return this.radius * this.scale.getZ();
    }

    protected CollisionShape getShape() {
        CapsuleCollisionShape capsuleCollisionShape = new CapsuleCollisionShape(this.getFinalRadius(), this.getFinalHeight() - 2.0f * this.getFinalRadius());
        CompoundCollisionShape compoundCollisionShape = new CompoundCollisionShape(1);
        compoundCollisionShape.addChildShape(capsuleCollisionShape, 0.0f, this.getFinalHeight() / 2.0f, 0.0f);
        return compoundCollisionShape;
    }

    protected void setHeightPercent(float percent) {
        this.scale.setY(percent);
        this.rigidBody.setCollisionShape(this.getShape());
    }

    protected void updateLocalCoordinateSystem() {
        this.calculateNewForward(this.localForwardRotation, this.localForward, this.localUp);
        this.localLeft.set(this.localUp).crossLocal(this.localForward);
        this.rigidBody.setPhysicsRotation(this.localForwardRotation);
        this.updateLocalViewDirection();
    }

    protected void updateLocalViewDirection() {
        this.localForwardRotation.multLocal(this.rotatedViewDirection.set(this.viewDirection));
        this.calculateNewForward(this.rotation, this.rotatedViewDirection, this.localUp);
    }
}

