/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.control;

import com.jme3.bullet.PhysicsSpace;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.control.PhysicsControl;
import com.jme3.bullet.objects.PhysicsGhostObject;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import com.jme3.util.clone.Cloner;
import java.io.IOException;
import java.util.logging.Logger;
import jme3utilities.MySpatial;
import jme3utilities.math.MyMath;
import jme3utilities.math.MyVector3f;

public class GhostControl
extends PhysicsGhostObject
implements PhysicsControl {
    public static final Logger logger3 = Logger.getLogger(GhostControl.class.getName());
    private static final String tagApplyLocalPhysics = "applyLocalPhysics";
    private static final String tagApplyScale = "applyScale";
    private static final String tagEnabled = "enabled";
    private static final String tagSpatial = "spatial";
    private static final Quaternion rotateIdentity = new Quaternion();
    private static final Vector3f scaleIdentity = new Vector3f(1.0f, 1.0f, 1.0f);
    private static final Vector3f translateIdentity = new Vector3f(0.0f, 0.0f, 0.0f);
    private boolean added = false;
    private boolean applyLocal = false;
    private boolean applyScale = false;
    private boolean enabled = true;
    private PhysicsSpace space = null;
    private Spatial spatial;

    protected GhostControl() {
    }

    public GhostControl(CollisionShape shape) {
        super(shape);
    }

    public Spatial getSpatial() {
        return this.spatial;
    }

    public boolean isApplyPhysicsLocal() {
        return this.applyLocal;
    }

    public boolean isApplyScale() {
        return this.applyScale;
    }

    public void setApplyPhysicsLocal(boolean applyPhysicsLocal) {
        this.applyLocal = applyPhysicsLocal;
    }

    public void setApplyScale(boolean setting) {
        this.applyScale = setting;
    }

    public Control cloneForSpatial(Spatial spatial) {
        throw new UnsupportedOperationException("cloneForSpatial() isn't implemented.");
    }

    @Override
    public PhysicsSpace getPhysicsSpace() {
        return this.space;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public void render(RenderManager rm, ViewPort vp) {
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (this.space != null) {
            if (enabled && !this.added) {
                if (this.spatial != null) {
                    this.setPhysicsLocation(this.getSpatialTranslation());
                    this.setPhysicsRotation(this.getSpatialRotation());
                }
                this.space.addCollisionObject(this);
                this.added = true;
            } else if (!enabled && this.added) {
                this.space.removeCollisionObject(this);
                this.added = false;
            }
        }
    }

    @Override
    public void setPhysicsSpace(PhysicsSpace newSpace) {
        if (this.space == newSpace) {
            return;
        }
        if (this.added) {
            this.space.removeCollisionObject(this);
            this.added = false;
        }
        if (newSpace != null && this.isEnabled()) {
            newSpace.addCollisionObject(this);
            this.added = true;
        }
        this.space = newSpace;
    }

    public void setSpatial(Spatial controlledSpatial) {
        if (this.spatial == controlledSpatial) {
            return;
        }
        this.spatial = controlledSpatial;
        this.setUserObject(controlledSpatial);
        if (controlledSpatial != null) {
            this.setPhysicsLocation(this.getSpatialTranslation());
            this.setPhysicsRotation(this.getSpatialRotation());
        }
    }

    public void update(float tpf) {
        if (!this.enabled) {
            return;
        }
        this.setPhysicsLocation(this.getSpatialTranslation());
        this.setPhysicsRotation(this.getSpatialRotation());
        if (this.applyScale) {
            Vector3f oldScale;
            Vector3f newScale = this.copySpatialScale(null);
            CollisionShape shape = this.getCollisionShape();
            if (!shape.canScale(newScale)) {
                float factor = MyMath.cubeRoot((float)(newScale.x * newScale.y * newScale.z));
                newScale.set(factor, factor, factor);
            }
            if (MyVector3f.ne((Vector3f)(oldScale = shape.getScale(null)), (Vector3f)newScale) && shape.canScale(newScale)) {
                shape.setScale(newScale);
                this.setCollisionShape(shape);
            }
        }
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        super.cloneFields(cloner, original);
        this.spatial = (Spatial)cloner.clone((Object)this.spatial);
    }

    @Override
    public GhostControl jmeClone() {
        try {
            GhostControl clone = (GhostControl)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public void read(JmeImporter importer) throws IOException {
        super.read(importer);
        InputCapsule capsule = importer.getCapsule((Savable)this);
        this.enabled = capsule.readBoolean(tagEnabled, true);
        this.applyLocal = capsule.readBoolean(tagApplyLocalPhysics, false);
        this.applyScale = capsule.readBoolean(tagApplyScale, false);
        this.spatial = (Spatial)capsule.readSavable(tagSpatial, null);
        this.setUserObject(this.spatial);
    }

    @Override
    public void write(JmeExporter exporter) throws IOException {
        super.write(exporter);
        OutputCapsule capsule = exporter.getCapsule((Savable)this);
        capsule.write(this.enabled, tagEnabled, true);
        capsule.write(this.applyLocal, tagApplyLocalPhysics, false);
        capsule.write(this.applyScale, tagApplyScale, false);
        capsule.write((Savable)this.spatial, tagSpatial, null);
    }

    private Vector3f copySpatialScale(Vector3f storeResult) {
        Vector3f result;
        Vector3f vector3f = result = storeResult == null ? new Vector3f() : storeResult;
        if (MySpatial.isIgnoringTransforms((Spatial)this.spatial)) {
            result.set(scaleIdentity);
        } else if (this.isApplyPhysicsLocal()) {
            Vector3f scale = this.spatial.getLocalScale();
            result.set(scale);
        } else {
            Vector3f scale = this.spatial.getWorldScale();
            result.set(scale);
        }
        return result;
    }

    private Quaternion getSpatialRotation() {
        if (MySpatial.isIgnoringTransforms((Spatial)this.spatial)) {
            return rotateIdentity;
        }
        if (this.applyLocal) {
            return this.spatial.getLocalRotation();
        }
        return this.spatial.getWorldRotation();
    }

    private Vector3f getSpatialTranslation() {
        if (MySpatial.isIgnoringTransforms((Spatial)this.spatial)) {
            return translateIdentity;
        }
        if (this.applyLocal) {
            return this.spatial.getLocalTranslation();
        }
        return this.spatial.getWorldTranslation();
    }
}

