/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.control;

import com.jme3.bullet.PhysicsSoftSpace;
import com.jme3.bullet.PhysicsSpace;
import com.jme3.bullet.control.AbstractPhysicsControl;
import com.jme3.bullet.objects.PhysicsSoftBody;
import com.jme3.bullet.util.NativeSoftBodyUtil;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.mesh.IndexBuffer;
import com.jme3.util.BufferUtils;
import com.jme3.util.clone.Cloner;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.List;
import java.util.logging.Logger;
import jme3utilities.MySpatial;

public class SoftBodyControl
extends AbstractPhysicsControl {
    public static final Logger logger2 = Logger.getLogger(SoftBodyControl.class.getName());
    private static final String tagBody = "body";
    private static final String tagGeometry = "geometry";
    private static final String tagMergeVertices = "mergeVertices";
    private static final String tagUpdateNormals = "updateNormals";
    private boolean mergeVertices = true;
    private boolean updateNormals = true;
    private Geometry geometry = null;
    private IntBuffer indexMap = null;
    private PhysicsSoftBody body = null;

    public SoftBodyControl() {
    }

    public SoftBodyControl(boolean localPhysics, boolean updateNormals, boolean mergeVertices) {
        super.setApplyPhysicsLocal(localPhysics);
        this.mergeVertices = mergeVertices;
        this.updateNormals = updateNormals;
    }

    public PhysicsSoftBody getBody() {
        return this.body;
    }

    @Override
    protected void addPhysics() {
        PhysicsSpace space = this.getPhysicsSpace();
        space.addCollisionObject(this.body);
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        super.cloneFields(cloner, original);
        this.geometry = (Geometry)cloner.clone((Object)this.geometry);
        this.body = (PhysicsSoftBody)cloner.clone((Object)this.body);
        if (this.indexMap != null) {
            SoftBodyControl originalControl = (SoftBodyControl)original;
            int numIndices = this.indexMap.limit();
            this.indexMap = BufferUtils.createIntBuffer((int)numIndices);
            for (int offset = 0; offset < numIndices; ++offset) {
                int tmpIndex = originalControl.indexMap.get(offset);
                this.indexMap.put(tmpIndex);
            }
        }
    }

    @Override
    protected void createSpatialData(Spatial spatial) {
        this.body = new PhysicsSoftBody();
        this.body.setUserObject(spatial);
        List geometries = MySpatial.listGeometries((Spatial)spatial);
        this.geometry = (Geometry)geometries.get(0);
        Mesh mesh = this.geometry.getMesh();
        if (mesh.getBuffer(VertexBuffer.Type.Normal) == null) {
            this.updateNormals = false;
        }
        this.appendFromGeometry();
    }

    @Override
    public void read(JmeImporter importer) throws IOException {
        super.read(importer);
        InputCapsule capsule = importer.getCapsule((Savable)this);
        this.body = (PhysicsSoftBody)capsule.readSavable(tagBody, null);
        this.geometry = (Geometry)capsule.readSavable(tagGeometry, null);
        this.mergeVertices = capsule.readBoolean(tagMergeVertices, false);
        this.updateNormals = capsule.readBoolean(tagUpdateNormals, false);
        if (this.body != null) {
            Spatial controlled = this.getSpatial();
            this.body.setUserObject(controlled);
        }
    }

    @Override
    protected void removePhysics() {
        PhysicsSpace space = this.getPhysicsSpace();
        space.removeCollisionObject(this.body);
    }

    @Override
    protected void removeSpatialData(Spatial spatial) {
        this.body.setUserObject(null);
        this.body = null;
    }

    @Override
    public void setPhysicsLocation(Vector3f location) {
        this.body.setPhysicsLocation(location);
    }

    @Override
    protected void setPhysicsRotation(Quaternion orientation) {
    }

    @Override
    public void setPhysicsSpace(PhysicsSpace newSpace) {
        if (newSpace != null && !(newSpace instanceof PhysicsSoftSpace)) {
            throw new IllegalArgumentException("The PhysicsSpace must be a PhysicsSoftSpace or null.");
        }
        super.setPhysicsSpace(newSpace);
    }

    public void update(float tpf) {
        Transform physicsToMesh;
        if (!this.isEnabled()) {
            return;
        }
        Spatial spatial = this.getSpatial();
        Transform meshToWorld = this.geometry.getWorldTransform();
        Transform worldToMesh = meshToWorld.invert();
        if (this.isApplyPhysicsLocal()) {
            Transform localToMesh;
            Transform localToWorld = spatial.getWorldTransform();
            physicsToMesh = localToMesh = localToWorld.clone().combineWithParent(worldToMesh);
        } else {
            physicsToMesh = worldToMesh;
        }
        Mesh mesh = this.geometry.getMesh();
        boolean localFlag = false;
        NativeSoftBodyUtil.updateMesh(this.body, this.indexMap, mesh, localFlag, this.updateNormals, physicsToMesh);
        spatial.updateModelBound();
    }

    @Override
    public void write(JmeExporter exporter) throws IOException {
        super.write(exporter);
        OutputCapsule capsule = exporter.getCapsule((Savable)this);
        capsule.write((Savable)this.body, tagBody, null);
        capsule.write((Savable)this.geometry, tagGeometry, null);
        capsule.write(this.mergeVertices, tagMergeVertices, false);
        capsule.write(this.updateNormals, tagUpdateNormals, false);
    }

    private void appendFromGeometry() {
        Transform meshToPhysics;
        assert (this.body.isEmpty());
        Mesh mesh = this.geometry.getMesh();
        FloatBuffer positions = mesh.getFloatBuffer(VertexBuffer.Type.Position);
        IndexBuffer links = null;
        IndexBuffer faces = null;
        switch (mesh.getMode()) {
            case Lines: 
            case LineLoop: 
            case LineStrip: {
                links = mesh.getIndicesAsList();
                break;
            }
            case Triangles: 
            case TriangleFan: 
            case TriangleStrip: {
                faces = mesh.getIndicesAsList();
                break;
            }
            default: {
                throw new IllegalStateException(mesh.getMode().name());
            }
        }
        if (this.mergeVertices) {
            this.indexMap = NativeSoftBodyUtil.generateIndexMap(positions);
            positions = NativeSoftBodyUtil.mapVertexData(this.indexMap, positions, 3);
            if (links != null) {
                links = NativeSoftBodyUtil.mapIndices(this.indexMap, links, null);
            }
            if (faces != null) {
                faces = NativeSoftBodyUtil.mapIndices(this.indexMap, faces, null);
            }
        } else {
            this.indexMap = null;
        }
        this.body.appendNodes(positions);
        if (links != null) {
            this.body.appendLinks(links);
        }
        if (faces != null) {
            this.body.appendFaces(faces);
        }
        Transform meshToWorld = this.geometry.getWorldTransform();
        if (this.isApplyPhysicsLocal()) {
            Transform meshToLocal;
            Spatial spatial = this.getSpatial();
            Transform localToWorld = spatial.getWorldTransform();
            Transform worldToLocal = localToWorld.invert();
            meshToPhysics = meshToLocal = meshToWorld.clone().combineWithParent(worldToLocal);
        } else {
            meshToPhysics = meshToWorld;
        }
        this.body.applyTransform(meshToPhysics);
    }
}

