/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.debug;

import com.jme3.bullet.debug.BulletDebugAppState;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.AbstractControl;
import com.jme3.util.clone.Cloner;
import java.io.IOException;

public abstract class AbstractPhysicsDebugControl
extends AbstractControl {
    protected final BulletDebugAppState debugAppState;

    protected AbstractPhysicsDebugControl(BulletDebugAppState debugAppState) {
        this.debugAppState = debugAppState;
    }

    protected void applyPhysicsTransform(Vector3f worldLocation, Quaternion worldRotation) {
        this.applyPhysicsTransform(worldLocation, worldRotation, this.spatial);
    }

    public void cloneFields(Cloner cloner, Object original) {
        throw new UnsupportedOperationException("cloneFields() isn't implemented.");
    }

    protected void controlRender(RenderManager rm, ViewPort vp) {
    }

    public Object jmeClone() {
        throw new UnsupportedOperationException("jmeClone() isn't implemented.");
    }

    public void read(JmeImporter importer) throws IOException {
        throw new UnsupportedOperationException("read() isn't implemented.");
    }

    public void write(JmeExporter exporter) throws IOException {
        throw new UnsupportedOperationException("write() isn't implemented.");
    }

    private void applyPhysicsTransform(Vector3f location, Quaternion rotation, Spatial spatial) {
        if (spatial != null) {
            spatial.setLocalTranslation(location);
            spatial.setLocalRotation(rotation);
        }
    }
}

