/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.debug;

import com.jme3.bullet.debug.AbstractPhysicsDebugControl;
import com.jme3.bullet.debug.BulletDebugAppState;
import com.jme3.bullet.debug.SoftDebugAppState;
import com.jme3.bullet.joints.Anchor;
import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.bullet.objects.PhysicsSoftBody;
import com.jme3.material.Material;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.util.BufferUtils;
import java.nio.FloatBuffer;
import java.util.logging.Logger;
import jme3utilities.Validate;

class AnchorDebugControl
extends AbstractPhysicsDebugControl {
    public static final Logger logger = Logger.getLogger(AnchorDebugControl.class.getName());
    private final Anchor anchor;
    private final Geometry anchorGeometry;

    AnchorDebugControl(BulletDebugAppState debugAppState, Anchor anchor) {
        super(debugAppState);
        Validate.nonNull((Object)anchor, (String)"anchor");
        this.anchor = anchor;
        this.anchorGeometry = this.createAnchorGeometry();
    }

    protected void controlUpdate(float tpf) {
        Mesh mesh = this.anchorGeometry.getMesh();
        FloatBuffer positionBuffer = mesh.getFloatBuffer(VertexBuffer.Type.Position);
        PhysicsSoftBody softBodyA = this.anchor.getSoftBody();
        int nodeIndex = this.anchor.nodeIndex();
        Vector3f aLocation = softBodyA.nodeLocation(nodeIndex, null);
        positionBuffer.put(0, aLocation.x);
        positionBuffer.put(1, aLocation.y);
        positionBuffer.put(2, aLocation.z);
        PhysicsRigidBody rigidBodyB = this.anchor.getRigidBody();
        Vector3f pivotInB = this.anchor.copyPivot(null);
        Transform t = rigidBodyB.getTransform(null);
        t.getScale().set(1.0f, 1.0f, 1.0f);
        Vector3f bLocation = t.transformVector(pivotInB, null);
        positionBuffer.put(3, bLocation.x);
        positionBuffer.put(4, bLocation.y);
        positionBuffer.put(5, bLocation.z);
        mesh.getBuffer(VertexBuffer.Type.Position).setUpdateNeeded();
        mesh.updateBound();
    }

    public void setSpatial(Spatial spatial) {
        if (spatial instanceof Node) {
            assert (this.spatial == null);
            Node node = (Node)spatial;
            node.attachChild((Spatial)this.anchorGeometry);
        } else if (spatial == null && this.spatial != null) {
            Node node = (Node)this.spatial;
            node.detachChild((Spatial)this.anchorGeometry);
        }
        super.setSpatial(spatial);
    }

    private Geometry createAnchorGeometry() {
        Mesh mesh = new Mesh();
        int numVertices = 2;
        int numFloats = 3 * numVertices;
        FloatBuffer positions = BufferUtils.createFloatBuffer((int)numFloats);
        mesh.setBuffer(VertexBuffer.Type.Position, 3, positions);
        mesh.setMode(Mesh.Mode.Lines);
        mesh.setStreamed();
        Geometry result = new Geometry(this.anchor.toString(), mesh);
        result.setShadowMode(RenderQueue.ShadowMode.Off);
        SoftDebugAppState sdas = (SoftDebugAppState)this.debugAppState;
        Material material = sdas.getAnchorMaterial();
        result.setMaterial(material);
        return result;
    }
}

