/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.debug;

import com.jme3.bullet.collision.PhysicsCollisionObject;
import com.jme3.bullet.debug.AbstractPhysicsDebugControl;
import com.jme3.bullet.debug.BulletDebugAppState;
import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.material.Material;
import com.jme3.math.Vector3f;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.debug.Arrow;
import java.util.logging.Logger;

class AngularVelocityDebugControl
extends AbstractPhysicsDebugControl {
    static final Logger logger = Logger.getLogger(AngularVelocityDebugControl.class.getName());
    private final Geometry geom;
    private final PhysicsRigidBody rigidBody;
    private final Vector3f tmpCenter = new Vector3f();
    private static final Vector3f tmpExtent = new Vector3f();

    AngularVelocityDebugControl(BulletDebugAppState debugAppState, PhysicsCollisionObject pco) {
        super(debugAppState);
        this.rigidBody = (PhysicsRigidBody)pco;
        this.rigidBody.getAngularVelocity(tmpExtent);
        Arrow mesh = new Arrow(tmpExtent);
        this.geom = new Geometry("angular velocity of " + this.rigidBody, (Mesh)mesh);
        this.rigidBody.getPhysicsLocation(this.tmpCenter);
        this.geom.setLocalTranslation(this.tmpCenter);
        Material material = debugAppState.getAngularVelocityMaterial();
        this.geom.setMaterial(material);
        this.geom.setShadowMode(RenderQueue.ShadowMode.Off);
    }

    protected void controlUpdate(float tpf) {
        this.rigidBody.getPhysicsLocation(this.tmpCenter);
        this.geom.setLocalTranslation(this.tmpCenter);
        Mesh mesh = this.geom.getMesh();
        Arrow arrow = (Arrow)mesh;
        this.rigidBody.getAngularVelocity(tmpExtent);
        arrow.setArrowExtent(tmpExtent);
    }

    public void setSpatial(Spatial spatial) {
        if (spatial instanceof Node) {
            Node node = (Node)spatial;
            node.attachChild((Spatial)this.geom);
        } else if (spatial == null && this.spatial != null) {
            Node node = (Node)this.spatial;
            node.detachChild((Spatial)this.geom);
        }
        super.setSpatial(spatial);
    }
}

