/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.debug;

import com.jme3.bounding.BoundingBox;
import com.jme3.bullet.collision.PhysicsCollisionObject;
import com.jme3.bullet.debug.AbstractPhysicsDebugControl;
import com.jme3.bullet.debug.BulletDebugAppState;
import com.jme3.material.Material;
import com.jme3.math.Vector3f;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.debug.WireBox;
import java.util.logging.Logger;

class BoundingBoxDebugControl
extends AbstractPhysicsDebugControl {
    public static final Logger logger = Logger.getLogger(BoundingBoxDebugControl.class.getName());
    private final BoundingBox bbox;
    private final Geometry geom;
    private final PhysicsCollisionObject pco;
    private final Vector3f center;

    BoundingBoxDebugControl(BulletDebugAppState debugAppState, PhysicsCollisionObject pco) {
        super(debugAppState);
        this.pco = pco;
        this.bbox = pco.boundingBox(null);
        float xExtent = this.bbox.getXExtent();
        float yExtent = this.bbox.getYExtent();
        float zExtent = this.bbox.getZExtent();
        WireBox mesh = new WireBox(xExtent, yExtent, zExtent);
        this.geom = new Geometry("bounding box of " + pco, (Mesh)mesh);
        this.center = this.bbox.getCenter();
        this.geom.setLocalTranslation(this.center);
        Material material = debugAppState.getBoundingBoxMaterial();
        this.geom.setMaterial(material);
        this.geom.setShadowMode(RenderQueue.ShadowMode.Off);
    }

    protected void controlUpdate(float tpf) {
        Mesh mesh = this.geom.getMesh();
        WireBox wireBox = (WireBox)mesh;
        this.pco.boundingBox(this.bbox);
        float xExtent = this.bbox.getXExtent();
        float yExtent = this.bbox.getYExtent();
        float zExtent = this.bbox.getZExtent();
        wireBox.updatePositions(xExtent, yExtent, zExtent);
        this.bbox.getCenter(this.center);
        this.geom.setLocalTranslation(this.center);
    }

    public void setSpatial(Spatial spatial) {
        if (spatial instanceof Node) {
            Node node = (Node)spatial;
            node.attachChild((Spatial)this.geom);
        } else if (spatial == null && this.spatial != null) {
            Node node = (Node)this.spatial;
            node.detachChild((Spatial)this.geom);
        }
        super.setSpatial(spatial);
    }
}

