/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.debug;

import com.jme3.bullet.debug.AbstractPhysicsDebugControl;
import com.jme3.bullet.debug.BulletDebugAppState;
import com.jme3.bullet.objects.PhysicsVehicle;
import com.jme3.bullet.objects.VehicleWheel;
import com.jme3.bullet.objects.infos.RigidBodyMotionState;
import com.jme3.material.Material;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.debug.Arrow;
import java.util.logging.Logger;

public class BulletVehicleDebugControl
extends AbstractPhysicsDebugControl {
    public static final Logger logger = Logger.getLogger(BulletVehicleDebugControl.class.getName());
    private final Node suspensionNode;
    private final PhysicsVehicle vehicle;
    private final Quaternion rotation = new Quaternion();
    private final Vector3f location = new Vector3f();

    public BulletVehicleDebugControl(BulletDebugAppState debugAppState, PhysicsVehicle ve) {
        super(debugAppState);
        this.vehicle = ve;
        this.suspensionNode = new Node("Suspension");
        this.createVehicle();
    }

    protected void controlUpdate(float tpf) {
        for (int i = 0; i < this.vehicle.getNumWheels(); ++i) {
            VehicleWheel physicsVehicleWheel = this.vehicle.getWheel(i);
            Vector3f wLocation = physicsVehicleWheel.getLocation(null);
            Vector3f wDirection = physicsVehicleWheel.getDirection(null);
            Vector3f axle = physicsVehicleWheel.getAxle(null);
            float restLength = physicsVehicleWheel.getRestLength();
            float radius = physicsVehicleWheel.getRadius();
            Geometry locGeom = (Geometry)this.suspensionNode.getChild("WheelLocationDebugShape" + i);
            Geometry dirGeom = (Geometry)this.suspensionNode.getChild("WheelDirectionDebugShape" + i);
            Geometry axleGeom = (Geometry)this.suspensionNode.getChild("WheelAxleDebugShape" + i);
            Geometry wheelGeom = (Geometry)this.suspensionNode.getChild("WheelRadiusDebugShape" + i);
            Arrow locArrow = (Arrow)locGeom.getMesh();
            locArrow.setArrowExtent(wLocation);
            Arrow axleArrow = (Arrow)axleGeom.getMesh();
            axleArrow.setArrowExtent(axle.normalizeLocal().multLocal(0.3f));
            Arrow wheelArrow = (Arrow)wheelGeom.getMesh();
            wheelArrow.setArrowExtent(wDirection.normalizeLocal().multLocal(radius));
            Arrow dirArrow = (Arrow)dirGeom.getMesh();
            dirArrow.setArrowExtent(wDirection.normalizeLocal().multLocal(restLength));
            dirGeom.setLocalTranslation(wLocation);
            axleGeom.setLocalTranslation(wLocation.addLocal(wDirection));
            wheelGeom.setLocalTranslation(wLocation);
        }
        RigidBodyMotionState motionState = this.vehicle.getMotionState();
        motionState.getLocation(this.location);
        motionState.getOrientation(this.rotation);
        this.applyPhysicsTransform(this.location, this.rotation);
    }

    public void setSpatial(Spatial spatial) {
        if (spatial instanceof Node) {
            Node node = (Node)spatial;
            node.attachChild((Spatial)this.suspensionNode);
        } else if (spatial == null && this.spatial != null) {
            Node node = (Node)this.spatial;
            node.detachChild((Spatial)this.suspensionNode);
        }
        super.setSpatial(spatial);
    }

    private void createVehicle() {
        this.suspensionNode.detachAllChildren();
        for (int i = 0; i < this.vehicle.getNumWheels(); ++i) {
            VehicleWheel physicsVehicleWheel = this.vehicle.getWheel(i);
            Vector3f wLocation = physicsVehicleWheel.getLocation(null);
            Vector3f wDirection = physicsVehicleWheel.getDirection(null);
            Vector3f axle = physicsVehicleWheel.getAxle(null);
            float restLength = physicsVehicleWheel.getRestLength();
            float radius = physicsVehicleWheel.getRadius();
            Arrow locArrow = new Arrow(wLocation);
            Arrow axleArrow = new Arrow(axle.normalizeLocal().multLocal(0.3f));
            Arrow wheelArrow = new Arrow(wDirection.normalizeLocal().multLocal(radius));
            Arrow dirArrow = new Arrow(wDirection.normalizeLocal().multLocal(restLength));
            Geometry locGeom = new Geometry("WheelLocationDebugShape" + i, (Mesh)locArrow);
            Geometry dirGeom = new Geometry("WheelDirectionDebugShape" + i, (Mesh)dirArrow);
            Geometry axleGeom = new Geometry("WheelAxleDebugShape" + i, (Mesh)axleArrow);
            Geometry wheelGeom = new Geometry("WheelRadiusDebugShape" + i, (Mesh)wheelArrow);
            dirGeom.setLocalTranslation(wLocation);
            axleGeom.setLocalTranslation(wLocation.add(wDirection));
            wheelGeom.setLocalTranslation(wLocation.add(wDirection));
            Material material = this.debugAppState.getActiveMaterial(1);
            locGeom.setMaterial(material);
            dirGeom.setMaterial(material);
            axleGeom.setMaterial(material);
            wheelGeom.setMaterial(material);
            this.suspensionNode.attachChild((Spatial)locGeom);
            this.suspensionNode.attachChild((Spatial)dirGeom);
            this.suspensionNode.attachChild((Spatial)axleGeom);
            this.suspensionNode.attachChild((Spatial)wheelGeom);
        }
    }
}

