/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.debug;

import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.collision.shapes.CompoundCollisionShape;
import com.jme3.bullet.debug.AbstractPhysicsDebugControl;
import com.jme3.bullet.debug.BulletDebugAppState;
import com.jme3.bullet.debug.ChildSummaryList;
import com.jme3.material.Material;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import java.util.List;
import java.util.logging.Logger;

abstract class CollisionShapeDebugControl
extends AbstractPhysicsDebugControl {
    static final Logger loggerS = Logger.getLogger(CollisionShapeDebugControl.class.getName());
    private final ChildSummaryList lastSummaryList = new ChildSummaryList();
    private static final ChildSummaryList newSummaryList = new ChildSummaryList();
    private CollisionShape lastShape;
    private float lastMargin;
    protected Spatial debugSpatial;
    private static final Vector3f newScale = new Vector3f();
    private final Vector3f lastScale = new Vector3f();

    CollisionShapeDebugControl(BulletDebugAppState debugAppState) {
        super(debugAppState);
    }

    protected void colorChildren() {
        Node debugNode = (Node)this.debugSpatial;
        List children = debugNode.getChildren();
        int numChildren = children.size();
        for (int childIndex = 0; childIndex < numChildren; ++childIndex) {
            Spatial child = (Spatial)children.get(childIndex);
            Material material = this.debugAppState.getChildMaterial(childIndex);
            child.setMaterial(material);
        }
    }

    protected boolean hasShapeChanged(CollisionShape newShape) {
        float newMargin = newShape.getMargin();
        newShape.getScale(newScale);
        boolean result = false;
        if (this.lastShape != newShape) {
            result = true;
        } else if (this.lastMargin != newMargin) {
            result = true;
        } else if (!this.lastScale.equals((Object)newScale)) {
            result = true;
        } else if (newShape instanceof CompoundCollisionShape) {
            newSummaryList.update((CompoundCollisionShape)newShape);
            if (!newSummaryList.equals(this.lastSummaryList)) {
                result = true;
            }
        }
        return result;
    }

    protected void setShape(CollisionShape shape) {
        this.lastShape = shape;
        this.lastMargin = shape.getMargin();
        shape.getScale(this.lastScale);
        if (shape instanceof CompoundCollisionShape) {
            this.lastSummaryList.update((CompoundCollisionShape)shape);
        }
    }

    public void setSpatial(Spatial spatial) {
        if (spatial instanceof Node) {
            Node node = (Node)spatial;
            node.attachChild(this.debugSpatial);
        } else if (spatial == null && this.spatial != null) {
            Node node = (Node)this.spatial;
            node.detachChild(this.debugSpatial);
        }
        super.setSpatial(spatial);
    }
}

