/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.debug;

import com.jme3.app.Application;
import com.jme3.bullet.PhysicsSpace;
import com.jme3.bullet.debug.BulletDebugAppState;
import com.jme3.bullet.debug.DebugInitListener;
import com.jme3.renderer.Camera;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Spatial;
import java.util.logging.Logger;
import jme3utilities.Validate;

public class DebugConfiguration {
    public static final Logger logger = Logger.getLogger(DebugConfiguration.class.getName());
    private boolean isEnabled = false;
    private BulletDebugAppState.DebugAppStateFilter angularVelocityFilter;
    private BulletDebugAppState.DebugAppStateFilter boundingBoxFilter;
    private BulletDebugAppState.DebugAppStateFilter filter;
    private BulletDebugAppState.DebugAppStateFilter gravityVectorFilter;
    private BulletDebugAppState.DebugAppStateFilter sweptSphereFilter;
    private BulletDebugAppState.DebugAppStateFilter velocityVectorFilter;
    private Camera camera;
    private DebugInitListener initListener;
    private float axisArrowLength = 0.0f;
    private float axisLineWidth = 1.0f;
    private float jointLineWidth = 1.0f;
    private PhysicsSpace space;
    private RenderQueue.ShadowMode shadowMode = RenderQueue.ShadowMode.Off;
    private Spatial transformSpatial;
    private ViewPort[] viewPorts;

    public float axisArrowLength() {
        assert (this.axisArrowLength >= 0.0f) : this.axisArrowLength;
        return this.axisArrowLength;
    }

    public float axisLineWidth() {
        assert (this.axisLineWidth >= 0.0f) : this.axisLineWidth;
        return this.axisLineWidth;
    }

    BulletDebugAppState.DebugAppStateFilter getAngularVelocityFilter() {
        return this.angularVelocityFilter;
    }

    BulletDebugAppState.DebugAppStateFilter getBoundingBoxFilter() {
        return this.boundingBoxFilter;
    }

    public Camera getCamera() {
        return this.camera;
    }

    BulletDebugAppState.DebugAppStateFilter getFilter() {
        return this.filter;
    }

    BulletDebugAppState.DebugAppStateFilter getGravityVectorFilter() {
        return this.gravityVectorFilter;
    }

    DebugInitListener getInitListener() {
        return this.initListener;
    }

    public PhysicsSpace getSpace() {
        return this.space;
    }

    BulletDebugAppState.DebugAppStateFilter getSweptSphereFilter() {
        return this.sweptSphereFilter;
    }

    public Spatial getTransformSpatial() {
        return this.transformSpatial;
    }

    BulletDebugAppState.DebugAppStateFilter getVelocityVectorFilter() {
        return this.velocityVectorFilter;
    }

    public void initialize(Application application) {
        Validate.nonNull((Object)application, (String)"application");
        if (this.camera == null) {
            this.camera = application.getCamera();
        }
        if (this.viewPorts == null) {
            this.viewPorts = new ViewPort[1];
            this.viewPorts[0] = application.getViewPort();
        }
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    float jointLineWidth() {
        assert (this.jointLineWidth >= 1.0f) : this.jointLineWidth;
        return this.jointLineWidth;
    }

    ViewPort[] listViewPorts() {
        int numViewPorts = this.viewPorts.length;
        ViewPort[] result = new ViewPort[numViewPorts];
        System.arraycopy(this.viewPorts, 0, result, 0, numViewPorts);
        return result;
    }

    void renderAllViewPorts(RenderManager renderManager, Spatial rootNode) {
        for (ViewPort viewPort : this.viewPorts) {
            if (!viewPort.isEnabled()) continue;
            renderManager.renderScene(rootNode, viewPort);
        }
    }

    public void setAngularVelocityFilter(BulletDebugAppState.DebugAppStateFilter filter) {
        this.angularVelocityFilter = filter;
    }

    public void setAxisArrowLength(float length) {
        Validate.nonNegative((float)length, (String)"length");
        this.axisArrowLength = length;
    }

    public void setAxisLineWidth(float width) {
        Validate.inRange((float)width, (String)"width", (float)0.0f, (float)Float.MAX_VALUE);
        this.axisLineWidth = width;
    }

    public void setBoundingBoxFilter(BulletDebugAppState.DebugAppStateFilter filter) {
        this.boundingBoxFilter = filter;
    }

    public void setCamera(Camera camera) {
        this.camera = camera;
    }

    public void setEnabled(boolean enable) {
        this.isEnabled = enable;
    }

    public void setFilter(BulletDebugAppState.DebugAppStateFilter filter) {
        this.filter = filter;
    }

    public void setGravityVectorFilter(BulletDebugAppState.DebugAppStateFilter filter) {
        this.gravityVectorFilter = filter;
    }

    public void setInitListener(DebugInitListener listener) {
        this.initListener = listener;
    }

    public void setJointLineWidth(float width) {
        this.jointLineWidth = width;
    }

    public void setShadowMode(RenderQueue.ShadowMode mode) {
        Validate.nonNull((Object)mode, (String)"mode");
        this.shadowMode = mode;
    }

    public void setSpace(PhysicsSpace physicsSpace) {
        this.space = physicsSpace;
    }

    public void setSweptSphereFilter(BulletDebugAppState.DebugAppStateFilter filter) {
        this.sweptSphereFilter = filter;
    }

    public void setTransformSpatial(Spatial spatial) {
        this.transformSpatial = spatial;
    }

    public void setVelocityVectorFilter(BulletDebugAppState.DebugAppStateFilter filter) {
        this.velocityVectorFilter = filter;
    }

    public void setViewPorts(ViewPort ... viewPorts) {
        Validate.nonNull((Object)viewPorts, (String)"view ports");
        int numViewPorts = viewPorts.length;
        this.viewPorts = new ViewPort[numViewPorts];
        System.arraycopy(viewPorts, 0, this.viewPorts, 0, numViewPorts);
    }

    RenderQueue.ShadowMode shadowMode() {
        assert (this.shadowMode != null);
        return this.shadowMode;
    }
}

