/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.debug;

import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.debug.Arrow;
import java.util.logging.Logger;

public class DebugTools {
    public static final Logger logger = Logger.getLogger(DebugTools.class.getName());
    protected static final Vector3f UNIT_XYZ_CHECK = new Vector3f(1.0f, 1.0f, 1.0f);
    protected static final Vector3f UNIT_X_CHECK = new Vector3f(1.0f, 0.0f, 0.0f);
    protected static final Vector3f UNIT_Y_CHECK = new Vector3f(0.0f, 1.0f, 0.0f);
    protected static final Vector3f UNIT_Z_CHECK = new Vector3f(0.0f, 0.0f, 1.0f);
    protected static final Vector3f ZERO_CHECK = new Vector3f(0.0f, 0.0f, 0.0f);
    public Arrow arrowBlue = new Arrow(Vector3f.ZERO);
    public Arrow arrowGreen = new Arrow(Vector3f.ZERO);
    public Arrow arrowMagenta = new Arrow(Vector3f.ZERO);
    public Arrow arrowPink = new Arrow(Vector3f.ZERO);
    public Arrow arrowRed = new Arrow(Vector3f.ZERO);
    public Arrow arrowYellow = new Arrow(Vector3f.ZERO);
    protected final AssetManager manager;
    public Geometry arrowBlueGeom = new Geometry("Blue Arrow", (Mesh)this.arrowBlue);
    public Geometry arrowGreenGeom = new Geometry("Green Arrow", (Mesh)this.arrowGreen);
    public Geometry arrowMagentaGeom = new Geometry("Magenta Arrow", (Mesh)this.arrowMagenta);
    public Geometry arrowPinkGeom = new Geometry("Pink Arrow", (Mesh)this.arrowPink);
    public Geometry arrowRedGeom = new Geometry("Red Arrow", (Mesh)this.arrowRed);
    public Geometry arrowYellowGeom = new Geometry("Yellow Arrow", (Mesh)this.arrowYellow);
    public Material DEBUG_BLUE;
    public Material DEBUG_GREEN;
    public Material DEBUG_MAGENTA;
    public Material DEBUG_PINK;
    public Material DEBUG_RED;
    public Material DEBUG_YELLOW;
    public Node debugNode = new Node("Debug Node");

    public DebugTools(AssetManager manager) {
        this.manager = manager;
        this.setupMaterials();
        this.setupDebugNode();
    }

    public void setBlueArrow(Vector3f location, Vector3f extent) {
        this.arrowBlueGeom.setLocalTranslation(location);
        this.arrowBlue.setArrowExtent(extent);
    }

    public void setGreenArrow(Vector3f location, Vector3f extent) {
        this.arrowGreenGeom.setLocalTranslation(location);
        this.arrowGreen.setArrowExtent(extent);
    }

    public void setMagentaArrow(Vector3f location, Vector3f extent) {
        this.arrowMagentaGeom.setLocalTranslation(location);
        this.arrowMagenta.setArrowExtent(extent);
    }

    public void setPinkArrow(Vector3f location, Vector3f extent) {
        this.arrowPinkGeom.setLocalTranslation(location);
        this.arrowPink.setArrowExtent(extent);
    }

    public void setRedArrow(Vector3f location, Vector3f extent) {
        this.arrowRedGeom.setLocalTranslation(location);
        this.arrowRed.setArrowExtent(extent);
    }

    public void setYellowArrow(Vector3f location, Vector3f extent) {
        this.arrowYellowGeom.setLocalTranslation(location);
        this.arrowYellow.setArrowExtent(extent);
    }

    public void show(RenderManager rm, ViewPort vp) {
        if (!(Vector3f.UNIT_X.equals((Object)UNIT_X_CHECK) && Vector3f.UNIT_Y.equals((Object)UNIT_Y_CHECK) && Vector3f.UNIT_Z.equals((Object)UNIT_Z_CHECK) && Vector3f.UNIT_XYZ.equals((Object)UNIT_XYZ_CHECK) && Vector3f.ZERO.equals((Object)ZERO_CHECK))) {
            throw new IllegalStateException("Unit vectors compromised!\nX: " + Vector3f.UNIT_X + "\nY: " + Vector3f.UNIT_Y + "\nZ: " + Vector3f.UNIT_Z + "\nXYZ: " + Vector3f.UNIT_XYZ + "\nZERO: " + Vector3f.ZERO);
        }
        this.debugNode.updateLogicalState(0.0f);
        this.debugNode.updateGeometricState();
        rm.renderScene((Spatial)this.debugNode, vp);
    }

    protected void setupDebugNode() {
        this.arrowBlueGeom.setMaterial(this.DEBUG_BLUE);
        this.arrowGreenGeom.setMaterial(this.DEBUG_GREEN);
        this.arrowRedGeom.setMaterial(this.DEBUG_RED);
        this.arrowMagentaGeom.setMaterial(this.DEBUG_MAGENTA);
        this.arrowYellowGeom.setMaterial(this.DEBUG_YELLOW);
        this.arrowPinkGeom.setMaterial(this.DEBUG_PINK);
        this.debugNode.attachChild((Spatial)this.arrowBlueGeom);
        this.debugNode.attachChild((Spatial)this.arrowGreenGeom);
        this.debugNode.attachChild((Spatial)this.arrowRedGeom);
        this.debugNode.attachChild((Spatial)this.arrowMagentaGeom);
        this.debugNode.attachChild((Spatial)this.arrowYellowGeom);
        this.debugNode.attachChild((Spatial)this.arrowPinkGeom);
    }

    protected void setupMaterials() {
        this.DEBUG_BLUE = new Material(this.manager, "Common/MatDefs/Misc/Unshaded.j3md");
        this.DEBUG_BLUE.getAdditionalRenderState().setWireframe(true);
        this.DEBUG_BLUE.setColor("Color", ColorRGBA.Blue);
        this.DEBUG_GREEN = new Material(this.manager, "Common/MatDefs/Misc/Unshaded.j3md");
        this.DEBUG_GREEN.getAdditionalRenderState().setWireframe(true);
        this.DEBUG_GREEN.setColor("Color", ColorRGBA.Green);
        this.DEBUG_RED = new Material(this.manager, "Common/MatDefs/Misc/Unshaded.j3md");
        this.DEBUG_RED.getAdditionalRenderState().setWireframe(true);
        this.DEBUG_RED.setColor("Color", ColorRGBA.Red);
        this.DEBUG_YELLOW = new Material(this.manager, "Common/MatDefs/Misc/Unshaded.j3md");
        this.DEBUG_YELLOW.getAdditionalRenderState().setWireframe(true);
        this.DEBUG_YELLOW.setColor("Color", ColorRGBA.Yellow);
        this.DEBUG_MAGENTA = new Material(this.manager, "Common/MatDefs/Misc/Unshaded.j3md");
        this.DEBUG_MAGENTA.getAdditionalRenderState().setWireframe(true);
        this.DEBUG_MAGENTA.setColor("Color", ColorRGBA.Magenta);
        this.DEBUG_PINK = new Material(this.manager, "Common/MatDefs/Misc/Unshaded.j3md");
        this.DEBUG_PINK.getAdditionalRenderState().setWireframe(true);
        this.DEBUG_PINK.setColor("Color", ColorRGBA.Pink);
    }
}

