/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.debug;

import com.jme3.bullet.collision.PhysicsCollisionObject;
import com.jme3.bullet.debug.AbstractPhysicsDebugControl;
import com.jme3.bullet.debug.BulletDebugAppState;
import com.jme3.bullet.objects.PhysicsBody;
import com.jme3.material.Material;
import com.jme3.math.Vector3f;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.debug.Arrow;
import java.util.logging.Logger;

class GravityVectorDebugControl
extends AbstractPhysicsDebugControl {
    static final Logger logger = Logger.getLogger(GravityVectorDebugControl.class.getName());
    private final Geometry geom;
    private final PhysicsBody body;
    private final Vector3f center;
    private final Vector3f extent;

    GravityVectorDebugControl(BulletDebugAppState debugAppState, PhysicsCollisionObject pco) {
        super(debugAppState);
        this.body = (PhysicsBody)pco;
        this.extent = this.body.getGravity(null);
        Arrow mesh = new Arrow(this.extent);
        this.geom = new Geometry("gravity of " + this.body, (Mesh)mesh);
        this.center = this.body.getPhysicsLocation(null);
        this.geom.setLocalTranslation(this.center);
        Material material = debugAppState.getGravityVectorMaterial();
        this.geom.setMaterial(material);
        this.geom.setShadowMode(RenderQueue.ShadowMode.Off);
    }

    protected void controlUpdate(float tpf) {
        this.body.getPhysicsLocation(this.center);
        this.geom.setLocalTranslation(this.center);
        Mesh mesh = this.geom.getMesh();
        Arrow arrow = (Arrow)mesh;
        this.body.getGravity(this.extent);
        arrow.setArrowExtent(this.extent);
    }

    public void setSpatial(Spatial spatial) {
        if (spatial instanceof Node) {
            Node node = (Node)spatial;
            node.attachChild((Spatial)this.geom);
        } else if (spatial == null && this.spatial != null) {
            Node node = (Node)this.spatial;
            node.detachChild((Spatial)this.geom);
        }
        super.setSpatial(spatial);
    }
}

