/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.debug;

import com.jme3.bullet.debug.AbstractPhysicsDebugControl;
import com.jme3.bullet.debug.BulletDebugAppState;
import com.jme3.bullet.debug.SoftDebugAppState;
import com.jme3.bullet.joints.JointEnd;
import com.jme3.bullet.joints.SoftPhysicsJoint;
import com.jme3.bullet.objects.PhysicsBody;
import com.jme3.bullet.objects.PhysicsSoftBody;
import com.jme3.material.Material;
import com.jme3.math.Vector3f;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.util.BufferUtils;
import java.nio.FloatBuffer;
import java.util.logging.Logger;

class SoftJointDebugControl
extends AbstractPhysicsDebugControl {
    public static final Logger logger = Logger.getLogger(SoftJointDebugControl.class.getName());
    private final Geometry endsGeometry;
    private final SoftPhysicsJoint joint;

    SoftJointDebugControl(BulletDebugAppState debugAppState, SoftPhysicsJoint joint) {
        super(debugAppState);
        this.joint = joint;
        this.endsGeometry = this.createEndsGeometry();
    }

    protected void controlUpdate(float tpf) {
        Mesh mesh = this.endsGeometry.getMesh();
        FloatBuffer positionBuffer = mesh.getFloatBuffer(VertexBuffer.Type.Position);
        PhysicsSoftBody softBodyA = this.joint.getSoftBodyA();
        int clusterIndex = this.joint.clusterIndexA();
        Vector3f aLocation = softBodyA.clusterCenter(clusterIndex, null);
        positionBuffer.put(0, aLocation.x);
        positionBuffer.put(1, aLocation.y);
        positionBuffer.put(2, aLocation.z);
        Vector3f bLocation = new Vector3f();
        if (this.joint.isSoftSoft()) {
            PhysicsSoftBody softBodyB = this.joint.getSoftBodyB();
            clusterIndex = this.joint.clusterIndexB();
            softBodyB.clusterCenter(clusterIndex, bLocation);
        } else {
            PhysicsBody rigidBodyB = this.joint.getBody(JointEnd.B);
            rigidBodyB.getPhysicsLocation(bLocation);
        }
        positionBuffer.put(3, bLocation.x);
        positionBuffer.put(4, bLocation.y);
        positionBuffer.put(5, bLocation.z);
        mesh.getBuffer(VertexBuffer.Type.Position).setUpdateNeeded();
        mesh.updateBound();
    }

    public void setSpatial(Spatial spatial) {
        if (spatial instanceof Node) {
            assert (this.spatial == null);
            Node node = (Node)spatial;
            node.attachChild((Spatial)this.endsGeometry);
        } else if (spatial == null && this.spatial != null) {
            Node node = (Node)this.spatial;
            node.detachChild((Spatial)this.endsGeometry);
        }
        super.setSpatial(spatial);
    }

    private Geometry createEndsGeometry() {
        Mesh mesh = new Mesh();
        int numVertices = 2;
        int numFloats = 3 * numVertices;
        FloatBuffer positions = BufferUtils.createFloatBuffer((int)numFloats);
        mesh.setBuffer(VertexBuffer.Type.Position, 3, positions);
        mesh.setMode(Mesh.Mode.Lines);
        mesh.setStreamed();
        Geometry result = new Geometry(this.joint.toString(), mesh);
        result.setShadowMode(RenderQueue.ShadowMode.Off);
        SoftDebugAppState sdas = (SoftDebugAppState)this.debugAppState;
        Material material = sdas.getAnchorMaterial();
        result.setMaterial(material);
        return result;
    }
}

