/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.debug;

import com.jme3.bullet.collision.PhysicsCollisionObject;
import com.jme3.bullet.debug.AbstractPhysicsDebugControl;
import com.jme3.bullet.debug.BulletDebugAppState;
import com.jme3.bullet.debug.DebugConfiguration;
import com.jme3.material.Material;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import java.util.logging.Logger;
import jme3utilities.debug.SphereMeshes;
import jme3utilities.math.MyVector3f;

class SweptSphereDebugControl
extends AbstractPhysicsDebugControl {
    public static final Logger logger = Logger.getLogger(SweptSphereDebugControl.class.getName());
    private final Geometry geom;
    private final PhysicsCollisionObject pco;
    private final Vector3f center;

    SweptSphereDebugControl(BulletDebugAppState debugAppState, PhysicsCollisionObject pco) {
        super(debugAppState);
        this.pco = pco;
        Mesh mesh = this.updateMesh(null);
        this.geom = new Geometry("swept sphere of " + pco, mesh);
        float radius = pco.getCcdSweptSphereRadius();
        this.geom.setLocalScale(radius);
        this.center = pco.getPhysicsLocation(null);
        this.geom.setLocalTranslation(this.center);
        Material material = debugAppState.getSweptSphereMaterial();
        this.geom.setMaterial(material);
        this.geom.setShadowMode(RenderQueue.ShadowMode.Off);
    }

    protected void controlUpdate(float tpf) {
        Mesh newMesh;
        Mesh oldMesh = this.geom.getMesh();
        if (oldMesh != (newMesh = this.updateMesh(oldMesh))) {
            this.geom.setMesh(newMesh);
        }
        float radius = this.pco.getCcdSweptSphereRadius();
        this.geom.setLocalScale(radius);
        this.pco.getPhysicsLocation(this.center);
        this.geom.setLocalTranslation(this.center);
        DebugConfiguration config = this.debugAppState.getConfiguration();
        Camera camera = config.getCamera();
        if (camera != null) {
            Vector3f offset = camera.getLocation().subtract(this.center);
            Vector3f axis1 = new Vector3f();
            Vector3f axis2 = new Vector3f();
            MyVector3f.generateBasis((Vector3f)offset, (Vector3f)axis1, (Vector3f)axis2);
            Quaternion orientation = new Quaternion();
            orientation.fromAxes(axis2, offset, axis1);
            this.geom.setLocalRotation(orientation);
        }
    }

    public void setSpatial(Spatial spatial) {
        if (spatial instanceof Node) {
            Node node = (Node)spatial;
            node.attachChild((Spatial)this.geom);
        } else if (spatial == null && this.spatial != null) {
            Node node = (Node)this.spatial;
            node.detachChild((Spatial)this.geom);
        }
        super.setSpatial(spatial);
    }

    private Mesh updateMesh(Mesh oldMesh) {
        Mesh result;
        DebugConfiguration config = this.debugAppState.getConfiguration();
        Camera camera = config.getCamera();
        SphereMeshes meshType = camera == null ? SphereMeshes.Icosphere : SphereMeshes.LoopMesh;
        if (!meshType.isInstance(result = oldMesh)) {
            float radius = 1.0f;
            boolean wantNormals = false;
            boolean wantUvs = false;
            result = meshType.makeSphere(radius, wantNormals, wantUvs);
        }
        return result;
    }
}

