/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.joints;

import com.jme3.bullet.joints.PhysicsJoint;
import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.bullet.objects.PhysicsSoftBody;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Vector3f;
import com.jme3.util.clone.Cloner;
import java.io.IOException;
import java.util.logging.Logger;
import jme3utilities.Validate;

public class Anchor
extends PhysicsJoint {
    public static final Logger logger2 = Logger.getLogger(Anchor.class.getName());
    private static final String tagAllowCollisions = "allowCollisions";
    private static final String tagInfluence = "influence";
    private static final String tagNodeIndexA = "nodeIndexA";
    private static final String tagPivotInB = "pivotInB";
    private boolean allowCollisions;
    private float influence = 1.0f;
    private int nodeIndexA;
    private Vector3f pivotInB;

    protected Anchor() {
    }

    public Anchor(PhysicsSoftBody softBodyA, int nodeIndexA, PhysicsRigidBody rigidBodyB, Vector3f pivotInB, boolean allowCollisions) {
        int numNodes = softBodyA.countNodes();
        Validate.inRange((int)nodeIndexA, (String)"node index", (int)0, (int)(numNodes - 1));
        Validate.nonNull((Object)rigidBodyB, (String)"rigid body B");
        Validate.finite((Vector3f)pivotInB, (String)"pivot location");
        this.setBodyA(softBodyA);
        softBodyA.addJoint(this);
        this.nodeIndexA = nodeIndexA;
        this.setBodyB(rigidBodyB);
        rigidBodyB.addJoint(this);
        this.allowCollisions = allowCollisions;
        this.pivotInB = pivotInB.clone();
        this.createAnchor();
    }

    public Vector3f copyPivot(Vector3f storeResult) {
        if (storeResult == null) {
            return this.pivotInB.clone();
        }
        return storeResult.set(this.pivotInB);
    }

    public PhysicsRigidBody getRigidBody() {
        PhysicsRigidBody result = (PhysicsRigidBody)this.getBodyB();
        assert (result != null);
        return result;
    }

    public PhysicsSoftBody getSoftBody() {
        PhysicsSoftBody result = (PhysicsSoftBody)this.getBodyA();
        assert (result != null);
        return result;
    }

    public float influence() {
        return this.influence;
    }

    public boolean isAllowCollision() {
        return this.allowCollisions;
    }

    public int nodeIndex() {
        assert (this.nodeIndexA >= 0) : this.nodeIndexA;
        return this.nodeIndexA;
    }

    public void setInfluence(float amount) {
        Validate.fraction((float)amount, (String)"amount");
        this.influence = amount;
        long anchorId = this.nativeId();
        Anchor.setInfluence(anchorId, amount);
    }

    public void setPivotInB(Vector3f location) {
        Validate.nonNull((Object)location, (String)"location");
        this.pivotInB.set(location);
        long anchorId = this.nativeId();
        Anchor.setPivotInB(anchorId, location);
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        super.cloneFields(cloner, original);
        this.pivotInB = (Vector3f)cloner.clone((Object)this.pivotInB);
        this.createAnchor();
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public Anchor jmeClone() {
        try {
            Anchor clone = (Anchor)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public void read(JmeImporter importer) throws IOException {
        super.read(importer);
        InputCapsule capsule = importer.getCapsule((Savable)this);
        this.allowCollisions = capsule.readBoolean(tagAllowCollisions, true);
        this.influence = capsule.readFloat(tagInfluence, 1.0f);
        this.nodeIndexA = capsule.readInt(tagNodeIndexA, 0);
        this.pivotInB = (Vector3f)capsule.readSavable(tagPivotInB, (Savable)new Vector3f());
        this.createAnchor();
    }

    @Override
    public void write(JmeExporter exporter) throws IOException {
        super.write(exporter);
        OutputCapsule capsule = exporter.getCapsule((Savable)this);
        capsule.write(this.allowCollisions, tagAllowCollisions, true);
        capsule.write(this.influence, tagInfluence, 1.0f);
        capsule.write(this.nodeIndexA, tagNodeIndexA, 0);
        capsule.write((Savable)this.pivotInB, tagPivotInB, null);
    }

    private void createAnchor() {
        PhysicsSoftBody a = this.getSoftBody();
        long aId = a.nativeId();
        assert (this.nodeIndexA >= 0) : this.nodeIndexA;
        assert (this.nodeIndexA < a.countNodes()) : this.nodeIndexA;
        PhysicsRigidBody b = this.getRigidBody();
        long bId = b.nativeId();
        long anchorId = Anchor.createAnchor(aId, this.nodeIndexA, bId, this.pivotInB, this.allowCollisions, this.influence);
        this.setNativeIdNotTracked(anchorId);
    }

    private static native long createAnchor(long var0, int var2, long var3, Vector3f var5, boolean var6, float var7);

    private static native void setInfluence(long var0, float var2);

    private static native void setPivotInB(long var0, Vector3f var2);
}

