/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.joints;

import com.jme3.bullet.joints.Constraint;
import com.jme3.bullet.objects.PhysicsBody;
import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Vector3f;
import com.jme3.util.clone.Cloner;
import java.io.IOException;
import java.util.logging.Logger;
import jme3utilities.Validate;
import jme3utilities.math.MyVector3f;

public class GearJoint
extends Constraint {
    public static final Logger logger2 = Logger.getLogger(GearJoint.class.getName());
    private static final String tagAxisA = "axisA";
    private static final String tagAxisB = "axisB";
    private static final String tagRatio = "ratio";
    private Vector3f axisA;
    private Vector3f axisB;
    private float ratio;

    protected GearJoint() {
    }

    public GearJoint(PhysicsRigidBody rigidBodyA, PhysicsRigidBody rigidBodyB, Vector3f axisInA, Vector3f axisInB) {
        super((PhysicsBody)rigidBodyA, rigidBodyB, Vector3f.ZERO, Vector3f.ZERO);
        Validate.nonZero((Vector3f)axisInA, (String)"axis in body A");
        Validate.nonZero((Vector3f)axisInB, (String)"axis in body B");
        this.axisA = axisInA.normalize();
        this.axisB = axisInB.normalize();
        this.ratio = 1.0f;
        this.createJoint();
    }

    public GearJoint(PhysicsRigidBody rigidBodyA, PhysicsRigidBody rigidBodyB, Vector3f axisInA, Vector3f axisInB, float ratio) {
        super((PhysicsBody)rigidBodyA, rigidBodyB, Vector3f.ZERO, Vector3f.ZERO);
        Validate.nonZero((Vector3f)axisInA, (String)"axis in body A");
        Validate.nonZero((Vector3f)axisInB, (String)"axis in body B");
        this.axisA = axisInA.normalize();
        this.axisB = axisInB.normalize();
        this.ratio = ratio;
        this.createJoint();
    }

    public Vector3f getAxisA(Vector3f storeResult) {
        assert (this.checkAxisA());
        if (storeResult == null) {
            return this.axisA.clone();
        }
        return storeResult.set(this.axisA);
    }

    public Vector3f getAxisB(Vector3f storeResult) {
        assert (this.checkAxisB());
        if (storeResult == null) {
            return this.axisB.clone();
        }
        return storeResult.set(this.axisB);
    }

    public float getRatio() {
        assert (this.ratio == GearJoint.getRatio(this.nativeId())) : this.ratio;
        return this.ratio;
    }

    public void setAxisA(Vector3f axisInA) {
        Validate.nonZero((Vector3f)axisInA, (String)"axis in body A");
        this.axisA.set(axisInA);
        MyVector3f.normalizeLocal((Vector3f)this.axisA);
        long constraintId = this.nativeId();
        GearJoint.setAxisA(constraintId, this.axisA);
    }

    public void setAxisB(Vector3f axisInB) {
        Validate.nonZero((Vector3f)axisInB, (String)"axis in body B");
        this.axisB.set(axisInB);
        MyVector3f.normalizeLocal((Vector3f)this.axisB);
        long constraintId = this.nativeId();
        GearJoint.setAxisB(constraintId, this.axisB);
    }

    public void setRatio(float ratio) {
        this.ratio = ratio;
        long constraintId = this.nativeId();
        GearJoint.setRatio(constraintId, ratio);
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        super.cloneFields(cloner, original);
        this.axisA = (Vector3f)cloner.clone((Object)this.axisA);
        this.axisB = (Vector3f)cloner.clone((Object)this.axisB);
        this.createJoint();
        GearJoint old = (GearJoint)original;
        float bit = old.getBreakingImpulseThreshold();
        this.setBreakingImpulseThreshold(bit);
        boolean enableJoint = old.isEnabled();
        this.setEnabled(enableJoint);
        int numIterations = old.getOverrideIterations();
        this.overrideIterations(numIterations);
    }

    @Override
    public GearJoint jmeClone() {
        try {
            GearJoint clone = (GearJoint)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public void read(JmeImporter importer) throws IOException {
        super.read(importer);
        InputCapsule capsule = importer.getCapsule((Savable)this);
        this.axisA = (Vector3f)capsule.readSavable(tagAxisA, null);
        this.axisB = (Vector3f)capsule.readSavable(tagAxisB, null);
        this.ratio = capsule.readFloat(tagRatio, 1.0f);
        this.createJoint();
        this.readConstraintProperties(capsule);
    }

    @Override
    public void write(JmeExporter exporter) throws IOException {
        super.write(exporter);
        OutputCapsule capsule = exporter.getCapsule((Savable)this);
        capsule.write((Savable)this.axisA, tagAxisA, null);
        capsule.write((Savable)this.axisB, tagAxisB, null);
        capsule.write(this.ratio, tagRatio, 1.0f);
    }

    private boolean checkAxisA() {
        long constraintId = this.nativeId();
        Vector3f tmpVector = new Vector3f();
        GearJoint.getAxisA(constraintId, tmpVector);
        boolean result = this.axisA.equals((Object)tmpVector);
        return result;
    }

    private boolean checkAxisB() {
        long constraintId = this.nativeId();
        Vector3f tmpVector = new Vector3f();
        GearJoint.getAxisB(constraintId, tmpVector);
        boolean result = this.axisB.equals((Object)tmpVector);
        return result;
    }

    private void createJoint() {
        PhysicsRigidBody a = this.getBodyA();
        long aId = a.nativeId();
        assert (!MyVector3f.isZero((Vector3f)this.axisA));
        PhysicsRigidBody b = this.getBodyB();
        long bId = b.nativeId();
        assert (!MyVector3f.isZero((Vector3f)this.axisB));
        long constraintId = GearJoint.createJoint(aId, bId, this.axisA, this.axisB, this.ratio);
        assert (GearJoint.getConstraintType(constraintId) == 10);
        this.setNativeId(constraintId);
    }

    private static native long createJoint(long var0, long var2, Vector3f var4, Vector3f var5, float var6);

    private static native void getAxisA(long var0, Vector3f var2);

    private static native void getAxisB(long var0, Vector3f var2);

    private static native float getRatio(long var0);

    private static native void setAxisA(long var0, Vector3f var2);

    private static native void setAxisB(long var0, Vector3f var2);

    private static native void setRatio(long var0, float var2);
}

