/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.joints;

import com.jme3.bullet.NativePhysicsObject;
import com.jme3.bullet.PhysicsSpace;
import com.jme3.bullet.joints.JointEnd;
import com.jme3.bullet.objects.PhysicsBody;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.util.clone.Cloner;
import com.jme3.util.clone.JmeCloneable;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jme3utilities.Validate;

public abstract class PhysicsJoint
extends NativePhysicsObject
implements JmeCloneable,
Savable {
    public static final Logger logger = Logger.getLogger(PhysicsJoint.class.getName());
    private static final String tagNodeA = "nodeA";
    private static final String tagNodeB = "nodeB";
    private PhysicsBody bodyA = null;
    private PhysicsBody bodyB = null;
    private PhysicsSpace space = null;

    protected PhysicsJoint() {
    }

    public int countEnds() {
        if (this.bodyA == null || this.bodyB == null) {
            return 1;
        }
        return 2;
    }

    public void destroy() {
        if (this.bodyA != null) {
            this.bodyA.removeJoint(this);
        }
        if (this.bodyB != null) {
            this.bodyB.removeJoint(this);
        }
    }

    public JointEnd findEnd(PhysicsBody body) {
        Validate.nonNull((Object)body, (String)"body");
        if (body == this.bodyA) {
            return JointEnd.A;
        }
        if (body == this.bodyB) {
            return JointEnd.B;
        }
        return null;
    }

    public PhysicsBody findOtherBody(PhysicsBody body) {
        Validate.nonNull((Object)body, (String)"body");
        assert (this.bodyA != this.bodyB);
        if (body == this.bodyA) {
            return this.bodyB;
        }
        if (body == this.bodyB) {
            return this.bodyA;
        }
        return null;
    }

    public PhysicsBody getBody(JointEnd end) {
        Validate.nonNull((Object)((Object)end), (String)"end");
        switch (end) {
            case A: {
                return this.bodyA;
            }
            case B: {
                return this.bodyB;
            }
        }
        throw new IllegalArgumentException("end = " + (Object)((Object)end));
    }

    public PhysicsBody getBodyA() {
        return this.bodyA;
    }

    public PhysicsBody getBodyB() {
        return this.bodyB;
    }

    public final long getObjectId() {
        long jointId = this.nativeId();
        return jointId;
    }

    public PhysicsSpace getPhysicsSpace() {
        PhysicsSpace result = this.space;
        return result;
    }

    public abstract boolean isEnabled();

    public void setPhysicsSpace(PhysicsSpace physicsSpace) {
        this.space = physicsSpace;
    }

    protected final void setBodyA(PhysicsBody body) {
        assert (body != null);
        assert (this.bodyA == null) : this.bodyA;
        this.bodyA = body;
    }

    protected final void setBodyB(PhysicsBody body) {
        assert (body != null);
        assert (this.bodyB == null) : this.bodyB;
        this.bodyB = body;
    }

    public void cloneFields(Cloner cloner, Object original) {
        this.bodyA = (PhysicsBody)cloner.clone((Object)this.bodyA);
        this.bodyB = (PhysicsBody)cloner.clone((Object)this.bodyB);
        this.space = null;
        this.unassignNativeObject();
    }

    public PhysicsJoint jmeClone() {
        try {
            PhysicsJoint clone = (PhysicsJoint)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException exception) {
            throw new RuntimeException(exception);
        }
    }

    public void read(JmeImporter importer) throws IOException {
        InputCapsule capsule = importer.getCapsule((Savable)this);
        this.bodyA = (PhysicsBody)capsule.readSavable(tagNodeA, null);
        this.bodyB = (PhysicsBody)capsule.readSavable(tagNodeB, null);
    }

    public void write(JmeExporter exporter) throws IOException {
        OutputCapsule capsule = exporter.getCapsule((Savable)this);
        capsule.write((Savable)this.bodyA, tagNodeA, null);
        capsule.write((Savable)this.bodyB, tagNodeB, null);
    }

    @Override
    protected void setNativeId(long jointId) {
        super.setNativeId(jointId);
        logger.log(Level.FINE, "Created {0}.", this);
    }

    @Override
    public String toString() {
        String result = this.getClass().getSimpleName();
        result = result.replace("Joint", "");
        result = result.replace("Physics", "");
        result = result.replace("Point", "P");
        result = result.replace("Six", "6");
        long jointId = this.nativeId();
        result = result + "#" + Long.toHexString(jointId);
        return result;
    }
}

