/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.joints;

import com.jme3.bullet.joints.Constraint;
import com.jme3.bullet.joints.JointEnd;
import com.jme3.bullet.joints.motors.RotationalLimitMotor;
import com.jme3.bullet.joints.motors.TranslationalLimitMotor;
import com.jme3.bullet.objects.PhysicsBody;
import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Matrix3f;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.util.clone.Cloner;
import java.io.IOException;
import java.util.logging.Logger;
import jme3utilities.Validate;

public class SixDofJoint
extends Constraint {
    private static final int numAxes = 3;
    public static final Logger logger2 = Logger.getLogger(SixDofJoint.class.getName());
    private static final String tagAccumulatedImpulse = "_AccumulatedImpulse";
    private static final String tagAngularLowerLimit = "angularLowerLimit";
    private static final String tagAngularUpperLimit = "angularUpperLimit";
    private static final String tagBounce = "_Bounce";
    private static final String tagDamping = "_Damping";
    private static final String tagEnable = "_Enable";
    private static final String tagERP = "_ERP";
    private static final String tagHiLimit = "_HiLimit";
    private static final String tagLimitSoftness = "_LimitSoftness";
    private static final String tagLinearLowerLimit = "linearLowerLimit";
    private static final String tagLinearUpperLimit = "linearUpperLimit";
    private static final String tagLoLimit = "_LoLimit";
    private static final String tagMaxForce = "_MaxForce";
    private static final String tagMaxLimitForce = "_MaxLimitForce";
    private static final String tagNormalCFM = "_NormalCFM";
    private static final String tagRotA = "rotA";
    private static final String tagRotB = "rotB";
    private static final String tagRotMotor = "rotMotor";
    private static final String tagStopCFM = "_StopCFM";
    private static final String tagTargetVelocity = "_TargetVelocity";
    private static final String tagTransMotor = "transMotor";
    private static final String tagUseLinearReferenceFrameA = "useLinearReferenceFrameA";
    private Matrix3f rotA;
    private Matrix3f rotB;
    private boolean useLinearReferenceFrameA;
    private RotationalLimitMotor[] rotationalMotors;
    private TranslationalLimitMotor translationalMotor;
    private Vector3f angularUpperLimit = new Vector3f(0.0f, 0.0f, 0.0f);
    private Vector3f angularLowerLimit = new Vector3f(0.0f, 0.0f, 0.0f);
    private Vector3f linearUpperLimit = new Vector3f(0.0f, 0.0f, 0.0f);
    private Vector3f linearLowerLimit = new Vector3f(0.0f, 0.0f, 0.0f);

    protected SixDofJoint() {
    }

    public SixDofJoint(PhysicsRigidBody rigidBodyB, Vector3f pivotInB, Vector3f pivotInWorld, Matrix3f rotInB, Matrix3f rotInWorld, JointEnd linearReferenceFrame) {
        super(rigidBodyB, JointEnd.B, pivotInB, pivotInWorld);
        this.useLinearReferenceFrameA = linearReferenceFrame == JointEnd.A;
        this.rotA = rotInWorld.clone();
        this.rotB = rotInB.clone();
        this.createJoint();
    }

    public SixDofJoint(PhysicsRigidBody rigidBodyA, PhysicsRigidBody rigidBodyB, Vector3f pivotInA, Vector3f pivotInB, Matrix3f rotInA, Matrix3f rotInB, boolean useLinearReferenceFrameA) {
        super((PhysicsBody)rigidBodyA, rigidBodyB, pivotInA, pivotInB);
        this.useLinearReferenceFrameA = useLinearReferenceFrameA;
        this.rotA = rotInA.clone();
        this.rotB = rotInB.clone();
        this.createJoint();
    }

    public SixDofJoint(PhysicsRigidBody rigidBodyA, PhysicsRigidBody rigidBodyB, Vector3f pivotInA, Vector3f pivotInB, boolean useLinearReferenceFrameA) {
        super((PhysicsBody)rigidBodyA, rigidBodyB, pivotInA, pivotInB);
        this.useLinearReferenceFrameA = useLinearReferenceFrameA;
        this.rotA = new Matrix3f();
        this.rotB = new Matrix3f();
        this.createJoint();
    }

    public Vector3f getAngles(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long constraintId = this.nativeId();
        SixDofJoint.getAngles(constraintId, result);
        return result;
    }

    public Vector3f getAngularLowerLimit(Vector3f storeResult) {
        if (storeResult == null) {
            return this.angularLowerLimit.clone();
        }
        return storeResult.set(this.angularLowerLimit);
    }

    public Vector3f getAngularUpperLimit(Vector3f storeResult) {
        if (storeResult == null) {
            return this.angularUpperLimit.clone();
        }
        return storeResult.set(this.angularUpperLimit);
    }

    public Transform getFrameTransform(JointEnd end, Transform storeResult) {
        Transform result = storeResult == null ? new Transform() : storeResult;
        long constraintId = this.nativeId();
        switch (end) {
            case A: {
                SixDofJoint.getFrameOffsetA(constraintId, result);
                break;
            }
            case B: {
                SixDofJoint.getFrameOffsetB(constraintId, result);
                break;
            }
            default: {
                String message = "end = " + (Object)((Object)end);
                throw new IllegalArgumentException(message);
            }
        }
        return result;
    }

    public Vector3f getLinearLowerLimit(Vector3f storeResult) {
        if (storeResult == null) {
            return this.linearLowerLimit.clone();
        }
        return storeResult.set(this.linearLowerLimit);
    }

    public Vector3f getLinearUpperLimit(Vector3f storeResult) {
        if (storeResult == null) {
            return this.linearUpperLimit.clone();
        }
        return storeResult.set(this.linearUpperLimit);
    }

    public Vector3f getPivotOffset(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long constraintId = this.nativeId();
        SixDofJoint.getPivotOffset(constraintId, result);
        return result;
    }

    public RotationalLimitMotor getRotationalLimitMotor(int axisIndex) {
        Validate.axisIndex((int)axisIndex, (String)"axis index");
        return this.rotationalMotors[axisIndex];
    }

    public TranslationalLimitMotor getTranslationalLimitMotor() {
        return this.translationalMotor;
    }

    public void setAngularLowerLimit(Vector3f limits) {
        Validate.inRange((float)limits.x, (String)"limits.x", (float)((float)(-Math.PI)), (float)((float)Math.PI));
        Validate.inRange((float)limits.y, (String)"limits.y", (float)-1.5707964f, (float)1.5707964f);
        Validate.inRange((float)limits.z, (String)"limits.z", (float)((float)(-Math.PI)), (float)((float)Math.PI));
        this.angularLowerLimit.set(limits);
        long constraintId = this.nativeId();
        SixDofJoint.setAngularLowerLimit(constraintId, limits);
    }

    public void setAngularUpperLimit(Vector3f limits) {
        Validate.inRange((float)limits.x, (String)"limits.x", (float)((float)(-Math.PI)), (float)((float)Math.PI));
        Validate.inRange((float)limits.y, (String)"limits.y", (float)-1.5707964f, (float)1.5707964f);
        Validate.inRange((float)limits.z, (String)"limits.z", (float)((float)(-Math.PI)), (float)((float)Math.PI));
        this.angularUpperLimit.set(limits);
        long constraintId = this.nativeId();
        SixDofJoint.setAngularUpperLimit(constraintId, limits);
    }

    public void setLinearLowerLimit(Vector3f vector) {
        this.linearLowerLimit.set(vector);
        long constraintId = this.nativeId();
        SixDofJoint.setLinearLowerLimit(constraintId, vector);
    }

    public void setLinearUpperLimit(Vector3f vector) {
        this.linearUpperLimit.set(vector);
        long constraintId = this.nativeId();
        SixDofJoint.setLinearUpperLimit(constraintId, vector);
    }

    protected native long createJoint(long var1, long var3, Vector3f var5, Matrix3f var6, Vector3f var7, Matrix3f var8, boolean var9);

    protected native long createJoint1(long var1, Vector3f var3, Matrix3f var4, boolean var5);

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        int i;
        super.cloneFields(cloner, original);
        this.rotA = (Matrix3f)cloner.clone((Object)this.rotA);
        this.rotB = (Matrix3f)cloner.clone((Object)this.rotB);
        this.rotationalMotors = null;
        this.translationalMotor = null;
        this.createJoint();
        this.angularLowerLimit = (Vector3f)cloner.clone((Object)this.angularLowerLimit);
        this.angularUpperLimit = (Vector3f)cloner.clone((Object)this.angularUpperLimit);
        this.linearLowerLimit = (Vector3f)cloner.clone((Object)this.linearLowerLimit);
        this.linearUpperLimit = (Vector3f)cloner.clone((Object)this.linearUpperLimit);
        SixDofJoint old = (SixDofJoint)original;
        float bit = old.getBreakingImpulseThreshold();
        this.setBreakingImpulseThreshold(bit);
        boolean enableJoint = old.isEnabled();
        this.setEnabled(enableJoint);
        int numIterations = old.getOverrideIterations();
        this.overrideIterations(numIterations);
        this.setAngularLowerLimit(old.getAngularLowerLimit(null));
        this.setAngularUpperLimit(old.getAngularUpperLimit(null));
        this.setLinearLowerLimit(old.getLinearLowerLimit(null));
        this.setLinearLowerLimit(old.getLinearUpperLimit(null));
        TranslationalLimitMotor tlm = this.getTranslationalLimitMotor();
        TranslationalLimitMotor oldTlm = old.getTranslationalLimitMotor();
        tlm.setAccumulatedImpulse(oldTlm.getAccumulatedImpulse(null));
        tlm.setDamping(oldTlm.getDamping());
        for (i = 0; i < 3; ++i) {
            tlm.setEnabled(i, oldTlm.isEnabled(i));
        }
        tlm.setERP(oldTlm.getERP(null));
        tlm.setLimitSoftness(oldTlm.getLimitSoftness());
        tlm.setLowerLimit(oldTlm.getLowerLimit(null));
        tlm.setMaxMotorForce(oldTlm.getMaxMotorForce(null));
        tlm.setNormalCFM(oldTlm.getNormalCFM(null));
        tlm.setRestitution(oldTlm.getRestitution());
        tlm.setStopCFM(oldTlm.getStopCFM(null));
        tlm.setTargetVelocity(oldTlm.getTargetVelocity(null));
        tlm.setUpperLimit(oldTlm.getUpperLimit(null));
        for (i = 0; i < 3; ++i) {
            RotationalLimitMotor rlm = this.getRotationalLimitMotor(i);
            RotationalLimitMotor oldRlm = old.getRotationalLimitMotor(i);
            rlm.setAccumulatedImpulse(oldRlm.getAccumulatedImpulse());
            rlm.setRestitution(oldRlm.getRestitution());
            rlm.setDamping(oldRlm.getDamping());
            rlm.setEnableMotor(oldRlm.isEnableMotor());
            rlm.setERP(oldRlm.getERP());
            rlm.setUpperLimit(oldRlm.getUpperLimit());
            rlm.setLimitSoftness(oldRlm.getLimitSoftness());
            rlm.setLowerLimit(oldRlm.getLowerLimit());
            rlm.setMaxLimitForce(oldRlm.getMaxLimitForce());
            rlm.setMaxMotorForce(oldRlm.getMaxMotorForce());
            rlm.setNormalCFM(oldRlm.getNormalCFM());
            rlm.setStopCFM(oldRlm.getStopCFM());
            rlm.setTargetVelocity(oldRlm.getTargetVelocity());
        }
    }

    @Override
    public SixDofJoint jmeClone() {
        try {
            SixDofJoint clone = (SixDofJoint)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public void read(JmeImporter importer) throws IOException {
        super.read(importer);
        InputCapsule capsule = importer.getCapsule((Savable)this);
        this.rotA = (Matrix3f)capsule.readSavable(tagRotA, null);
        this.rotB = (Matrix3f)capsule.readSavable(tagRotB, null);
        this.useLinearReferenceFrameA = capsule.readBoolean(tagUseLinearReferenceFrameA, false);
        this.createJoint();
        this.readConstraintProperties(capsule);
        this.setAngularLowerLimit((Vector3f)capsule.readSavable(tagAngularLowerLimit, null));
        this.setAngularUpperLimit((Vector3f)capsule.readSavable(tagAngularUpperLimit, null));
        this.setLinearLowerLimit((Vector3f)capsule.readSavable(tagLinearLowerLimit, null));
        this.setLinearUpperLimit((Vector3f)capsule.readSavable(tagLinearUpperLimit, null));
        for (int axisIndex = 0; axisIndex < 3; ++axisIndex) {
            RotationalLimitMotor rlm = this.getRotationalLimitMotor(axisIndex);
            String motorTag = tagRotMotor + axisIndex;
            rlm.setAccumulatedImpulse(capsule.readFloat(motorTag + tagAccumulatedImpulse, 0.0f));
            rlm.setRestitution(capsule.readFloat(motorTag + tagBounce, 0.0f));
            rlm.setDamping(capsule.readFloat(motorTag + tagDamping, 1.0f));
            rlm.setEnableMotor(capsule.readBoolean(motorTag + tagEnable, false));
            rlm.setERP(capsule.readFloat(motorTag + tagERP, 0.5f));
            rlm.setUpperLimit(capsule.readFloat(motorTag + tagHiLimit, Float.POSITIVE_INFINITY));
            rlm.setLimitSoftness(capsule.readFloat(motorTag + tagLimitSoftness, 0.5f));
            rlm.setLowerLimit(capsule.readFloat(motorTag + tagLoLimit, Float.NEGATIVE_INFINITY));
            rlm.setMaxLimitForce(capsule.readFloat(motorTag + tagMaxLimitForce, 300.0f));
            rlm.setMaxMotorForce(capsule.readFloat(motorTag + tagMaxForce, 0.1f));
            rlm.setNormalCFM(capsule.readFloat(motorTag + tagNormalCFM, 0.0f));
            rlm.setStopCFM(capsule.readFloat(motorTag + tagStopCFM, 0.0f));
            rlm.setTargetVelocity(capsule.readFloat(motorTag + tagTargetVelocity, 0.0f));
        }
        TranslationalLimitMotor tlm = this.translationalMotor;
        String motorTag = tagTransMotor;
        tlm.setAccumulatedImpulse((Vector3f)capsule.readSavable(motorTag + tagAccumulatedImpulse, null));
        tlm.setRestitution(capsule.readFloat(motorTag + tagBounce, 0.5f));
        tlm.setDamping(capsule.readFloat(motorTag + tagDamping, 1.0f));
        for (int axisIndex = 0; axisIndex < 3; ++axisIndex) {
            tlm.setEnabled(axisIndex, capsule.readBoolean(motorTag + tagEnable + axisIndex, false));
        }
        tlm.setERP((Vector3f)capsule.readSavable(motorTag + tagERP, null));
        tlm.setUpperLimit((Vector3f)capsule.readSavable(motorTag + tagHiLimit, null));
        tlm.setLimitSoftness(capsule.readFloat(motorTag + tagLimitSoftness, 0.7f));
        tlm.setLowerLimit((Vector3f)capsule.readSavable(motorTag + tagLoLimit, null));
        tlm.setMaxMotorForce((Vector3f)capsule.readSavable(motorTag + tagMaxForce, null));
        tlm.setNormalCFM((Vector3f)capsule.readSavable(motorTag + tagNormalCFM, null));
        tlm.setStopCFM((Vector3f)capsule.readSavable(motorTag + tagStopCFM, null));
        tlm.setTargetVelocity((Vector3f)capsule.readSavable(motorTag + tagTargetVelocity, null));
    }

    @Override
    public void write(JmeExporter exporter) throws IOException {
        super.write(exporter);
        OutputCapsule capsule = exporter.getCapsule((Savable)this);
        capsule.write((Savable)this.rotA, tagRotA, null);
        capsule.write((Savable)this.rotB, tagRotB, null);
        capsule.write(this.useLinearReferenceFrameA, tagUseLinearReferenceFrameA, false);
        capsule.write((Savable)this.angularUpperLimit, tagAngularUpperLimit, null);
        capsule.write((Savable)this.angularLowerLimit, tagAngularLowerLimit, null);
        capsule.write((Savable)this.linearUpperLimit, tagLinearUpperLimit, null);
        capsule.write((Savable)this.linearLowerLimit, tagLinearLowerLimit, null);
        for (int axisIndex = 0; axisIndex < 3; ++axisIndex) {
            RotationalLimitMotor rlm = this.rotationalMotors[axisIndex];
            String motorTag = tagRotMotor + axisIndex;
            capsule.write(rlm.getAccumulatedImpulse(), motorTag + tagAccumulatedImpulse, 0.0f);
            capsule.write(rlm.getRestitution(), motorTag + tagBounce, 0.0f);
            capsule.write(rlm.getDamping(), motorTag + tagDamping, 1.0f);
            capsule.write(rlm.isEnableMotor(), motorTag + tagEnable, false);
            capsule.write(rlm.getERP(), motorTag + tagERP, 0.5f);
            capsule.write(rlm.getUpperLimit(), motorTag + tagHiLimit, Float.POSITIVE_INFINITY);
            capsule.write(rlm.getLimitSoftness(), motorTag + tagLimitSoftness, 0.5f);
            capsule.write(rlm.getLowerLimit(), motorTag + tagLoLimit, Float.NEGATIVE_INFINITY);
            capsule.write(rlm.getMaxLimitForce(), motorTag + tagMaxLimitForce, 300.0f);
            capsule.write(rlm.getMaxMotorForce(), motorTag + tagMaxForce, 0.1f);
            capsule.write(rlm.getNormalCFM(), motorTag + tagNormalCFM, 0.0f);
            capsule.write(rlm.getStopCFM(), motorTag + tagStopCFM, 0.0f);
            capsule.write(rlm.getTargetVelocity(), motorTag + tagTargetVelocity, 0.0f);
        }
        TranslationalLimitMotor tlm = this.translationalMotor;
        String motorTag = tagTransMotor;
        capsule.write((Savable)tlm.getAccumulatedImpulse(null), motorTag + tagAccumulatedImpulse, null);
        capsule.write(tlm.getRestitution(), motorTag + tagBounce, 0.5f);
        capsule.write(tlm.getDamping(), motorTag + tagDamping, 1.0f);
        for (int axisIndex = 0; axisIndex < 3; ++axisIndex) {
            capsule.write(tlm.isEnabled(axisIndex), motorTag + tagEnable + axisIndex, false);
        }
        capsule.write((Savable)tlm.getERP(null), motorTag + tagERP, null);
        capsule.write((Savable)tlm.getUpperLimit(null), motorTag + tagHiLimit, null);
        capsule.write(tlm.getLimitSoftness(), motorTag + tagLimitSoftness, 0.7f);
        capsule.write((Savable)tlm.getLowerLimit(null), motorTag + tagLoLimit, null);
        capsule.write((Savable)tlm.getMaxMotorForce(null), motorTag + tagMaxForce, null);
        capsule.write((Savable)tlm.getNormalCFM(null), motorTag + tagNormalCFM, null);
        capsule.write((Savable)tlm.getStopCFM(null), motorTag + tagStopCFM, null);
        capsule.write((Savable)tlm.getTargetVelocity(null), motorTag + tagTargetVelocity, null);
    }

    private void createJoint() {
        long constraintId;
        PhysicsRigidBody a = this.getBodyA();
        assert (this.pivotA != null);
        assert (this.rotA != null);
        PhysicsRigidBody b = this.getBodyB();
        long bId = b.nativeId();
        assert (this.pivotB != null);
        assert (this.rotB != null);
        if (a == null) {
            Transform jInWorld = new Transform();
            jInWorld.getRotation().fromRotationMatrix(this.rotA);
            jInWorld.setTranslation(this.pivotA);
            Transform jInB = new Transform();
            jInB.getRotation().fromRotationMatrix(this.rotB);
            jInB.setTranslation(this.pivotB);
            Transform bToWorld = jInB.invert().combineWithParent(jInWorld);
            Vector3f saveLocation = b.getPhysicsLocation(null);
            Quaternion saveRotation = b.getPhysicsRotation(null);
            b.setPhysicsLocation(bToWorld.getTranslation());
            b.setPhysicsRotation(bToWorld.getRotation());
            boolean useLinearReferenceFrameB = !this.useLinearReferenceFrameA;
            constraintId = this.createJoint1(bId, this.pivotB, this.rotB, useLinearReferenceFrameB);
            b.setPhysicsLocation(saveLocation);
            b.setPhysicsRotation(saveRotation);
        } else {
            long aId = a.nativeId();
            constraintId = this.createJoint(aId, bId, this.pivotA, this.rotA, this.pivotB, this.rotB, this.useLinearReferenceFrameA);
        }
        int constraintType = SixDofJoint.getConstraintType(constraintId);
        assert (constraintType == 6 || constraintType == 9);
        this.setNativeId(constraintId);
        this.gatherMotors();
    }

    private void gatherMotors() {
        assert (this.rotationalMotors == null);
        assert (this.translationalMotor == null);
        long constraintId = this.nativeId();
        this.rotationalMotors = new RotationalLimitMotor[3];
        for (int axisIndex = 0; axisIndex < 3; ++axisIndex) {
            long motorId = SixDofJoint.getRotationalLimitMotor(constraintId, axisIndex);
            this.rotationalMotors[axisIndex] = new RotationalLimitMotor(motorId);
        }
        long motorId = SixDofJoint.getTranslationalLimitMotor(constraintId);
        this.translationalMotor = new TranslationalLimitMotor(motorId);
    }

    private static native void getAngles(long var0, Vector3f var2);

    private static native void getFrameOffsetA(long var0, Transform var2);

    private static native void getFrameOffsetB(long var0, Transform var2);

    private static native void getPivotOffset(long var0, Vector3f var2);

    private static native long getRotationalLimitMotor(long var0, int var2);

    private static native long getTranslationalLimitMotor(long var0);

    private static native void setAngularLowerLimit(long var0, Vector3f var2);

    private static native void setAngularUpperLimit(long var0, Vector3f var2);

    private static native void setLinearLowerLimit(long var0, Vector3f var2);

    private static native void setLinearUpperLimit(long var0, Vector3f var2);
}

