/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.joints;

import com.jme3.bullet.joints.JointEnd;
import com.jme3.bullet.joints.SixDofJoint;
import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Matrix3f;
import com.jme3.math.Vector3f;
import com.jme3.util.clone.Cloner;
import java.io.IOException;
import java.util.logging.Logger;
import jme3utilities.Validate;

public class SixDofSpringJoint
extends SixDofJoint {
    public static final Logger logger3 = Logger.getLogger(SixDofSpringJoint.class.getName());
    private static final String tagDof = "Dof";
    private static final String tagSpringDamping = "_SpringDamping";
    private static final String tagStiffness = "_Stiffness";

    protected SixDofSpringJoint() {
    }

    public SixDofSpringJoint(PhysicsRigidBody rigidBodyB, Vector3f pivotInB, Vector3f pivotInWorld, Matrix3f rotInB, Matrix3f rotInWorld, JointEnd linearReferenceFrame) {
        super(rigidBodyB, pivotInB, pivotInWorld, rotInB, rotInWorld, linearReferenceFrame);
    }

    public SixDofSpringJoint(PhysicsRigidBody rigidBodyA, PhysicsRigidBody rigidBodyB, Vector3f pivotInA, Vector3f pivotInB, Matrix3f rotInA, Matrix3f rotInB, boolean useLinearReferenceFrameA) {
        super(rigidBodyA, rigidBodyB, pivotInA, pivotInB, rotInA, rotInB, useLinearReferenceFrameA);
    }

    public void enableSpring(int dofIndex, boolean onOff) {
        Validate.inRange((int)dofIndex, (String)"DOF index", (int)0, (int)5);
        long constraintId = this.nativeId();
        SixDofSpringJoint.enableSpring(constraintId, dofIndex, onOff);
    }

    public float getDamping(int dofIndex) {
        Validate.inRange((int)dofIndex, (String)"DOF index", (int)0, (int)5);
        long constraintId = this.nativeId();
        float result = SixDofSpringJoint.getDamping(constraintId, dofIndex);
        return result;
    }

    public float getEquilibriumPoint(int dofIndex) {
        Validate.inRange((int)dofIndex, (String)"DOF index", (int)0, (int)5);
        long constraintId = this.nativeId();
        float result = SixDofSpringJoint.getEquilibriumPoint(constraintId, dofIndex);
        return result;
    }

    public float getStiffness(int dofIndex) {
        Validate.inRange((int)dofIndex, (String)"DOF index", (int)0, (int)5);
        long constraintId = this.nativeId();
        float result = SixDofSpringJoint.getStiffness(constraintId, dofIndex);
        return result;
    }

    public boolean isSpringEnabled(int dofIndex) {
        Validate.inRange((int)dofIndex, (String)"DOF index", (int)0, (int)5);
        long constraintId = this.nativeId();
        boolean result = SixDofSpringJoint.isSpringEnabled(constraintId, dofIndex);
        return result;
    }

    public void setDamping(int dofIndex, float damping) {
        Validate.inRange((int)dofIndex, (String)"DOF index", (int)0, (int)5);
        long constraintId = this.nativeId();
        SixDofSpringJoint.setDamping(constraintId, dofIndex, damping);
    }

    public void setEquilibriumPoint() {
        long constraintId = this.nativeId();
        SixDofSpringJoint.setEquilibriumPoint(constraintId);
    }

    public void setEquilibriumPoint(int dofIndex) {
        Validate.inRange((int)dofIndex, (String)"DOF index", (int)0, (int)5);
        long constraintId = this.nativeId();
        SixDofSpringJoint.setEquilibriumPoint(constraintId, dofIndex);
    }

    public void setStiffness(int dofIndex, float stiffness) {
        Validate.inRange((int)dofIndex, (String)"DOF index", (int)0, (int)5);
        long constraintId = this.nativeId();
        SixDofSpringJoint.setStiffness(constraintId, dofIndex, stiffness);
    }

    @Override
    protected native long createJoint(long var1, long var3, Vector3f var5, Matrix3f var6, Vector3f var7, Matrix3f var8, boolean var9);

    @Override
    protected native long createJoint1(long var1, Vector3f var3, Matrix3f var4, boolean var5);

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        super.cloneFields(cloner, original);
        SixDofSpringJoint old = (SixDofSpringJoint)original;
        for (int dofIndex = 0; dofIndex < 6; ++dofIndex) {
            this.setDamping(dofIndex, old.getDamping(dofIndex));
            this.setStiffness(dofIndex, old.getStiffness(dofIndex));
        }
    }

    @Override
    public void read(JmeImporter importer) throws IOException {
        super.read(importer);
        InputCapsule capsule = importer.getCapsule((Savable)this);
        for (int dofIndex = 0; dofIndex < 6; ++dofIndex) {
            String dofTag = tagDof + dofIndex;
            this.setDamping(dofIndex, capsule.readFloat(dofTag + tagSpringDamping, 1.0f));
            this.setStiffness(dofIndex, capsule.readFloat(dofTag + tagStiffness, 0.0f));
        }
    }

    @Override
    public void write(JmeExporter exporter) throws IOException {
        super.write(exporter);
        OutputCapsule capsule = exporter.getCapsule((Savable)this);
        for (int dofIndex = 0; dofIndex < 6; ++dofIndex) {
            String dofTag = tagDof + dofIndex;
            capsule.write(this.getDamping(dofIndex), dofTag + tagSpringDamping, 1.0f);
            capsule.write(this.getStiffness(dofIndex), dofTag + tagStiffness, 0.0f);
        }
    }

    private static native void enableSpring(long var0, int var2, boolean var3);

    private static native float getDamping(long var0, int var2);

    private static native float getEquilibriumPoint(long var0, int var2);

    private static native float getStiffness(long var0, int var2);

    private static native boolean isSpringEnabled(long var0, int var2);

    private static native void setDamping(long var0, int var2, float var3);

    private static native void setEquilibriumPoint(long var0);

    private static native void setEquilibriumPoint(long var0, int var2);

    private static native void setStiffness(long var0, int var2, float var3);
}

