/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.joints;

import com.jme3.bullet.joints.Constraint;
import com.jme3.bullet.joints.JointEnd;
import com.jme3.bullet.objects.PhysicsBody;
import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Matrix3f;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.util.clone.Cloner;
import java.io.IOException;
import java.util.logging.Logger;

public class SliderJoint
extends Constraint {
    public static final Logger logger2 = Logger.getLogger(SliderJoint.class.getName());
    private static final String tagDampingDirAng = "dampingDirAng";
    private static final String tagDampingDirLin = "dampingDirLin";
    private static final String tagDampingLimAng = "dampingLimAng";
    private static final String tagDampingLimLin = "dampingLimLin";
    private static final String tagDampingOrthoAng = "dampingOrthoAng";
    private static final String tagDampingOrthoLin = "dampingOrthoLin";
    private static final String tagLowerAngLimit = "lowerAngLimit";
    private static final String tagLowerLinLimit = "lowerLinLimit";
    private static final String tagMaxAngMotorForce = "maxAngMotorForce";
    private static final String tagMaxLinMotorForce = "maxLinMotorForce";
    private static final String tagPoweredAngMotor = "poweredAngMotor";
    private static final String tagPoweredLinMotor = "poweredLinMotor";
    private static final String tagRestitutionDirAng = "restitutionDirAng";
    private static final String tagRestitutionDirLin = "restitutionDirLin";
    private static final String tagRestitutionLimAng = "restitutionLimAng";
    private static final String tagRestitutionLimLin = "restitutionLimLin";
    private static final String tagRestitutionOrthoAng = "restitutionOrthoAng";
    private static final String tagRestitutionOrthoLin = "restitutionOrthoLin";
    private static final String tagRotA = "rotA";
    private static final String tagRotB = "rotB";
    private static final String tagSoftnessDirAng = "softnessDirAng";
    private static final String tagSoftnessDirLin = "softnessDirLin";
    private static final String tagSoftnessLimAng = "softnessLimAng";
    private static final String tagSoftnessLimLin = "softnessLimLin";
    private static final String tagSoftnessOrthoAng = "softnessOrthoAng";
    private static final String tagSoftnessOrthoLin = "softnessOrthoLin";
    private static final String tagTargetAngMotorVelocity = "targetAngMotorVelocity";
    private static final String tagTargetLinMotorVelocity = "targetLinMotorVelocity";
    private static final String tagUpperAngLimit = "upperAngLimit";
    private static final String tagUpperLinLimit = "upperLinLimit";
    private static final String tagUseLinearReferenceFrameA = "useLinearReferenceFrameA";
    private boolean useLinearReferenceFrameA;
    private Matrix3f rotA;
    private Matrix3f rotB;

    protected SliderJoint() {
    }

    public SliderJoint(PhysicsRigidBody rigidBodyB, Vector3f pivotInB, Vector3f pivotInWorld, JointEnd linearReferenceFrame) {
        super(rigidBodyB, JointEnd.B, pivotInB, pivotInWorld);
        this.rotA = new Matrix3f();
        this.rotB = new Matrix3f();
        this.useLinearReferenceFrameA = linearReferenceFrame == JointEnd.A;
        this.createJoint();
    }

    public SliderJoint(PhysicsRigidBody rigidBodyA, PhysicsRigidBody rigidBodyB, Vector3f pivotInA, Vector3f pivotInB, Matrix3f rotInA, Matrix3f rotInB, boolean useLinearReferenceFrameA) {
        super((PhysicsBody)rigidBodyA, rigidBodyB, pivotInA, pivotInB);
        this.useLinearReferenceFrameA = useLinearReferenceFrameA;
        this.rotA = rotInA.clone();
        this.rotB = rotInB.clone();
        this.createJoint();
    }

    public SliderJoint(PhysicsRigidBody rigidBodyA, PhysicsRigidBody rigidBodyB, Vector3f pivotInA, Vector3f pivotInB, boolean useLinearReferenceFrameA) {
        super((PhysicsBody)rigidBodyA, rigidBodyB, pivotInA, pivotInB);
        this.useLinearReferenceFrameA = useLinearReferenceFrameA;
        this.rotA = new Matrix3f();
        this.rotB = new Matrix3f();
        this.createJoint();
    }

    public float getDampingDirAng() {
        long constraintId = this.nativeId();
        return SliderJoint.getDampingDirAng(constraintId);
    }

    public float getDampingDirLin() {
        long constraintId = this.nativeId();
        return SliderJoint.getDampingDirLin(constraintId);
    }

    public float getDampingLimAng() {
        long constraintId = this.nativeId();
        return SliderJoint.getDampingLimAng(constraintId);
    }

    public float getDampingLimLin() {
        long constraintId = this.nativeId();
        return SliderJoint.getDampingLimLin(constraintId);
    }

    public float getDampingOrthoAng() {
        long constraintId = this.nativeId();
        return SliderJoint.getDampingOrthoAng(constraintId);
    }

    public float getDampingOrthoLin() {
        long constraintId = this.nativeId();
        return SliderJoint.getDampingOrthoLin(constraintId);
    }

    public Transform getFrameTransform(JointEnd end, Transform storeResult) {
        Transform result = storeResult == null ? new Transform() : storeResult;
        long constraintId = this.nativeId();
        switch (end) {
            case A: {
                SliderJoint.getFrameOffsetA(constraintId, result);
                break;
            }
            case B: {
                SliderJoint.getFrameOffsetB(constraintId, result);
                break;
            }
            default: {
                String message = "end = " + (Object)((Object)end);
                throw new IllegalArgumentException(message);
            }
        }
        return result;
    }

    public float getLowerAngLimit() {
        long constraintId = this.nativeId();
        return SliderJoint.getLowerAngLimit(constraintId);
    }

    public float getLowerLinLimit() {
        long constraintId = this.nativeId();
        return SliderJoint.getLowerLinLimit(constraintId);
    }

    public float getMaxAngMotorForce() {
        long constraintId = this.nativeId();
        return SliderJoint.getMaxAngMotorForce(constraintId);
    }

    public float getMaxLinMotorForce() {
        long constraintId = this.nativeId();
        return SliderJoint.getMaxLinMotorForce(constraintId);
    }

    public float getRestitutionDirAng() {
        long constraintId = this.nativeId();
        return SliderJoint.getRestitutionDirAng(constraintId);
    }

    public float getRestitutionDirLin() {
        long constraintId = this.nativeId();
        return SliderJoint.getRestitutionDirLin(constraintId);
    }

    public float getRestitutionLimAng() {
        long constraintId = this.nativeId();
        return SliderJoint.getRestitutionLimAng(constraintId);
    }

    public float getRestitutionLimLin() {
        long constraintId = this.nativeId();
        return SliderJoint.getRestitutionLimLin(constraintId);
    }

    public float getRestitutionOrthoAng() {
        long constraintId = this.nativeId();
        return SliderJoint.getRestitutionOrthoAng(constraintId);
    }

    public float getRestitutionOrthoLin() {
        long constraintId = this.nativeId();
        return SliderJoint.getRestitutionOrthoLin(constraintId);
    }

    public float getSoftnessDirAng() {
        long constraintId = this.nativeId();
        return SliderJoint.getSoftnessDirAng(constraintId);
    }

    public float getSoftnessDirLin() {
        long constraintId = this.nativeId();
        return SliderJoint.getSoftnessDirLin(constraintId);
    }

    public float getSoftnessLimAng() {
        long constraintId = this.nativeId();
        return SliderJoint.getSoftnessLimAng(constraintId);
    }

    public float getSoftnessLimLin() {
        long constraintId = this.nativeId();
        return SliderJoint.getSoftnessLimLin(constraintId);
    }

    public float getSoftnessOrthoAng() {
        long constraintId = this.nativeId();
        return SliderJoint.getSoftnessOrthoAng(constraintId);
    }

    public float getSoftnessOrthoLin() {
        long constraintId = this.nativeId();
        return SliderJoint.getSoftnessOrthoLin(constraintId);
    }

    public float getTargetAngMotorVelocity() {
        long constraintId = this.nativeId();
        return SliderJoint.getTargetAngMotorVelocity(constraintId);
    }

    public float getTargetLinMotorVelocity() {
        long constraintId = this.nativeId();
        return SliderJoint.getTargetLinMotorVelocity(constraintId);
    }

    public float getUpperAngLimit() {
        long constraintId = this.nativeId();
        return SliderJoint.getUpperAngLimit(constraintId);
    }

    public float getUpperLinLimit() {
        long constraintId = this.nativeId();
        return SliderJoint.getUpperLinLimit(constraintId);
    }

    public boolean isPoweredAngMotor() {
        long constraintId = this.nativeId();
        return SliderJoint.isPoweredAngMotor(constraintId);
    }

    public boolean isPoweredLinMotor() {
        long constraintId = this.nativeId();
        return SliderJoint.isPoweredLinMotor(constraintId);
    }

    public void setDampingDirAng(float dampingDirAng) {
        long constraintId = this.nativeId();
        SliderJoint.setDampingDirAng(constraintId, dampingDirAng);
    }

    public void setDampingDirLin(float dampingDirLin) {
        long constraintId = this.nativeId();
        SliderJoint.setDampingDirLin(constraintId, dampingDirLin);
    }

    public void setDampingLimAng(float dampingLimAng) {
        long constraintId = this.nativeId();
        SliderJoint.setDampingLimAng(constraintId, dampingLimAng);
    }

    public void setDampingLimLin(float dampingLimLin) {
        long constraintId = this.nativeId();
        SliderJoint.setDampingLimLin(constraintId, dampingLimLin);
    }

    public void setDampingOrthoAng(float dampingOrthoAng) {
        long constraintId = this.nativeId();
        SliderJoint.setDampingOrthoAng(constraintId, dampingOrthoAng);
    }

    public void setDampingOrthoLin(float dampingOrthoLin) {
        long constraintId = this.nativeId();
        SliderJoint.setDampingOrthoLin(constraintId, dampingOrthoLin);
    }

    public void setLowerAngLimit(float lowerAngLimit) {
        long constraintId = this.nativeId();
        SliderJoint.setLowerAngLimit(constraintId, lowerAngLimit);
    }

    public void setLowerLinLimit(float lowerLinLimit) {
        long constraintId = this.nativeId();
        SliderJoint.setLowerLinLimit(constraintId, lowerLinLimit);
    }

    public void setMaxAngMotorForce(float maxAngMotorForce) {
        long constraintId = this.nativeId();
        SliderJoint.setMaxAngMotorForce(constraintId, maxAngMotorForce);
    }

    public void setMaxLinMotorForce(float maxLinMotorForce) {
        long constraintId = this.nativeId();
        SliderJoint.setMaxLinMotorForce(constraintId, maxLinMotorForce);
    }

    public void setPoweredAngMotor(boolean poweredAngMotor) {
        long constraintId = this.nativeId();
        SliderJoint.setPoweredAngMotor(constraintId, poweredAngMotor);
    }

    public void setPoweredLinMotor(boolean poweredLinMotor) {
        long constraintId = this.nativeId();
        SliderJoint.setPoweredLinMotor(constraintId, poweredLinMotor);
    }

    public void setRestitutionDirAng(float restitutionDirAng) {
        long constraintId = this.nativeId();
        SliderJoint.setRestitutionDirAng(constraintId, restitutionDirAng);
    }

    public void setRestitutionDirLin(float restitutionDirLin) {
        long constraintId = this.nativeId();
        SliderJoint.setRestitutionDirLin(constraintId, restitutionDirLin);
    }

    public void setRestitutionLimAng(float restitutionLimAng) {
        long constraintId = this.nativeId();
        SliderJoint.setRestitutionLimAng(constraintId, restitutionLimAng);
    }

    public void setRestitutionLimLin(float restitutionLimLin) {
        long constraintId = this.nativeId();
        SliderJoint.setRestitutionLimLin(constraintId, restitutionLimLin);
    }

    public void setRestitutionOrthoAng(float restitutionOrthoAng) {
        long constraintId = this.nativeId();
        SliderJoint.setRestitutionOrthoAng(constraintId, restitutionOrthoAng);
    }

    public void setRestitutionOrthoLin(float restitutionOrthoLin) {
        long constraintId = this.nativeId();
        SliderJoint.setRestitutionOrthoLin(constraintId, restitutionOrthoLin);
    }

    public void setSoftnessDirAng(float softnessDirAng) {
        long constraintId = this.nativeId();
        SliderJoint.setSoftnessDirAng(constraintId, softnessDirAng);
    }

    public void setSoftnessDirLin(float softnessDirLin) {
        long constraintId = this.nativeId();
        SliderJoint.setSoftnessDirLin(constraintId, softnessDirLin);
    }

    public void setSoftnessLimAng(float softnessLimAng) {
        long constraintId = this.nativeId();
        SliderJoint.setSoftnessLimAng(constraintId, softnessLimAng);
    }

    public void setSoftnessLimLin(float softnessLimLin) {
        long constraintId = this.nativeId();
        SliderJoint.setSoftnessLimLin(constraintId, softnessLimLin);
    }

    public void setSoftnessOrthoAng(float softnessOrthoAng) {
        long constraintId = this.nativeId();
        SliderJoint.setSoftnessOrthoAng(constraintId, softnessOrthoAng);
    }

    public void setSoftnessOrthoLin(float softnessOrthoLin) {
        long constraintId = this.nativeId();
        SliderJoint.setSoftnessOrthoLin(constraintId, softnessOrthoLin);
    }

    public void setTargetAngMotorVelocity(float targetAngMotorVelocity) {
        long constraintId = this.nativeId();
        SliderJoint.setTargetAngMotorVelocity(constraintId, targetAngMotorVelocity);
    }

    public void setTargetLinMotorVelocity(float targetLinMotorVelocity) {
        long constraintId = this.nativeId();
        SliderJoint.setTargetLinMotorVelocity(constraintId, targetLinMotorVelocity);
    }

    public void setUpperAngLimit(float upperAngLimit) {
        long constraintId = this.nativeId();
        SliderJoint.setUpperAngLimit(constraintId, upperAngLimit);
    }

    public void setUpperLinLimit(float upperLinLimit) {
        long constraintId = this.nativeId();
        SliderJoint.setUpperLinLimit(constraintId, upperLinLimit);
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        super.cloneFields(cloner, original);
        this.rotA = (Matrix3f)cloner.clone((Object)this.rotA);
        this.rotB = (Matrix3f)cloner.clone((Object)this.rotB);
        this.createJoint();
        SliderJoint old = (SliderJoint)original;
        float bit = old.getBreakingImpulseThreshold();
        this.setBreakingImpulseThreshold(bit);
        boolean enableJoint = old.isEnabled();
        this.setEnabled(enableJoint);
        int numIterations = old.getOverrideIterations();
        this.overrideIterations(numIterations);
        this.setDampingDirAng(old.getDampingDirAng());
        this.setDampingDirLin(old.getDampingDirLin());
        this.setDampingLimAng(old.getDampingLimAng());
        this.setDampingLimLin(old.getDampingLimLin());
        this.setDampingOrthoAng(old.getDampingOrthoAng());
        this.setDampingOrthoLin(old.getDampingOrthoLin());
        this.setLowerAngLimit(old.getLowerAngLimit());
        this.setLowerLinLimit(old.getLowerLinLimit());
        this.setMaxAngMotorForce(old.getMaxAngMotorForce());
        this.setMaxLinMotorForce(old.getMaxLinMotorForce());
        this.setPoweredAngMotor(old.isPoweredAngMotor());
        this.setPoweredLinMotor(old.isPoweredLinMotor());
        this.setRestitutionDirAng(old.getRestitutionDirAng());
        this.setRestitutionDirLin(old.getRestitutionDirLin());
        this.setRestitutionLimAng(old.getRestitutionLimAng());
        this.setRestitutionLimLin(old.getRestitutionLimLin());
        this.setRestitutionOrthoAng(old.getRestitutionOrthoAng());
        this.setRestitutionOrthoLin(old.getRestitutionOrthoLin());
        this.setSoftnessDirAng(old.getSoftnessDirAng());
        this.setSoftnessDirLin(old.getSoftnessDirLin());
        this.setSoftnessLimAng(old.getSoftnessLimAng());
        this.setSoftnessLimLin(old.getSoftnessLimLin());
        this.setSoftnessOrthoAng(old.getSoftnessOrthoAng());
        this.setSoftnessOrthoLin(old.getSoftnessOrthoLin());
        this.setTargetAngMotorVelocity(old.getTargetAngMotorVelocity());
        this.setTargetLinMotorVelocity(old.getTargetLinMotorVelocity());
        this.setUpperAngLimit(old.getUpperAngLimit());
        this.setUpperLinLimit(old.getUpperLinLimit());
    }

    @Override
    public SliderJoint jmeClone() {
        try {
            SliderJoint clone = (SliderJoint)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public void read(JmeImporter importer) throws IOException {
        super.read(importer);
        InputCapsule capsule = importer.getCapsule((Savable)this);
        float dampingDirAng = capsule.readFloat(tagDampingDirAng, 0.0f);
        float dampingDirLin = capsule.readFloat(tagDampingDirLin, 0.0f);
        float dampingLimAng = capsule.readFloat(tagDampingLimAng, 1.0f);
        float dampingLimLin = capsule.readFloat(tagDampingLimLin, 1.0f);
        float dampingOrthoAng = capsule.readFloat(tagDampingOrthoAng, 1.0f);
        float dampingOrthoLin = capsule.readFloat(tagDampingOrthoLin, 1.0f);
        float lowerAngLimit = capsule.readFloat(tagLowerAngLimit, 0.0f);
        float lowerLinLimit = capsule.readFloat(tagLowerLinLimit, 1.0f);
        float maxAngMotorForce = capsule.readFloat(tagMaxAngMotorForce, 0.0f);
        float maxLinMotorForce = capsule.readFloat(tagMaxLinMotorForce, 0.0f);
        boolean poweredAngMotor = capsule.readBoolean(tagPoweredAngMotor, false);
        boolean poweredLinMotor = capsule.readBoolean(tagPoweredLinMotor, false);
        float restitutionDirAng = capsule.readFloat(tagRestitutionDirAng, 0.7f);
        float restitutionDirLin = capsule.readFloat(tagRestitutionDirLin, 0.7f);
        float restitutionLimAng = capsule.readFloat(tagRestitutionLimAng, 0.7f);
        float restitutionLimLin = capsule.readFloat(tagRestitutionLimLin, 0.7f);
        float restitutionOrthoAng = capsule.readFloat(tagRestitutionOrthoAng, 0.7f);
        float restitutionOrthoLin = capsule.readFloat(tagRestitutionOrthoLin, 0.7f);
        float softnessDirAng = capsule.readFloat(tagSoftnessDirAng, 1.0f);
        float softnessDirLin = capsule.readFloat(tagSoftnessDirLin, 1.0f);
        float softnessLimAng = capsule.readFloat(tagSoftnessLimAng, 1.0f);
        float softnessLimLin = capsule.readFloat(tagSoftnessLimLin, 1.0f);
        float softnessOrthoAng = capsule.readFloat(tagSoftnessOrthoAng, 1.0f);
        float softnessOrthoLin = capsule.readFloat(tagSoftnessOrthoLin, 1.0f);
        float targetAngMotorVelocity = capsule.readFloat(tagTargetAngMotorVelocity, 0.0f);
        float targetLinMotorVelocity = capsule.readFloat(tagTargetLinMotorVelocity, 0.0f);
        float upperAngLimit = capsule.readFloat(tagUpperAngLimit, 0.0f);
        float upperLinLimit = capsule.readFloat(tagUpperLinLimit, -1.0f);
        this.rotA = (Matrix3f)capsule.readSavable(tagRotA, (Savable)new Matrix3f());
        this.rotB = (Matrix3f)capsule.readSavable(tagRotB, (Savable)new Matrix3f());
        this.useLinearReferenceFrameA = capsule.readBoolean(tagUseLinearReferenceFrameA, false);
        this.createJoint();
        this.readConstraintProperties(capsule);
        this.setDampingDirAng(dampingDirAng);
        this.setDampingDirLin(dampingDirLin);
        this.setDampingLimAng(dampingLimAng);
        this.setDampingLimLin(dampingLimLin);
        this.setDampingOrthoAng(dampingOrthoAng);
        this.setDampingOrthoLin(dampingOrthoLin);
        this.setLowerAngLimit(lowerAngLimit);
        this.setLowerLinLimit(lowerLinLimit);
        this.setMaxAngMotorForce(maxAngMotorForce);
        this.setMaxLinMotorForce(maxLinMotorForce);
        this.setPoweredAngMotor(poweredAngMotor);
        this.setPoweredLinMotor(poweredLinMotor);
        this.setRestitutionDirAng(restitutionDirAng);
        this.setRestitutionDirLin(restitutionDirLin);
        this.setRestitutionLimAng(restitutionLimAng);
        this.setRestitutionLimLin(restitutionLimLin);
        this.setRestitutionOrthoAng(restitutionOrthoAng);
        this.setRestitutionOrthoLin(restitutionOrthoLin);
        this.setSoftnessDirAng(softnessDirAng);
        this.setSoftnessDirLin(softnessDirLin);
        this.setSoftnessLimAng(softnessLimAng);
        this.setSoftnessLimLin(softnessLimLin);
        this.setSoftnessOrthoAng(softnessOrthoAng);
        this.setSoftnessOrthoLin(softnessOrthoLin);
        this.setTargetAngMotorVelocity(targetAngMotorVelocity);
        this.setTargetLinMotorVelocity(targetLinMotorVelocity);
        this.setUpperAngLimit(upperAngLimit);
        this.setUpperLinLimit(upperLinLimit);
    }

    @Override
    public void write(JmeExporter exporter) throws IOException {
        super.write(exporter);
        OutputCapsule capsule = exporter.getCapsule((Savable)this);
        capsule.write(this.getDampingDirAng(), tagDampingDirAng, 0.0f);
        capsule.write(this.getDampingDirLin(), tagDampingDirLin, 0.0f);
        capsule.write(this.getDampingLimAng(), tagDampingLimAng, 1.0f);
        capsule.write(this.getDampingLimLin(), tagDampingLimLin, 1.0f);
        capsule.write(this.getDampingOrthoAng(), tagDampingOrthoAng, 1.0f);
        capsule.write(this.getDampingOrthoLin(), tagDampingOrthoLin, 1.0f);
        capsule.write(this.getLowerAngLimit(), tagLowerAngLimit, 0.0f);
        capsule.write(this.getLowerLinLimit(), tagLowerLinLimit, 1.0f);
        capsule.write(this.getMaxAngMotorForce(), tagMaxAngMotorForce, 0.0f);
        capsule.write(this.getMaxLinMotorForce(), tagMaxLinMotorForce, 0.0f);
        capsule.write(this.isPoweredAngMotor(), tagPoweredAngMotor, false);
        capsule.write(this.isPoweredLinMotor(), tagPoweredLinMotor, false);
        capsule.write(this.getRestitutionDirAng(), tagRestitutionDirAng, 0.7f);
        capsule.write(this.getRestitutionDirLin(), tagRestitutionDirLin, 0.7f);
        capsule.write(this.getRestitutionLimAng(), tagRestitutionLimAng, 0.7f);
        capsule.write(this.getRestitutionLimLin(), tagRestitutionLimLin, 0.7f);
        capsule.write(this.getRestitutionOrthoAng(), tagRestitutionOrthoAng, 0.7f);
        capsule.write(this.getRestitutionOrthoLin(), tagRestitutionOrthoLin, 0.7f);
        capsule.write(this.getSoftnessDirAng(), tagSoftnessDirAng, 1.0f);
        capsule.write(this.getSoftnessDirLin(), tagSoftnessDirLin, 1.0f);
        capsule.write(this.getSoftnessLimAng(), tagSoftnessLimAng, 1.0f);
        capsule.write(this.getSoftnessLimLin(), tagSoftnessLimLin, 1.0f);
        capsule.write(this.getSoftnessOrthoAng(), tagSoftnessOrthoAng, 1.0f);
        capsule.write(this.getSoftnessOrthoLin(), tagSoftnessOrthoLin, 1.0f);
        capsule.write(this.getTargetAngMotorVelocity(), tagTargetAngMotorVelocity, 0.0f);
        capsule.write(this.getTargetLinMotorVelocity(), tagTargetLinMotorVelocity, 0.0f);
        capsule.write(this.getUpperAngLimit(), tagUpperAngLimit, 0.0f);
        capsule.write(this.getUpperLinLimit(), tagUpperLinLimit, -1.0f);
        capsule.write(this.useLinearReferenceFrameA, tagUseLinearReferenceFrameA, false);
    }

    private void createJoint() {
        long constraintId;
        PhysicsRigidBody a = this.getBodyA();
        assert (this.pivotA != null);
        assert (this.rotA != null);
        PhysicsRigidBody b = this.getBodyB();
        long bId = b.nativeId();
        assert (this.pivotB != null);
        assert (this.rotB != null);
        if (a == null) {
            Vector3f saveLocation = b.getPhysicsLocation(null);
            Vector3f offset = this.pivotA.subtract(this.pivotB);
            b.setPhysicsLocation(offset);
            constraintId = SliderJoint.createJoint1(bId, this.pivotB, this.rotB, this.useLinearReferenceFrameA);
            b.setPhysicsLocation(saveLocation);
        } else {
            long aId = a.nativeId();
            constraintId = SliderJoint.createJoint(aId, bId, this.pivotA, this.rotA, this.pivotB, this.rotB, this.useLinearReferenceFrameA);
        }
        assert (SliderJoint.getConstraintType(constraintId) == 7);
        this.setNativeId(constraintId);
    }

    private static native long createJoint(long var0, long var2, Vector3f var4, Matrix3f var5, Vector3f var6, Matrix3f var7, boolean var8);

    private static native long createJoint1(long var0, Vector3f var2, Matrix3f var3, boolean var4);

    private static native float getDampingDirAng(long var0);

    private static native float getDampingDirLin(long var0);

    private static native float getDampingLimAng(long var0);

    private static native float getDampingLimLin(long var0);

    private static native float getDampingOrthoAng(long var0);

    private static native float getDampingOrthoLin(long var0);

    private static native void getFrameOffsetA(long var0, Transform var2);

    private static native void getFrameOffsetB(long var0, Transform var2);

    private static native float getLowerAngLimit(long var0);

    private static native float getLowerLinLimit(long var0);

    private static native float getMaxAngMotorForce(long var0);

    private static native float getMaxLinMotorForce(long var0);

    private static native float getRestitutionDirAng(long var0);

    private static native float getRestitutionDirLin(long var0);

    private static native float getRestitutionLimAng(long var0);

    private static native float getRestitutionLimLin(long var0);

    private static native float getRestitutionOrthoAng(long var0);

    private static native float getRestitutionOrthoLin(long var0);

    private static native float getSoftnessDirAng(long var0);

    private static native float getSoftnessDirLin(long var0);

    private static native float getSoftnessLimAng(long var0);

    private static native float getSoftnessLimLin(long var0);

    private static native float getSoftnessOrthoAng(long var0);

    private static native float getSoftnessOrthoLin(long var0);

    private static native float getTargetAngMotorVelocity(long var0);

    private static native float getTargetLinMotorVelocity(long var0);

    private static native float getUpperAngLimit(long var0);

    private static native float getUpperLinLimit(long var0);

    private static native boolean isPoweredAngMotor(long var0);

    private static native boolean isPoweredLinMotor(long var0);

    private static native void setDampingDirAng(long var0, float var2);

    private static native void setDampingDirLin(long var0, float var2);

    private static native void setDampingLimAng(long var0, float var2);

    private static native void setDampingLimLin(long var0, float var2);

    private static native void setDampingOrthoAng(long var0, float var2);

    private static native void setDampingOrthoLin(long var0, float var2);

    private static native void setLowerAngLimit(long var0, float var2);

    private static native void setLowerLinLimit(long var0, float var2);

    private static native void setMaxAngMotorForce(long var0, float var2);

    private static native void setMaxLinMotorForce(long var0, float var2);

    private static native void setPoweredAngMotor(long var0, boolean var2);

    private static native void setPoweredLinMotor(long var0, boolean var2);

    private static native void setRestitutionDirAng(long var0, float var2);

    private static native void setRestitutionDirLin(long var0, float var2);

    private static native void setRestitutionLimAng(long var0, float var2);

    private static native void setRestitutionLimLin(long var0, float var2);

    private static native void setRestitutionOrthoAng(long var0, float var2);

    private static native void setRestitutionOrthoLin(long var0, float var2);

    private static native void setSoftnessDirAng(long var0, float var2);

    private static native void setSoftnessDirLin(long var0, float var2);

    private static native void setSoftnessLimAng(long var0, float var2);

    private static native void setSoftnessLimLin(long var0, float var2);

    private static native void setSoftnessOrthoAng(long var0, float var2);

    private static native void setSoftnessOrthoLin(long var0, float var2);

    private static native void setTargetAngMotorVelocity(long var0, float var2);

    private static native void setTargetLinMotorVelocity(long var0, float var2);

    private static native void setUpperAngLimit(long var0, float var2);

    private static native void setUpperLinLimit(long var0, float var2);
}

