/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.joints;

import com.jme3.bullet.joints.SoftPhysicsJoint;
import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.bullet.objects.PhysicsSoftBody;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Vector3f;
import com.jme3.util.clone.Cloner;
import java.io.IOException;
import java.util.logging.Logger;
import jme3utilities.Validate;

public class SoftLinearJoint
extends SoftPhysicsJoint {
    public static final Logger logger3 = Logger.getLogger(SoftLinearJoint.class.getName());
    private static final String tagLocation = "location";
    private Vector3f location;

    protected SoftLinearJoint() {
    }

    public SoftLinearJoint(Vector3f location, PhysicsSoftBody softA, int clusterIndexA, PhysicsRigidBody rigidB) {
        super(softA, clusterIndexA, rigidB);
        Validate.finite((Vector3f)location, (String)tagLocation);
        this.location = location.clone();
        this.createJoint();
    }

    public SoftLinearJoint(Vector3f location, PhysicsSoftBody softA, int clusterIndexA, PhysicsSoftBody softB, int clusterIndexB) {
        super(softA, clusterIndexA, softB, clusterIndexB);
        Validate.finite((Vector3f)location, (String)tagLocation);
        this.location = location.clone();
        this.createJoint();
    }

    public Vector3f copyLocation(Vector3f storeResult) {
        if (storeResult == null) {
            return this.location.clone();
        }
        return storeResult.set(this.location);
    }

    public void setLocation(Vector3f newLocation) {
        long jointId = this.nativeId();
        this.location.set(newLocation);
        SoftLinearJoint.setPosition(jointId, newLocation);
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        super.cloneFields(cloner, original);
        this.location = (Vector3f)cloner.clone((Object)this.location);
        this.createJoint();
        SoftLinearJoint originalJoint = (SoftLinearJoint)original;
        this.setCFM(originalJoint.getCFM());
        this.setERP(originalJoint.getERP());
        this.setSplit(originalJoint.getSplit());
    }

    @Override
    public SoftLinearJoint jmeClone() {
        try {
            SoftLinearJoint clone = (SoftLinearJoint)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public void read(JmeImporter importer) throws IOException {
        super.read(importer);
        InputCapsule capsule = importer.getCapsule((Savable)this);
        this.location = (Vector3f)capsule.readSavable(tagLocation, (Savable)new Vector3f());
        this.createJoint();
    }

    @Override
    public void write(JmeExporter exporter) throws IOException {
        super.write(exporter);
        OutputCapsule capsule = exporter.getCapsule((Savable)this);
        capsule.write((Savable)this.location, tagLocation, null);
    }

    private void createJoint() {
        long jointId;
        PhysicsSoftBody a = this.getSoftBodyA();
        long ida = a.nativeId();
        int cia = this.clusterIndexA();
        assert (cia >= 0) : cia;
        assert (cia < a.countClusters()) : cia;
        long idb = this.getBodyB().nativeId();
        int cib = this.clusterIndexB();
        float erp = this.getERP();
        float cfm = this.getCFM();
        float split = this.getSplit();
        if (this.isSoftRigid()) {
            assert (cib == -1) : cib;
            jointId = SoftLinearJoint.createJointSoftRigid(ida, cia, idb, erp, cfm, split, this.location);
        } else {
            PhysicsSoftBody b = this.getSoftBodyB();
            assert (cib >= 0) : cib;
            assert (cib < b.countClusters()) : cib;
            jointId = SoftLinearJoint.createJointSoftSoft(ida, cia, idb, cib, erp, cfm, split, this.location);
        }
        this.setNativeIdNotTracked(jointId);
        assert (this.checkParameters());
    }

    private static native long createJointSoftRigid(long var0, int var2, long var3, float var5, float var6, float var7, Vector3f var8);

    private static native long createJointSoftSoft(long var0, int var2, long var3, int var5, float var6, float var7, float var8, Vector3f var9);

    private static native void setPosition(long var0, Vector3f var2);
}

