/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.joints.motors;

import com.jme3.bullet.NativePhysicsObject;
import com.jme3.math.Vector3f;
import java.util.logging.Logger;
import jme3utilities.Validate;

public class TranslationalLimitMotor
extends NativePhysicsObject {
    public static final Logger logger = Logger.getLogger(TranslationalLimitMotor.class.getName());

    public TranslationalLimitMotor(long nativeId) {
        Validate.nonZero((long)nativeId, (String)"native ID");
        super.setNativeIdNotTracked(nativeId);
    }

    public Vector3f getAccumulatedImpulse(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long motorId = this.nativeId();
        TranslationalLimitMotor.getAccumulatedImpulse(motorId, result);
        return result;
    }

    public float getDamping() {
        long motorId = this.nativeId();
        float result = TranslationalLimitMotor.getDamping(motorId);
        return result;
    }

    public Vector3f getERP(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long motorId = this.nativeId();
        TranslationalLimitMotor.getERP(motorId, result);
        return result;
    }

    public float getLimitSoftness() {
        long motorId = this.nativeId();
        float result = TranslationalLimitMotor.getLimitSoftness(motorId);
        return result;
    }

    public Vector3f getLowerLimit(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long motorId = this.nativeId();
        TranslationalLimitMotor.getLowerLimit(motorId, result);
        return result;
    }

    public Vector3f getMaxMotorForce(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long motorId = this.nativeId();
        TranslationalLimitMotor.getMaxMotorForce(motorId, result);
        return result;
    }

    public long getMotor() {
        long motorId = this.nativeId();
        return motorId;
    }

    public Vector3f getNormalCFM(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long motorId = this.nativeId();
        TranslationalLimitMotor.getNormalCFM(motorId, result);
        return result;
    }

    public Vector3f getOffset(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long motorId = this.nativeId();
        TranslationalLimitMotor.getOffset(motorId, result);
        return result;
    }

    public float getRestitution() {
        long motorId = this.nativeId();
        float result = TranslationalLimitMotor.getRestitution(motorId);
        return result;
    }

    public Vector3f getStopCFM(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long motorId = this.nativeId();
        TranslationalLimitMotor.getStopCFM(motorId, result);
        return result;
    }

    public Vector3f getTargetVelocity(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long motorId = this.nativeId();
        TranslationalLimitMotor.getTargetVelocity(motorId, result);
        return result;
    }

    public Vector3f getUpperLimit(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long motorId = this.nativeId();
        TranslationalLimitMotor.getUpperLimit(motorId, result);
        return result;
    }

    public boolean isEnabled(int axisIndex) {
        Validate.axisIndex((int)axisIndex, (String)"axis index");
        long motorId = this.nativeId();
        boolean result = TranslationalLimitMotor.isEnabled(motorId, axisIndex);
        return result;
    }

    public void setAccumulatedImpulse(Vector3f accumulatedImpulse) {
        long motorId = this.nativeId();
        TranslationalLimitMotor.setAccumulatedImpulse(motorId, accumulatedImpulse);
    }

    public void setDamping(float damping) {
        long motorId = this.nativeId();
        TranslationalLimitMotor.setDamping(motorId, damping);
    }

    public void setEnabled(int axisIndex, boolean enableMotor) {
        Validate.axisIndex((int)axisIndex, (String)"axis index");
        long motorId = this.nativeId();
        TranslationalLimitMotor.setEnabled(motorId, axisIndex, enableMotor);
    }

    public void setERP(Vector3f erp) {
        long motorId = this.nativeId();
        TranslationalLimitMotor.setERP(motorId, erp);
    }

    public void setLimitSoftness(float limitSoftness) {
        long motorId = this.nativeId();
        TranslationalLimitMotor.setLimitSoftness(motorId, limitSoftness);
    }

    public void setLowerLimit(Vector3f lowerLimit) {
        long motorId = this.nativeId();
        TranslationalLimitMotor.setLowerLimit(motorId, lowerLimit);
    }

    public void setMaxMotorForce(Vector3f maxForce) {
        long motorId = this.nativeId();
        TranslationalLimitMotor.setMaxMotorForce(motorId, maxForce);
    }

    public void setNormalCFM(Vector3f cfm) {
        long motorId = this.nativeId();
        TranslationalLimitMotor.setNormalCFM(motorId, cfm);
    }

    public void setRestitution(float restitution) {
        long motorId = this.nativeId();
        TranslationalLimitMotor.setRestitution(motorId, restitution);
    }

    public void setStopCFM(Vector3f cfm) {
        long motorId = this.nativeId();
        TranslationalLimitMotor.setStopCFM(motorId, cfm);
    }

    public void setTargetVelocity(Vector3f velocity) {
        long motorId = this.nativeId();
        TranslationalLimitMotor.setTargetVelocity(motorId, velocity);
    }

    public void setUpperLimit(Vector3f upperLimit) {
        long motorId = this.nativeId();
        TranslationalLimitMotor.setUpperLimit(motorId, upperLimit);
    }

    private static native void getAccumulatedImpulse(long var0, Vector3f var2);

    private static native float getDamping(long var0);

    private static native void getERP(long var0, Vector3f var2);

    private static native float getLimitSoftness(long var0);

    private static native void getLowerLimit(long var0, Vector3f var2);

    private static native void getMaxMotorForce(long var0, Vector3f var2);

    private static native void getNormalCFM(long var0, Vector3f var2);

    private static native void getOffset(long var0, Vector3f var2);

    private static native float getRestitution(long var0);

    private static native void getStopCFM(long var0, Vector3f var2);

    private static native void getTargetVelocity(long var0, Vector3f var2);

    private static native void getUpperLimit(long var0, Vector3f var2);

    private static native boolean isEnabled(long var0, int var2);

    private static native void setAccumulatedImpulse(long var0, Vector3f var2);

    private static native void setDamping(long var0, float var2);

    private static native void setEnabled(long var0, int var2, boolean var3);

    private static native void setERP(long var0, Vector3f var2);

    private static native void setLimitSoftness(long var0, float var2);

    private static native void setLowerLimit(long var0, Vector3f var2);

    private static native void setMaxMotorForce(long var0, Vector3f var2);

    private static native void setNormalCFM(long var0, Vector3f var2);

    private static native void setRestitution(long var0, float var2);

    private static native void setStopCFM(long var0, Vector3f var2);

    private static native void setTargetVelocity(long var0, Vector3f var2);

    private static native void setUpperLimit(long var0, Vector3f var2);
}

