/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.objects;

import com.jme3.bullet.MultiBody;
import com.jme3.bullet.collision.PhysicsCollisionObject;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Matrix3f;
import com.jme3.math.Vector3f;
import com.jme3.util.clone.Cloner;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jme3utilities.Validate;

public class MultiBodyCollider
extends PhysicsCollisionObject {
    public static final Logger logger2 = Logger.getLogger(MultiBodyCollider.class.getName());
    private static final String tagMultiBody = "multiBody";
    private static final String tagPhysicsLocation = "physicsLocation";
    private static final String tagPhysicsRotation = "physicsRotation";
    private int linkIndex;
    private MultiBody multiBody;

    protected MultiBodyCollider() {
    }

    public MultiBodyCollider(MultiBody multiBody, int linkIndex) {
        Validate.nonNull((Object)multiBody, (String)"multibody");
        Validate.inRange((int)linkIndex, (String)"link index", (int)-1, (int)Integer.MAX_VALUE);
        this.multiBody = multiBody;
        this.linkIndex = linkIndex;
        assert (!this.hasAssignedNativeObject());
        this.buildObject();
    }

    public void attachShape(CollisionShape shape) {
        Validate.nonNull((Object)shape, (String)"shape");
        this.setCollisionShape(shape);
        long objectId = this.nativeId();
        long shapeId = shape.nativeId();
        MultiBodyCollider.attachCollisionShape(objectId, shapeId);
    }

    public MultiBody getMultiBody() {
        assert (this.multiBody != null);
        return this.multiBody;
    }

    public int linkIndex() {
        assert (this.linkIndex >= -1) : this.linkIndex;
        return this.linkIndex;
    }

    public float mass() {
        float result = this.linkIndex >= 0 ? this.multiBody.getLink(this.linkIndex).mass() : this.multiBody.baseMass();
        assert (result > 0.0f) : result;
        return result;
    }

    public void setPhysicsLocation(Vector3f location) {
        long objectId = this.nativeId();
        MultiBodyCollider.setPhysicsLocation(objectId, location);
    }

    public void setPhysicsRotation(Matrix3f rotation) {
        long objectId = this.nativeId();
        MultiBodyCollider.setPhysicsRotation(objectId, rotation);
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        super.cloneFields(cloner, original);
        this.unassignNativeObject();
        this.multiBody = (MultiBody)cloner.clone((Object)this.multiBody);
        this.buildObject();
        MultiBodyCollider old = (MultiBodyCollider)original;
        this.cloneIgnoreList(cloner, old);
        this.copyPcoProperties(old);
        this.setPhysicsLocation(old.getPhysicsLocation(null));
        this.setPhysicsRotation(old.getPhysicsRotationMatrix(null));
    }

    @Override
    public MultiBodyCollider jmeClone() {
        try {
            MultiBodyCollider clone = (MultiBodyCollider)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public void read(JmeImporter importer) throws IOException {
        super.read(importer);
        InputCapsule capsule = importer.getCapsule((Savable)this);
        this.multiBody = (MultiBody)capsule.readSavable(tagMultiBody, null);
        this.buildObject();
        this.readPcoProperties(capsule);
        Vector3f location = (Vector3f)capsule.readSavable(tagPhysicsLocation, (Savable)new Vector3f());
        this.setPhysicsLocation(location);
        Matrix3f rotation = (Matrix3f)capsule.readSavable(tagPhysicsRotation, (Savable)new Matrix3f());
        this.setPhysicsRotation(rotation);
    }

    @Override
    public void write(JmeExporter exporter) throws IOException {
        super.write(exporter);
        OutputCapsule capsule = exporter.getCapsule((Savable)this);
        capsule.write((Savable)this.multiBody, tagMultiBody, null);
        capsule.write((Savable)this.getPhysicsLocation(null), tagPhysicsLocation, null);
        capsule.write((Savable)this.getPhysicsRotationMatrix(null), tagPhysicsRotation, null);
    }

    private void buildObject() {
        long multiBodyId = this.multiBody.nativeId();
        long objectId = MultiBodyCollider.createCollider(multiBodyId, this.linkIndex);
        this.setNativeId(objectId);
        assert (MultiBodyCollider.getInternalType(objectId) == 64) : MultiBodyCollider.getInternalType(objectId);
        logger2.log(Level.FINE, "Created {0}.", this);
        super.initUserPointer();
    }

    private static native long createCollider(long var0, int var2);

    private static native void setPhysicsLocation(long var0, Vector3f var2);

    private static native void setPhysicsRotation(long var0, Matrix3f var2);
}

