/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.objects;

import com.jme3.bullet.collision.PhysicsCollisionObject;
import com.jme3.bullet.joints.PhysicsJoint;
import com.jme3.export.InputCapsule;
import com.jme3.export.OutputCapsule;
import com.jme3.math.Vector3f;
import com.jme3.util.clone.Cloner;
import java.io.IOException;
import java.util.ArrayList;
import jme3utilities.Validate;

public abstract class PhysicsBody
extends PhysicsCollisionObject {
    public static final float massForStatic = 0.0f;
    private static final String tagJoints = "joints";
    private ArrayList<PhysicsJoint> joints = new ArrayList(4);

    public void addJoint(PhysicsJoint joint) {
        Validate.nonNull((Object)joint, (String)"joint");
        if (!this.joints.contains(joint)) {
            this.joints.add(joint);
        }
    }

    protected void cloneJoints(Cloner cloner) {
        this.joints = (ArrayList)cloner.clone(this.joints);
    }

    public int countJoints() {
        int result = this.joints.size();
        return result;
    }

    public static native float getDeactivationDeadline();

    public abstract Vector3f getGravity(Vector3f var1);

    public abstract float getMass();

    public static native boolean isDeactivationEnabled();

    public PhysicsJoint[] listJoints() {
        int numJoints = this.joints.size();
        PhysicsJoint[] result = new PhysicsJoint[numJoints];
        this.joints.toArray(result);
        return result;
    }

    protected void readJoints(InputCapsule capsule) throws IOException {
        this.joints = capsule.readSavableArrayList(tagJoints, null);
    }

    public void removeJoint(PhysicsJoint joint) {
        Validate.nonNull((Object)joint, (String)"joint");
        boolean success = this.joints.remove(joint);
        assert (success);
    }

    public static native void setDeactivationDeadline(float var0);

    public static native void setDeactivationEnabled(boolean var0);

    public abstract void setGravity(Vector3f var1);

    public abstract void setMass(float var1);

    public abstract void setPhysicsLocation(Vector3f var1);

    protected void writeJoints(OutputCapsule capsule) throws IOException {
        capsule.writeSavableArrayList(this.joints, tagJoints, null);
    }
}

