/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.objects;

import com.jme3.bullet.PhysicsSpace;
import com.jme3.bullet.collision.PhysicsCollisionObject;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.collision.shapes.ConvexShape;
import com.jme3.bullet.objects.infos.CharacterController;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Vector3f;
import com.jme3.util.clone.Cloner;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jme3utilities.Validate;

public class PhysicsCharacter
extends PhysicsCollisionObject {
    public static final Logger logger2 = Logger.getLogger(PhysicsCharacter.class.getName());
    private static final String tagContactResponse = "contactResponse";
    private static final String tagController = "controller";
    private static final String tagPhysicsLocation = "physicsLocation";
    private static final Vector3f defaultGravity = new Vector3f(0.0f, -29.4f, 0.0f);
    private static final Vector3f translateIdentity = new Vector3f(0.0f, 0.0f, 0.0f);
    private static final Vector3f unitY = new Vector3f(0.0f, 1.0f, 0.0f);
    private CharacterController controller;
    private static final ThreadLocal<Vector3f> threadTmpVector = new ThreadLocal<Vector3f>(){

        @Override
        protected Vector3f initialValue() {
            return new Vector3f();
        }
    };

    protected PhysicsCharacter() {
    }

    public PhysicsCharacter(ConvexShape shape, float stepHeight) {
        Validate.nonNull((Object)shape, (String)"shape");
        super.setCollisionShape(shape);
        this.buildObject();
        this.setStepHeight(stepHeight);
        this.setGravity(defaultGravity);
        this.setUp(unitY);
        this.warp(translateIdentity);
        assert (this.isContactResponse());
    }

    public float getAngularDamping() {
        float result = this.controller.getAngularDamping();
        return result;
    }

    public Vector3f getAngularVelocity(Vector3f storeResult) {
        Vector3f result = this.controller.getAngularVelocity(storeResult);
        return result;
    }

    public long getControllerId() {
        long result = this.controller.nativeId();
        return result;
    }

    public float getFallSpeed() {
        float result = this.controller.getFallSpeed();
        return result;
    }

    public Vector3f getGravity(Vector3f storeResult) {
        Vector3f result = this.controller.getGravity(storeResult);
        return result;
    }

    public float getJumpSpeed() {
        float result = this.controller.getJumpSpeed();
        return result;
    }

    public float getLinearDamping() {
        float result = this.controller.getLinearDamping();
        return result;
    }

    public Vector3f getLinearVelocity(Vector3f storeResult) {
        Vector3f result = this.controller.getLinearVelocity(storeResult);
        return result;
    }

    public float getMaxPenetrationDepth() {
        float result = this.controller.getMaxPenetrationDepth();
        return result;
    }

    public float getMaxSlope() {
        float result = this.controller.getMaxSlope();
        return result;
    }

    public float getStepHeight() {
        float result = this.controller.getStepHeight();
        return result;
    }

    public Vector3f getUpDirection(Vector3f storeResult) {
        Vector3f result = this.controller.getUpDirection(storeResult);
        return result;
    }

    public Vector3f getWalkDirection(Vector3f storeResult) {
        Vector3f result = this.controller.getWalkDirection(storeResult);
        return result;
    }

    public boolean isUsingGhostSweepTest() {
        boolean result = this.controller.isUsingGhostSweepTest();
        return result;
    }

    public void jump() {
        this.jump(translateIdentity);
    }

    public void jump(Vector3f direction) {
        this.controller.jump(direction);
    }

    public boolean onGround() {
        boolean result = this.controller.onGround();
        return result;
    }

    public void reset(PhysicsSpace space) {
        Validate.nonNull((Object)space, (String)"space");
        assert (space == this.getCollisionSpace());
        this.controller.reset(space);
    }

    public void setAngularDamping(float damping) {
        this.controller.setAngularDamping(damping);
    }

    public void setAngularVelocity(Vector3f angularVelocity) {
        Validate.nonNull((Object)angularVelocity, (String)"angular velocity");
        this.controller.setAngularVelocity(angularVelocity);
    }

    @Override
    public void setCollisionShape(CollisionShape collisionShape) {
        assert (collisionShape.isConvex());
        assert (!this.isInWorld());
        super.setCollisionShape(collisionShape);
        if (this.hasAssignedNativeObject()) {
            long objectId = this.nativeId();
            long shapeId = collisionShape.nativeId();
            PhysicsCharacter.attachCollisionShape(objectId, shapeId);
        } else {
            this.buildObject();
        }
    }

    public void setContactResponse(boolean newState) {
        long objectId = this.nativeId();
        int flags = PhysicsCharacter.getCollisionFlags(objectId);
        flags = newState ? (flags &= 0xFFFFFFFB) : (flags |= 4);
        PhysicsCharacter.setCollisionFlags(objectId, flags);
    }

    public void setFallSpeed(float fallSpeed) {
        this.controller.setFallSpeed(fallSpeed);
    }

    public void setGravity(float downwardAcceleration) {
        Vector3f gVector = threadTmpVector.get();
        this.getUpDirection(gVector);
        gVector.multLocal(-downwardAcceleration);
        this.setGravity(gVector);
    }

    public void setGravity(Vector3f gravity) {
        Validate.nonNull((Object)gravity, (String)"gravity");
        this.controller.setGravity(gravity);
    }

    public void setJumpSpeed(float jumpSpeed) {
        this.controller.setJumpSpeed(jumpSpeed);
    }

    public void setLinearDamping(float damping) {
        this.controller.setLinearDamping(damping);
    }

    public void setLinearVelocity(Vector3f velocity) {
        Validate.nonNull((Object)velocity, (String)"velocity");
        this.controller.setLinearVelocity(velocity);
    }

    public void setMaxPenetrationDepth(float depth) {
        this.controller.setMaxPenetrationDepth(depth);
    }

    public void setMaxSlope(float slopeRadians) {
        Validate.inRange((float)slopeRadians, (String)"slope radians", (float)0.0f, (float)1.5707964f);
        this.controller.setMaxSlope(slopeRadians);
    }

    public void setPhysicsLocation(Vector3f location) {
        Validate.nonNull((Object)location, (String)"location");
        this.controller.warp(location);
    }

    public void setStepHeight(float height) {
        this.controller.setStepHeight(height);
    }

    public void setSweepTest(boolean useGhostSweepTest) {
        this.controller.setSweepTest(useGhostSweepTest);
    }

    public void setUp(Vector3f direction) {
        Validate.nonZero((Vector3f)direction, (String)"direction");
        this.controller.setUp(direction);
    }

    public void setWalkDirection(Vector3f offset) {
        Validate.nonNull((Object)offset, (String)"offset");
        this.controller.setWalkDirection(offset);
    }

    public void warp(Vector3f location) {
        Validate.nonNull((Object)location, (String)"location");
        this.controller.warp(location);
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        super.cloneFields(cloner, original);
        this.unassignNativeObject();
        this.controller = null;
        this.buildObject();
        PhysicsCharacter old = (PhysicsCharacter)original;
        this.cloneIgnoreList(cloner, old);
        this.copyPcoProperties(old);
        this.setContactResponse(old.isContactResponse());
        this.setPhysicsLocation(old.getPhysicsLocation(null));
        this.controller.copyAll(old.controller);
    }

    @Override
    public PhysicsCharacter jmeClone() {
        try {
            PhysicsCharacter clone = (PhysicsCharacter)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public void read(JmeImporter importer) throws IOException {
        super.read(importer);
        InputCapsule capsule = importer.getCapsule((Savable)this);
        this.buildObject();
        this.readPcoProperties(capsule);
        CharacterController tmp = (CharacterController)capsule.readSavable(tagController, null);
        this.controller.copyAll(tmp);
        this.setContactResponse(capsule.readBoolean(tagContactResponse, true));
        this.warp((Vector3f)capsule.readSavable(tagPhysicsLocation, (Savable)new Vector3f()));
    }

    @Override
    public void write(JmeExporter exporter) throws IOException {
        super.write(exporter);
        OutputCapsule capsule = exporter.getCapsule((Savable)this);
        capsule.write(this.isContactResponse(), tagContactResponse, true);
        capsule.write((Savable)this.controller, tagController, null);
        capsule.write((Savable)this.getPhysicsLocation(), tagPhysicsLocation, null);
    }

    private void buildObject() {
        long objectId;
        if (!this.hasAssignedNativeObject()) {
            objectId = PhysicsCharacter.createGhostObject();
            this.setNativeId(objectId);
            assert (PhysicsCharacter.getInternalType(objectId) == 4) : PhysicsCharacter.getInternalType(objectId);
            logger2.log(Level.FINE, "Creating {0}.", this);
            this.initUserPointer();
        }
        objectId = this.nativeId();
        PhysicsCharacter.setCharacterFlags(objectId);
        CollisionShape shape = this.getCollisionShape();
        assert (shape.isConvex());
        long shapeId = shape.nativeId();
        PhysicsCharacter.attachCollisionShape(objectId, shapeId);
        this.controller = new CharacterController(this);
        logger2.log(Level.FINE, "Creating {0}.", this);
    }

    private static native long createGhostObject();

    private static native void setCharacterFlags(long var0);
}

