/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.objects;

import com.jme3.bullet.collision.PhysicsCollisionObject;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Matrix3f;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.util.clone.Cloner;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PhysicsGhostObject
extends PhysicsCollisionObject {
    public static final Logger logger2 = Logger.getLogger(PhysicsGhostObject.class.getName());
    private static final String tagPhysicsLocation = "physicsLocation";
    private static final String tagPhysicsRotation = "physicsRotation";
    private List<PhysicsCollisionObject> overlappingObjects = new LinkedList<PhysicsCollisionObject>();

    protected PhysicsGhostObject() {
    }

    public PhysicsGhostObject(CollisionShape shape) {
        super.setCollisionShape(shape);
        this.buildObject();
        assert (!this.isContactResponse());
    }

    public PhysicsCollisionObject getOverlapping(int index) {
        return this.overlappingObjects.get(index);
    }

    public int getOverlappingCount() {
        long objectId = this.nativeId();
        int result = PhysicsGhostObject.getOverlappingCount(objectId);
        return result;
    }

    public List<PhysicsCollisionObject> getOverlappingObjects() {
        this.overlappingObjects.clear();
        long objectId = this.nativeId();
        this.getOverlappingObjects(objectId);
        return this.overlappingObjects;
    }

    public void setPhysicsLocation(Vector3f location) {
        long objectId = this.nativeId();
        PhysicsGhostObject.setPhysicsLocation(objectId, location);
    }

    public void setPhysicsRotation(Matrix3f rotation) {
        long objectId = this.nativeId();
        PhysicsGhostObject.setPhysicsRotation(objectId, rotation);
    }

    public void setPhysicsRotation(Quaternion rotation) {
        long objectId = this.nativeId();
        PhysicsGhostObject.setPhysicsRotation(objectId, rotation);
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        super.cloneFields(cloner, original);
        this.unassignNativeObject();
        this.overlappingObjects = (List)cloner.clone(this.overlappingObjects);
        this.buildObject();
        PhysicsGhostObject old = (PhysicsGhostObject)original;
        this.cloneIgnoreList(cloner, old);
        this.copyPcoProperties(old);
        this.setPhysicsLocation(old.getPhysicsLocation(null));
        this.setPhysicsRotation(old.getPhysicsRotationMatrix(null));
    }

    @Override
    public PhysicsGhostObject jmeClone() {
        try {
            PhysicsGhostObject clone = (PhysicsGhostObject)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public void setCollisionShape(CollisionShape collisionShape) {
        super.setCollisionShape(collisionShape);
        this.buildObject();
    }

    @Override
    public void read(JmeImporter importer) throws IOException {
        super.read(importer);
        InputCapsule capsule = importer.getCapsule((Savable)this);
        this.buildObject();
        this.readPcoProperties(capsule);
        this.setPhysicsLocation((Vector3f)capsule.readSavable(tagPhysicsLocation, (Savable)new Vector3f()));
        this.setPhysicsRotation((Matrix3f)capsule.readSavable(tagPhysicsRotation, (Savable)new Matrix3f()));
    }

    @Override
    public void write(JmeExporter exporter) throws IOException {
        super.write(exporter);
        OutputCapsule capsule = exporter.getCapsule((Savable)this);
        capsule.write((Savable)this.getPhysicsLocation(null), tagPhysicsLocation, null);
        capsule.write((Savable)this.getPhysicsRotationMatrix(null), tagPhysicsRotation, null);
    }

    private void addOverlappingObject_native(PhysicsCollisionObject co) {
        this.overlappingObjects.add(co);
    }

    private void buildObject() {
        long objectId;
        if (!this.hasAssignedNativeObject()) {
            objectId = PhysicsGhostObject.createGhostObject();
            this.setNativeId(objectId);
            assert (PhysicsGhostObject.getInternalType(objectId) == 4) : PhysicsGhostObject.getInternalType(objectId);
            logger2.log(Level.FINE, "Created {0}.", this);
            PhysicsGhostObject.setGhostFlags(objectId);
            this.initUserPointer();
        }
        objectId = this.nativeId();
        CollisionShape shape = this.getCollisionShape();
        PhysicsGhostObject.attachCollisionShape(objectId, shape.nativeId());
    }

    private static native long createGhostObject();

    private static native int getOverlappingCount(long var0);

    private native void getOverlappingObjects(long var1);

    private static native void setGhostFlags(long var0);

    private static native void setPhysicsLocation(long var0, Vector3f var2);

    private static native void setPhysicsRotation(long var0, Matrix3f var2);

    private static native void setPhysicsRotation(long var0, Quaternion var2);
}

