/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.objects;

import com.jme3.bullet.PhysicsSpace;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.collision.shapes.HeightfieldCollisionShape;
import com.jme3.bullet.objects.PhysicsBody;
import com.jme3.bullet.objects.infos.RigidBodyMotionState;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.FastMath;
import com.jme3.math.Matrix3f;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.util.clone.Cloner;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jme3utilities.Validate;
import jme3utilities.math.MyVector3f;

public class PhysicsRigidBody
extends PhysicsBody {
    public static final Logger logger2 = Logger.getLogger(PhysicsRigidBody.class.getName());
    private static final Matrix3f matrixIdentity = new Matrix3f();
    private static final String tagAngularDamping = "angularDamping";
    private static final String tagAngularFactor = "angularFactor";
    private static final String tagAngularSleepingThreshold = "angularSleepingThreshold";
    private static final String tagAngularVelocity = "angularVelocity";
    private static final String tagAppliedForce = "appliedForce";
    private static final String tagAppliedTorque = "appliedTorque";
    private static final String tagContactResponse = "contactResponse";
    private static final String tagInverseInertia = "inverseInertia";
    private static final String tagKinematic = "kinematic";
    private static final String tagLinearDamping = "linearDamping";
    private static final String tagLinearFactor = "linearFactor";
    private static final String tagLinearSleepingThreshold = "linearSleepingThreshold";
    private static final String tagLinearVelocity = "linearVelocity";
    private static final String tagMass = "mass";
    private static final String tagPhysicsLocation = "physicsLocation";
    private static final String tagPhysicsRotation = "physicsRotation";
    private static final String tagProtectGravity = "tagProtectGravity";
    private static final Vector3f scaleIdentity = new Vector3f(1.0f, 1.0f, 1.0f);
    private static final Vector3f translateIdentity = new Vector3f(0.0f, 0.0f, 0.0f);
    private boolean kinematic = false;
    protected float mass = 1.0f;
    private RigidBodyMotionState motionState = new RigidBodyMotionState();

    protected PhysicsRigidBody() {
    }

    public PhysicsRigidBody(CollisionShape shape) {
        Validate.nonNull((Object)shape, (String)"shape");
        super.setCollisionShape(shape);
        this.rebuildRigidBody();
        assert (this.isContactResponse());
        assert (!this.isInWorld());
        assert (!this.isKinematic());
        assert (!this.isStatic());
        assert (this.mass == 1.0f) : this.mass;
    }

    public PhysicsRigidBody(CollisionShape shape, float mass) {
        Validate.nonNull((Object)shape, (String)"shape");
        Validate.nonNegative((float)mass, (String)tagMass);
        this.mass = mass;
        super.setCollisionShape(shape);
        this.rebuildRigidBody();
        assert (this.isContactResponse());
        assert (!this.isInWorld());
        assert (!this.isKinematic());
    }

    public void activate() {
        this.activate(true);
        assert (this.isActive());
    }

    public void applyCentralForce(Vector3f force) {
        Validate.finite((Vector3f)force, (String)"force");
        long objectId = this.nativeId();
        PhysicsRigidBody.applyCentralForce(objectId, force);
        this.activate();
    }

    public void applyCentralImpulse(Vector3f impulse) {
        Validate.finite((Vector3f)impulse, (String)"impulse");
        long objectId = this.nativeId();
        PhysicsRigidBody.applyCentralImpulse(objectId, impulse);
        this.activate();
    }

    public void applyForce(Vector3f force, Vector3f offset) {
        Validate.finite((Vector3f)force, (String)"force");
        Validate.finite((Vector3f)offset, (String)"offset");
        long objectId = this.nativeId();
        PhysicsRigidBody.applyForce(objectId, force, offset);
        this.activate();
    }

    public void applyImpulse(Vector3f impulse, Vector3f offset) {
        Validate.finite((Vector3f)impulse, (String)"impulse");
        Validate.finite((Vector3f)offset, (String)"offset");
        long objectId = this.nativeId();
        PhysicsRigidBody.applyImpulse(objectId, impulse, offset);
        this.activate();
    }

    public void applyTorque(Vector3f torque) {
        Validate.finite((Vector3f)torque, (String)"torque");
        long objectId = this.nativeId();
        PhysicsRigidBody.applyTorque(objectId, torque);
        this.activate();
    }

    public void applyTorqueImpulse(Vector3f torqueImpulse) {
        Validate.finite((Vector3f)torqueImpulse, (String)"torque impulse");
        long objectId = this.nativeId();
        PhysicsRigidBody.applyTorqueImpulse(objectId, torqueImpulse);
        this.activate();
    }

    public void clearForces() {
        long objectId = this.nativeId();
        PhysicsRigidBody.clearForces(objectId);
    }

    public float getAngularDamping() {
        long objectId = this.nativeId();
        float result = PhysicsRigidBody.getAngularDamping(objectId);
        assert (result >= 0.0f) : result;
        assert (result <= 1.0f) : result;
        return result;
    }

    public float getAngularFactor() {
        return this.getAngularFactor(null).x;
    }

    public Vector3f getAngularFactor(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long objectId = this.nativeId();
        PhysicsRigidBody.getAngularFactor(objectId, result);
        return result;
    }

    public float getAngularSleepingThreshold() {
        long objectId = this.nativeId();
        float result = PhysicsRigidBody.getAngularSleepingThreshold(objectId);
        return result;
    }

    public Vector3f getAngularVelocity() {
        assert (this.isDynamic());
        return this.getAngularVelocity(null);
    }

    public Vector3f getAngularVelocity(Vector3f storeResult) {
        assert (this.isDynamic());
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long objectId = this.nativeId();
        PhysicsRigidBody.getAngularVelocity(objectId, result);
        return result;
    }

    public Vec3d getAngularVelocityDp(Vec3d storeResult) {
        assert (this.isDynamic());
        Vec3d result = storeResult == null ? new Vec3d() : storeResult;
        long objectId = this.nativeId();
        PhysicsRigidBody.getAngularVelocityDp(objectId, result);
        return result;
    }

    public Vector3f getAngularVelocityLocal(Vector3f storeResult) {
        assert (this.isDynamic());
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long objectId = this.nativeId();
        PhysicsRigidBody.getAngularVelocity(objectId, result);
        Quaternion localToWorld = this.getPhysicsRotation(null);
        Quaternion worldToLocal = localToWorld.inverse();
        worldToLocal.mult(result, result);
        return result;
    }

    public Vec3d getGravityDp(Vec3d storeResult) {
        Vec3d result = storeResult == null ? new Vec3d() : storeResult;
        long objectId = this.nativeId();
        PhysicsRigidBody.getGravityDp(objectId, result);
        return result;
    }

    public Vector3f getInverseInertiaLocal(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long objectId = this.nativeId();
        PhysicsRigidBody.getInverseInertiaLocal(objectId, result);
        return result;
    }

    public Matrix3f getInverseInertiaWorld(Matrix3f storeResult) {
        Matrix3f result = storeResult == null ? new Matrix3f() : storeResult;
        long objectId = this.nativeId();
        PhysicsRigidBody.getInverseInertiaWorld(objectId, result);
        return result;
    }

    public float getLinearDamping() {
        long objectId = this.nativeId();
        float result = PhysicsRigidBody.getLinearDamping(objectId);
        assert (result >= 0.0f) : result;
        assert (result <= 1.0f) : result;
        return result;
    }

    public Vector3f getLinearFactor(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long objectId = this.nativeId();
        PhysicsRigidBody.getLinearFactor(objectId, result);
        return result;
    }

    public float getLinearSleepingThreshold() {
        long objectId = this.nativeId();
        float result = PhysicsRigidBody.getLinearSleepingThreshold(objectId);
        return result;
    }

    public Vector3f getLinearVelocity() {
        assert (this.isDynamic());
        return this.getLinearVelocity(null);
    }

    public Vector3f getLinearVelocity(Vector3f storeResult) {
        assert (this.isDynamic());
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long objectId = this.nativeId();
        PhysicsRigidBody.getLinearVelocity(objectId, result);
        return result;
    }

    public Vec3d getLinearVelocityDp(Vec3d storeResult) {
        assert (this.isDynamic());
        Vec3d result = storeResult == null ? new Vec3d() : storeResult;
        long objectId = this.nativeId();
        PhysicsRigidBody.getLinearVelocityDp(objectId, result);
        return result;
    }

    public RigidBodyMotionState getMotionState() {
        return this.motionState;
    }

    public Quaternion getPhysicsRotation() {
        return this.getPhysicsRotation(null);
    }

    public float getSquaredSpeed() {
        assert (this.isDynamic());
        long objectId = this.nativeId();
        float result = PhysicsRigidBody.getSquaredSpeed(objectId);
        return result;
    }

    public boolean isDynamic() {
        return this.mass > 0.0f && !this.kinematic;
    }

    public boolean isGravityProtected() {
        long objectId = this.nativeId();
        boolean result = !PhysicsRigidBody.getUseSpaceGravity(objectId);
        return result;
    }

    public final boolean isKinematic() {
        assert (this.checkKinematicFlag()) : this.kinematic;
        return this.kinematic;
    }

    public double kineticEnergy() {
        assert (this.isDynamic());
        double mv2 = this.mass * this.getSquaredSpeed();
        Vector3f vec = new Vector3f();
        this.getAngularVelocityLocal(vec);
        double xx = vec.x;
        double yy = vec.y;
        double zz = vec.z;
        Vector3f invI = this.getInverseInertiaLocal(null);
        double iw2 = xx * xx / (double)invI.x + yy * yy / (double)invI.y + zz * zz / (double)invI.z;
        double result = (mv2 + iw2) / 2.0;
        assert (result >= 0.0) : result;
        return result;
    }

    public double mechanicalEnergy() {
        assert (this.isDynamic());
        Vector3f gravity = this.getGravity(null);
        Vector3f location = this.getPhysicsLocation(null);
        double potentialEnergy = (double)(-this.mass) * MyVector3f.dot((Vector3f)gravity, (Vector3f)location);
        double result = potentialEnergy + this.kineticEnergy();
        return result;
    }

    public void setAngularDamping(float angularDamping) {
        Validate.fraction((float)angularDamping, (String)"angular damping");
        long objectId = this.nativeId();
        PhysicsRigidBody.setAngularDamping(objectId, angularDamping);
    }

    public void setAngularFactor(float factor) {
        long objectId = this.nativeId();
        PhysicsRigidBody.setAngularFactor(objectId, new Vector3f(factor, factor, factor));
    }

    public void setAngularFactor(Vector3f factor) {
        long objectId = this.nativeId();
        PhysicsRigidBody.setAngularFactor(objectId, factor);
    }

    public void setAngularSleepingThreshold(float threshold) {
        long objectId = this.nativeId();
        PhysicsRigidBody.setAngularSleepingThreshold(objectId, threshold);
    }

    public void setAngularVelocity(Vector3f omega) {
        Validate.finite((Vector3f)omega, (String)"omega");
        long objectId = this.nativeId();
        PhysicsRigidBody.setAngularVelocity(objectId, omega);
        this.activate();
    }

    public void setAngularVelocityDp(Vec3d omega) {
        long objectId = this.nativeId();
        PhysicsRigidBody.setAngularVelocityDp(objectId, omega);
        this.activate();
    }

    @Override
    public void setCollisionShape(CollisionShape collisionShape) {
        Validate.nonNull((Object)collisionShape, (String)"collision shape");
        if (this.isDynamic()) {
            PhysicsRigidBody.validateDynamicShape(collisionShape);
        }
        super.setCollisionShape(collisionShape);
        if (this.hasAssignedNativeObject()) {
            long objectId = this.nativeId();
            long shapeId = collisionShape.nativeId();
            PhysicsRigidBody.setCollisionShape(objectId, shapeId);
            PhysicsRigidBody.updateMassProps(objectId, shapeId, this.mass);
        } else {
            this.rebuildRigidBody();
        }
    }

    public void setContactResponse(boolean newState) {
        long objectId = this.nativeId();
        int flags = PhysicsRigidBody.getCollisionFlags(objectId);
        flags = newState ? (flags &= 0xFFFFFFFB) : (flags |= 4);
        PhysicsRigidBody.setCollisionFlags(objectId, flags);
    }

    public void setDamping(float linearDamping, float angularDamping) {
        Validate.fraction((float)linearDamping, (String)"linear damping");
        Validate.fraction((float)angularDamping, (String)"angular damping");
        long objectId = this.nativeId();
        PhysicsRigidBody.setDamping(objectId, linearDamping, angularDamping);
    }

    public void setEnableSleep(boolean setting) {
        long objectId = this.nativeId();
        if (setting) {
            PhysicsRigidBody.setActivationState(objectId, 1);
        } else {
            PhysicsRigidBody.setActivationState(objectId, 4);
        }
    }

    public void setGravityDp(Vec3d acceleration) {
        Validate.nonNull((Object)acceleration, (String)"acceleration");
        if (!this.isInWorld() && !this.isGravityProtected()) {
            logger2.warning("The body isn't in any PhysicsSpace, and its gravity isn't protected. Unless protection is set, adding it to a PhysicsSpace will override its gravity.");
        }
        long objectId = this.nativeId();
        PhysicsRigidBody.setGravityDp(objectId, acceleration);
    }

    public void setInverseInertiaLocal(Vector3f inverseInertia) {
        Validate.nonNull((Object)inverseInertia, (String)"inverse inertia");
        long objectId = this.nativeId();
        PhysicsRigidBody.setInverseInertiaLocal(objectId, inverseInertia);
    }

    public void setKinematic(boolean kinematic) {
        if (this.mass == 0.0f) {
            throw new IllegalStateException("Cannot set/clear kinematic mode on a static body!");
        }
        assert (!this.isStatic());
        this.kinematic = kinematic;
        long objectId = this.nativeId();
        PhysicsRigidBody.setKinematic(objectId, kinematic);
        assert (this.isKinematic() == kinematic) : kinematic;
    }

    public void setLinearDamping(float linearDamping) {
        Validate.fraction((float)linearDamping, (String)"linear damping");
        long objectId = this.nativeId();
        float angularDamping = this.getAngularDamping();
        PhysicsRigidBody.setDamping(objectId, linearDamping, angularDamping);
    }

    public void setLinearFactor(Vector3f factor) {
        Validate.nonNull((Object)factor, (String)"factor");
        long objectId = this.nativeId();
        PhysicsRigidBody.setLinearFactor(objectId, factor);
    }

    public void setLinearSleepingThreshold(float threshold) {
        long objectId = this.nativeId();
        PhysicsRigidBody.setLinearSleepingThreshold(objectId, threshold);
    }

    public void setLinearVelocity(Vector3f velocity) {
        Validate.finite((Vector3f)velocity, (String)"velocity");
        long objectId = this.nativeId();
        PhysicsRigidBody.setLinearVelocity(objectId, velocity);
        this.activate();
    }

    public void setLinearVelocityDp(Vec3d velocity) {
        long objectId = this.nativeId();
        PhysicsRigidBody.setLinearVelocityDp(objectId, velocity);
        this.activate();
    }

    public void setPhysicsLocationDp(Vec3d location) {
        long objectId = this.nativeId();
        PhysicsRigidBody.setPhysicsLocationDp(objectId, location);
    }

    public void setPhysicsRotation(Matrix3f orientation) {
        Validate.nonNull((Object)orientation, (String)"rotation");
        if (this.getCollisionShape() instanceof HeightfieldCollisionShape && !orientation.isIdentity()) {
            throw new IllegalArgumentException("No rotation of heightfields.");
        }
        long objectId = this.nativeId();
        PhysicsRigidBody.setPhysicsRotation(objectId, orientation);
    }

    public void setPhysicsRotation(Quaternion orientation) {
        Validate.nonNull((Object)orientation, (String)"orientation");
        long objectId = this.nativeId();
        PhysicsRigidBody.setPhysicsRotation(objectId, orientation);
    }

    public void setPhysicsRotationDp(Quatd orientation) {
        Validate.nonNull((Object)orientation, (String)"orientation");
        long objectId = this.nativeId();
        PhysicsRigidBody.setPhysicsRotationDp(objectId, orientation);
    }

    public void setPhysicsScale(Vector3f newScale) {
        CollisionShape shape = this.getCollisionShape();
        Vector3f oldScale = shape.getScale(null);
        if (MyVector3f.ne((Vector3f)oldScale, (Vector3f)newScale)) {
            shape.setScale(newScale);
            this.setCollisionShape(shape);
        }
    }

    public void setPhysicsTransform(Transform transform) {
        this.setPhysicsLocation(transform.getTranslation());
        this.setPhysicsRotation(transform.getRotation());
        this.setPhysicsScale(transform.getScale());
    }

    public void setProtectGravity(boolean newState) {
        long objectId = this.nativeId();
        PhysicsRigidBody.setUseSpaceGravity(objectId, !newState);
    }

    public void setSleepingThresholds(float linear, float angular) {
        Validate.nonNegative((float)linear, (String)"linear threshold");
        Validate.nonNegative((float)angular, (String)"angular threshold");
        long objectId = this.nativeId();
        PhysicsRigidBody.setSleepingThresholds(objectId, linear, angular);
    }

    public Vector3f totalAppliedForce(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long objectId = this.nativeId();
        PhysicsRigidBody.getTotalForce(objectId, result);
        return result;
    }

    public Vector3f totalAppliedTorque(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long objectId = this.nativeId();
        PhysicsRigidBody.getTotalTorque(objectId, result);
        return result;
    }

    protected void postRebuild() {
        long objectId = this.nativeId();
        int flags = PhysicsRigidBody.getCollisionFlags(objectId);
        flags = this.mass == 0.0f ? (flags |= 1) : (flags &= 0xFFFFFFFE);
        PhysicsRigidBody.setCollisionFlags(objectId, flags);
        this.initUserPointer();
    }

    protected void preRebuild() {
    }

    protected void rebuildRigidBody() {
        PhysicsSpace removedFrom = null;
        long[] ignoredIds = null;
        if (this.hasAssignedNativeObject()) {
            removedFrom = (PhysicsSpace)this.getCollisionSpace();
            if (removedFrom != null) {
                removedFrom.removeCollisionObject(this);
            }
            ignoredIds = this.listIgnoredIds();
            this.clearIgnoreList();
            logger2.log(Level.FINE, "Clearing {0}.", this);
            this.unassignNativeObject();
        }
        this.preRebuild();
        CollisionShape shape = this.getCollisionShape();
        long objectId = PhysicsRigidBody.createRigidBody(this.mass, this.motionState.nativeId(), shape.nativeId());
        this.setNativeId(objectId);
        assert (PhysicsRigidBody.getInternalType(objectId) == 2) : PhysicsRigidBody.getInternalType(objectId);
        logger2.log(Level.FINE, "Created {0}.", this);
        this.postRebuild();
        if (ignoredIds != null) {
            boolean toIgnore = true;
            for (long id : ignoredIds) {
                PhysicsRigidBody.setIgnoreCollisionCheck(objectId, id, toIgnore);
            }
        }
        if (removedFrom != null) {
            removedFrom.addCollisionObject(this);
        }
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        super.cloneFields(cloner, original);
        this.rebuildRigidBody();
        PhysicsRigidBody old = (PhysicsRigidBody)original;
        this.cloneIgnoreList(cloner, old);
        this.cloneJoints(cloner);
        this.motionState = (RigidBodyMotionState)cloner.clone((Object)this.motionState);
        if (this.mass != 0.0f) {
            this.setKinematic(this.kinematic);
        }
        Vector3f tmpVector = new Vector3f();
        if (old.isDynamic()) {
            this.setAngularVelocity(old.getAngularVelocity(tmpVector));
            this.setLinearVelocity(old.getLinearVelocity(tmpVector));
        }
        this.clearForces();
        this.setAngularFactor(scaleIdentity);
        this.applyTorque(old.totalAppliedTorque(tmpVector));
        this.setAngularFactor(old.getAngularFactor(tmpVector));
        this.setLinearFactor(scaleIdentity);
        this.applyCentralForce(old.totalAppliedForce(tmpVector));
        this.setLinearFactor(old.getLinearFactor(tmpVector));
        this.copyPcoProperties(old);
        this.setAngularDamping(old.getAngularDamping());
        this.setAngularSleepingThreshold(old.getAngularSleepingThreshold());
        this.setContactResponse(old.isContactResponse());
        this.setInverseInertiaLocal(old.getInverseInertiaLocal(tmpVector));
        this.setLinearDamping(old.getLinearDamping());
        this.setLinearSleepingThreshold(old.getLinearSleepingThreshold());
        this.setPhysicsLocation(old.getPhysicsLocation(tmpVector));
        this.setPhysicsRotation(old.getPhysicsRotationMatrix(null));
        this.setProtectGravity(old.isGravityProtected());
    }

    @Override
    public Vector3f getGravity(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long objectId = this.nativeId();
        PhysicsRigidBody.getGravity(objectId, result);
        return result;
    }

    @Override
    public float getMass() {
        assert (this.checkMass());
        return this.mass;
    }

    @Override
    public PhysicsRigidBody jmeClone() {
        try {
            PhysicsRigidBody clone = (PhysicsRigidBody)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public void read(JmeImporter importer) throws IOException {
        super.read(importer);
        InputCapsule capsule = importer.getCapsule((Savable)this);
        this.mass = capsule.readFloat(tagMass, 1.0f);
        this.rebuildRigidBody();
        this.setAngularVelocity((Vector3f)capsule.readSavable(tagAngularVelocity, (Savable)translateIdentity));
        if (this.mass != 0.0f) {
            this.setKinematic(capsule.readBoolean(tagKinematic, false));
        }
        this.setLinearVelocity((Vector3f)capsule.readSavable(tagLinearVelocity, (Savable)translateIdentity));
        this.applyCentralForce((Vector3f)capsule.readSavable(tagAppliedForce, (Savable)translateIdentity));
        this.applyTorque((Vector3f)capsule.readSavable(tagAppliedTorque, (Savable)translateIdentity));
        this.readPcoProperties(capsule);
        this.setContactResponse(capsule.readBoolean(tagContactResponse, true));
        this.setInverseInertiaLocal((Vector3f)capsule.readSavable(tagInverseInertia, (Savable)scaleIdentity));
        this.setAngularFactor((Vector3f)capsule.readSavable(tagAngularFactor, (Savable)scaleIdentity));
        this.setLinearFactor((Vector3f)capsule.readSavable(tagLinearFactor, (Savable)scaleIdentity));
        this.setDamping(capsule.readFloat(tagLinearDamping, 0.0f), capsule.readFloat(tagAngularDamping, 0.0f));
        this.setSleepingThresholds(capsule.readFloat(tagLinearSleepingThreshold, 0.8f), capsule.readFloat(tagAngularSleepingThreshold, 1.0f));
        this.setProtectGravity(capsule.readBoolean(tagProtectGravity, false));
        this.setPhysicsLocation((Vector3f)capsule.readSavable(tagPhysicsLocation, (Savable)translateIdentity));
        this.setPhysicsRotation((Matrix3f)capsule.readSavable(tagPhysicsRotation, (Savable)matrixIdentity));
        this.readJoints(capsule);
    }

    @Override
    public void setGravity(Vector3f acceleration) {
        Validate.nonNull((Object)acceleration, (String)"acceleration");
        if (!this.isInWorld() && !this.isGravityProtected()) {
            logger2.warning("The body isn't in any PhysicsSpace, and its gravity isn't protected. Unless protection is set, adding it to a PhysicsSpace will override its gravity.");
        }
        long objectId = this.nativeId();
        PhysicsRigidBody.setGravity(objectId, acceleration);
    }

    @Override
    public void setMass(float mass) {
        Validate.nonNegative((float)mass, (String)tagMass);
        CollisionShape shape = this.getCollisionShape();
        assert (shape != null);
        if (mass != 0.0f) {
            PhysicsRigidBody.validateDynamicShape(shape);
        }
        assert (this.hasAssignedNativeObject());
        if (mass == this.mass) {
            return;
        }
        if (this.mass == 0.0f) {
            this.mass = mass;
            this.rebuildRigidBody();
            return;
        }
        this.mass = mass;
        long objectId = this.nativeId();
        PhysicsRigidBody.updateMassProps(objectId, shape.nativeId(), mass);
        int flags = PhysicsRigidBody.getCollisionFlags(objectId);
        flags = mass == 0.0f ? (flags |= 1) : (flags &= 0xFFFFFFFE);
        PhysicsRigidBody.setCollisionFlags(objectId, flags);
    }

    @Override
    public void setPhysicsLocation(Vector3f location) {
        Validate.finite((Vector3f)location, (String)"location");
        long objectId = this.nativeId();
        PhysicsRigidBody.setPhysicsLocation(objectId, location);
    }

    @Override
    public void write(JmeExporter exporter) throws IOException {
        super.write(exporter);
        OutputCapsule capsule = exporter.getCapsule((Savable)this);
        capsule.write(this.getMass(), tagMass, 1.0f);
        capsule.write(this.isContactResponse(), tagContactResponse, true);
        capsule.write((Savable)this.getAngularFactor(null), tagAngularFactor, null);
        capsule.write((Savable)this.getLinearFactor(null), tagLinearFactor, null);
        capsule.write(this.kinematic, tagKinematic, false);
        capsule.write((Savable)this.getInverseInertiaLocal(null), tagInverseInertia, null);
        capsule.write(this.getLinearDamping(), tagLinearDamping, 0.0f);
        capsule.write(this.getAngularDamping(), tagAngularDamping, 0.0f);
        capsule.write(this.getLinearSleepingThreshold(), tagLinearSleepingThreshold, 0.8f);
        capsule.write(this.getAngularSleepingThreshold(), tagAngularSleepingThreshold, 1.0f);
        capsule.write(this.isGravityProtected(), tagProtectGravity, false);
        capsule.write((Savable)this.getPhysicsLocation(null), tagPhysicsLocation, null);
        capsule.write((Savable)this.getPhysicsRotationMatrix(null), tagPhysicsRotation, null);
        if (this.isDynamic()) {
            capsule.write((Savable)this.getLinearVelocity(null), tagLinearVelocity, null);
            capsule.write((Savable)this.getAngularVelocity(null), tagAngularVelocity, null);
        }
        capsule.write((Savable)this.totalAppliedForce(null), tagAppliedForce, null);
        capsule.write((Savable)this.totalAppliedTorque(null), tagAppliedTorque, null);
        this.writeJoints(capsule);
    }

    private boolean checkMass() {
        long objectId = this.nativeId();
        float nativeMass = PhysicsRigidBody.getMass(objectId);
        boolean result = FastMath.approximateEquals((float)nativeMass, (float)this.mass);
        return result;
    }

    private boolean checkKinematicFlag() {
        boolean nativeKinematicFlag;
        if (this.mass == 0.0f) {
            return true;
        }
        long objectId = this.nativeId();
        int flags = PhysicsRigidBody.getCollisionFlags(objectId);
        boolean bl = nativeKinematicFlag = (flags & 2) != 0;
        return this.kinematic == nativeKinematicFlag;
    }

    private static void validateDynamicShape(CollisionShape shape) {
        assert (shape != null);
        if (shape.isNonMoving()) {
            throw new IllegalStateException("Dynamic rigid body can't have a non-moving shape!");
        }
    }

    private static native void applyCentralForce(long var0, Vector3f var2);

    private static native void applyCentralImpulse(long var0, Vector3f var2);

    private static native void applyForce(long var0, Vector3f var2, Vector3f var3);

    private static native void applyImpulse(long var0, Vector3f var2, Vector3f var3);

    private static native void applyTorque(long var0, Vector3f var2);

    private static native void applyTorqueImpulse(long var0, Vector3f var2);

    private static native void clearForces(long var0);

    private static native long createRigidBody(float var0, long var1, long var3);

    private static native float getAngularDamping(long var0);

    private static native void getAngularFactor(long var0, Vector3f var2);

    private static native float getAngularSleepingThreshold(long var0);

    private static native void getAngularVelocity(long var0, Vector3f var2);

    private static native void getAngularVelocityDp(long var0, Vec3d var2);

    private static native void getGravity(long var0, Vector3f var2);

    private static native void getGravityDp(long var0, Vec3d var2);

    private static native void getInverseInertiaLocal(long var0, Vector3f var2);

    private static native void getInverseInertiaWorld(long var0, Matrix3f var2);

    private static native float getLinearDamping(long var0);

    private static native void getLinearFactor(long var0, Vector3f var2);

    private static native float getLinearSleepingThreshold(long var0);

    private static native void getLinearVelocity(long var0, Vector3f var2);

    private static native void getLinearVelocityDp(long var0, Vec3d var2);

    private static native float getMass(long var0);

    private static native float getSquaredSpeed(long var0);

    private static native void getTotalForce(long var0, Vector3f var2);

    private static native void getTotalTorque(long var0, Vector3f var2);

    private static native boolean getUseSpaceGravity(long var0);

    private static native void setAngularDamping(long var0, float var2);

    private static native void setAngularFactor(long var0, Vector3f var2);

    private static native void setAngularSleepingThreshold(long var0, float var2);

    private static native void setAngularVelocity(long var0, Vector3f var2);

    private static native void setAngularVelocityDp(long var0, Vec3d var2);

    private static native void setCollisionShape(long var0, long var2);

    private static native void setDamping(long var0, float var2, float var3);

    private static native void setGravity(long var0, Vector3f var2);

    private static native void setGravityDp(long var0, Vec3d var2);

    private static native void setInverseInertiaLocal(long var0, Vector3f var2);

    private static native void setKinematic(long var0, boolean var2);

    private static native void setLinearFactor(long var0, Vector3f var2);

    private static native void setLinearSleepingThreshold(long var0, float var2);

    private static native void setLinearVelocity(long var0, Vector3f var2);

    private static native void setLinearVelocityDp(long var0, Vec3d var2);

    private static native void setPhysicsLocation(long var0, Vector3f var2);

    private static native void setPhysicsLocationDp(long var0, Vec3d var2);

    private static native void setPhysicsRotation(long var0, Matrix3f var2);

    private static native void setPhysicsRotation(long var0, Quaternion var2);

    private static native void setPhysicsRotationDp(long var0, Quatd var2);

    private static native void setSleepingThresholds(long var0, float var2, float var3);

    private static native void setUseSpaceGravity(long var0, boolean var2);

    private static native void updateMassProps(long var0, long var2, float var4);
}

