/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.objects;

import com.jme3.bullet.objects.infos.VehicleTuning;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Matrix3f;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.util.clone.Cloner;
import com.jme3.util.clone.JmeCloneable;
import java.io.IOException;
import java.util.logging.Logger;
import jme3utilities.Validate;

public class VehicleWheel
implements JmeCloneable,
Savable {
    public static final Logger logger = Logger.getLogger(VehicleWheel.class.getName());
    private static final String tagBrake = "brake";
    private static final String tagEngineForce = "engineForce";
    private static final String tagFrontWheel = "frontWheel";
    private static final String tagRestLength = "restLength";
    private static final String tagRollInfluence = "rollInfluence";
    private static final String tagRotationAngle = "rotationAngle";
    private static final String tagSteerAngle = "steerAngle";
    private static final String tagSuspensionLength = "suspensionLength";
    private static final String tagTuning = "tuning";
    private static final String tagWheelAxle = "wheelAxle";
    private static final String tagWheelDirection = "wheelDirection";
    private static final String tagWheelLocation = "wheelLocation";
    private static final String tagWheelRadius = "wheelRadius";
    private static final String tagWheelSpatial = "wheelSpatial";
    private boolean applyLocal = false;
    private boolean isFront;
    private float radius = 0.5f;
    private float restLength = 1.0f;
    private float rollInfluence = 1.0f;
    private int wheelIndex = 0;
    private long vehicleId = 0L;
    private Matrix3f tmpMatrix = new Matrix3f();
    private Quaternion tmpInverseWheelRotation = new Quaternion();
    private Quaternion wheelWorldRotation = new Quaternion();
    private Spatial subtree;
    private Vector3f axisDirection = new Vector3f();
    private Vector3f location = new Vector3f();
    private Vector3f suspensionDirection = new Vector3f();
    private Vector3f wheelWorldLocation = new Vector3f();
    private VehicleTuning tuning = new VehicleTuning();

    protected VehicleWheel() {
    }

    public VehicleWheel(Spatial subtree, Vector3f location, Vector3f direction, Vector3f axle, float restLength, float radius, boolean frontWheel) {
        Validate.positive((float)radius, (String)"radius");
        this.subtree = subtree;
        this.location.set(location);
        this.suspensionDirection.set(direction);
        this.axisDirection.set(axle);
        this.isFront = frontWheel;
        this.restLength = restLength;
        this.radius = radius;
    }

    public void applyWheelTransform() {
        if (this.subtree == null) {
            return;
        }
        Quaternion localRotationQuat = this.subtree.getLocalRotation();
        Vector3f localLocation = this.subtree.getLocalTranslation();
        Node parent = this.subtree.getParent();
        if (!this.applyLocal && parent != null) {
            Vector3f parentOffset = parent.getWorldTranslation();
            Quaternion parentRot = parent.getWorldRotation();
            localLocation.set(this.wheelWorldLocation).subtractLocal(parentOffset);
            localLocation.divideLocal(parent.getWorldScale());
            this.tmpInverseWheelRotation.set(parentRot).inverseLocal().multLocal(localLocation);
            localRotationQuat.set(this.wheelWorldRotation);
            this.tmpInverseWheelRotation.set(parentRot).inverseLocal().mult(localRotationQuat, localRotationQuat);
            this.subtree.setLocalTranslation(localLocation);
            this.subtree.setLocalRotation(localRotationQuat);
        } else {
            this.subtree.setLocalTranslation(this.wheelWorldLocation);
            this.subtree.setLocalRotation(this.wheelWorldRotation);
        }
    }

    boolean checkCopies() {
        boolean result;
        boolean nativeIsFront = VehicleWheel.isFront(this.vehicleId, this.wheelIndex);
        boolean bl = result = nativeIsFront == this.isFront;
        if (result) {
            float nativeRadius = VehicleWheel.getRadius(this.vehicleId, this.wheelIndex);
            boolean bl2 = result = nativeRadius == this.radius;
        }
        if (result) {
            float nativeRestLength = VehicleWheel.getRestLength(this.vehicleId, this.wheelIndex);
            boolean bl3 = result = nativeRestLength == this.restLength;
        }
        if (result) {
            float nativeRollInfluence = VehicleWheel.getRollInfluence(this.vehicleId, this.wheelIndex);
            result = nativeRollInfluence == this.rollInfluence;
        }
        return result;
    }

    public Vector3f getAxle(Vector3f storeResult) {
        if (storeResult == null) {
            return this.axisDirection.clone();
        }
        return storeResult.set(this.axisDirection);
    }

    public float getBrake() {
        float result = VehicleWheel.getBrake(this.vehicleId, this.wheelIndex);
        return result;
    }

    public Vector3f getCollisionLocation() {
        return this.getCollisionLocation(null);
    }

    public Vector3f getCollisionLocation(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        VehicleWheel.getCollisionLocation(this.vehicleId, this.wheelIndex, result);
        return result;
    }

    public Vector3f getCollisionNormal() {
        return this.getCollisionNormal(null);
    }

    public Vector3f getCollisionNormal(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        VehicleWheel.getCollisionNormal(this.vehicleId, this.wheelIndex, result);
        return result;
    }

    public float getDeltaRotation() {
        return VehicleWheel.getDeltaRotation(this.vehicleId, this.wheelIndex);
    }

    public Vector3f getDirection(Vector3f storeResult) {
        if (storeResult == null) {
            return this.suspensionDirection.clone();
        }
        return storeResult.set(this.suspensionDirection);
    }

    public float getEngineForce() {
        float result = VehicleWheel.getEngineForce(this.vehicleId, this.wheelIndex);
        return result;
    }

    public float getFrictionSlip() {
        return this.tuning.getFrictionSlip();
    }

    public int getIndex() {
        return this.wheelIndex;
    }

    public Vector3f getLocation() {
        return this.getLocation(null);
    }

    public Vector3f getLocation(Vector3f storeResult) {
        if (storeResult == null) {
            return this.location.clone();
        }
        return storeResult.set(this.location);
    }

    public float getMaxSuspensionForce() {
        return this.tuning.getMaxSuspensionForce();
    }

    public float getMaxSuspensionTravelCm() {
        return this.tuning.getMaxSuspensionTravelCm();
    }

    public float getRadius() {
        return this.radius;
    }

    public float getRestLength() {
        return this.restLength;
    }

    public float getRollInfluence() {
        return this.rollInfluence;
    }

    public float getRotationAngle() {
        float result = VehicleWheel.getRotationAngle(this.vehicleId, this.wheelIndex);
        return result;
    }

    public float getSkidInfo() {
        return VehicleWheel.getSkidInfo(this.vehicleId, this.wheelIndex);
    }

    public float getSteerAngle() {
        float result = VehicleWheel.getSteerAngle(this.vehicleId, this.wheelIndex);
        return result;
    }

    public float getSuspensionLength() {
        float result = VehicleWheel.getSuspensionLength(this.vehicleId, this.wheelIndex);
        return result;
    }

    public float getSuspensionStiffness() {
        return this.tuning.getSuspensionStiffness();
    }

    public float getWheelsDampingCompression() {
        return this.tuning.getSuspensionCompression();
    }

    public float getWheelsDampingRelaxation() {
        return this.tuning.getSuspensionDamping();
    }

    public Spatial getWheelSpatial() {
        return this.subtree;
    }

    public Vector3f getWheelWorldLocation(Vector3f storeResult) {
        if (storeResult == null) {
            return this.wheelWorldLocation.clone();
        }
        return storeResult.set(this.wheelWorldLocation);
    }

    public Quaternion getWheelWorldRotation(Quaternion storeResult) {
        if (storeResult == null) {
            return this.wheelWorldRotation.clone();
        }
        return storeResult.set(this.wheelWorldRotation);
    }

    public boolean isApplyLocal() {
        return this.applyLocal;
    }

    public boolean isFrontWheel() {
        return this.isFront;
    }

    public void setApplyLocal(boolean applyLocal) {
        this.applyLocal = applyLocal;
    }

    public void setFrictionSlip(float coeff) {
        this.tuning.setFrictionSlip(coeff);
        this.applyInfo();
    }

    public void setFrontWheel(boolean frontWheel) {
        this.isFront = frontWheel;
        this.applyInfo();
    }

    public void setMaxSuspensionForce(float maxForce) {
        this.tuning.setMaxSuspensionForce(maxForce);
        this.applyInfo();
    }

    public void setMaxSuspensionTravelCm(float travelCm) {
        this.tuning.setMaxSuspensionTravelCm(travelCm);
        this.applyInfo();
    }

    public void setRadius(float radius) {
        this.radius = radius;
        this.applyInfo();
    }

    public void setRestLength(float restLength) {
        this.restLength = restLength;
        this.applyInfo();
    }

    public void setRollInfluence(float rollInfluence) {
        this.rollInfluence = rollInfluence;
        this.applyInfo();
    }

    public void setRotationAngle(float angle) {
        VehicleWheel.setRotationAngle(this.vehicleId, this.wheelIndex, angle);
    }

    public void setSuspensionLength(float length) {
        VehicleWheel.setSuspensionLength(this.vehicleId, this.wheelIndex, length);
    }

    public void setSuspensionStiffness(float stiffness) {
        this.tuning.setSuspensionStiffness(stiffness);
        this.applyInfo();
    }

    public void setVehicleId(long vehicleId, int wheelIndex) {
        Validate.nonZero((long)vehicleId, (String)"vehicle ID");
        Validate.nonNegative((int)wheelIndex, (String)"wheel index");
        this.vehicleId = vehicleId;
        this.wheelIndex = wheelIndex;
        this.applyInfo();
    }

    public void setWheelsDampingCompression(float damping) {
        this.tuning.setSuspensionCompression(damping);
        this.applyInfo();
    }

    public void setWheelsDampingRelaxation(float wheelsDampingRelaxation) {
        this.tuning.setSuspensionDamping(wheelsDampingRelaxation);
        this.applyInfo();
    }

    public void setWheelSpatial(Spatial subtree) {
        this.subtree = subtree;
    }

    public void updatePhysicsState() {
        VehicleWheel.getWheelLocation(this.vehicleId, this.wheelIndex, this.wheelWorldLocation);
        VehicleWheel.getWheelRotation(this.vehicleId, this.wheelIndex, this.tmpMatrix);
        this.wheelWorldRotation.fromRotationMatrix(this.tmpMatrix);
    }

    public void cloneFields(Cloner cloner, Object original) {
        this.location = (Vector3f)cloner.clone((Object)this.location);
        this.suspensionDirection = (Vector3f)cloner.clone((Object)this.suspensionDirection);
        this.axisDirection = (Vector3f)cloner.clone((Object)this.axisDirection);
        this.tuning = (VehicleTuning)cloner.clone((Object)this.tuning);
        this.wheelWorldLocation = (Vector3f)cloner.clone((Object)this.wheelWorldLocation);
        this.wheelWorldRotation = (Quaternion)cloner.clone((Object)this.wheelWorldRotation);
        this.subtree = (Spatial)cloner.clone((Object)this.subtree);
        this.tmpMatrix = (Matrix3f)cloner.clone((Object)this.tmpMatrix);
        this.tmpInverseWheelRotation = (Quaternion)cloner.clone((Object)this.tmpInverseWheelRotation);
        VehicleWheel originalWheel = (VehicleWheel)original;
        this.setRotationAngle(originalWheel.getRotationAngle());
        this.setSuspensionLength(originalWheel.getSuspensionLength());
    }

    public VehicleWheel jmeClone() {
        try {
            VehicleWheel clone = (VehicleWheel)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException exception) {
            throw new RuntimeException(exception);
        }
    }

    public void read(JmeImporter importer) throws IOException {
        InputCapsule capsule = importer.getCapsule((Savable)this);
        this.subtree = (Spatial)capsule.readSavable(tagWheelSpatial, null);
        this.isFront = capsule.readBoolean(tagFrontWheel, false);
        this.location = (Vector3f)capsule.readSavable(tagWheelLocation, (Savable)new Vector3f());
        this.suspensionDirection = (Vector3f)capsule.readSavable(tagWheelDirection, (Savable)new Vector3f());
        this.axisDirection = (Vector3f)capsule.readSavable(tagWheelAxle, (Savable)new Vector3f());
        this.tuning = (VehicleTuning)capsule.readSavable(tagTuning, (Savable)new VehicleTuning());
        this.rollInfluence = capsule.readFloat(tagRollInfluence, 1.0f);
        this.radius = capsule.readFloat(tagWheelRadius, 0.5f);
        this.restLength = capsule.readFloat(tagRestLength, 1.0f);
        float angle = capsule.readFloat(tagRotationAngle, 0.0f);
        this.setRotationAngle(angle);
        float length = capsule.readFloat(tagSuspensionLength, 0.0f);
        this.setSuspensionLength(length);
        capsule.readFloat(tagBrake, 0.0f);
        capsule.readFloat(tagEngineForce, 0.0f);
        capsule.readFloat(tagSteerAngle, 0.0f);
    }

    public void write(JmeExporter exporter) throws IOException {
        OutputCapsule capsule = exporter.getCapsule((Savable)this);
        capsule.write((Savable)this.subtree, tagWheelSpatial, null);
        capsule.write(this.isFront, tagFrontWheel, false);
        capsule.write((Savable)this.location, tagWheelLocation, null);
        capsule.write((Savable)this.suspensionDirection, tagWheelDirection, null);
        capsule.write((Savable)this.axisDirection, tagWheelAxle, null);
        capsule.write((Savable)this.tuning, tagTuning, null);
        capsule.write(this.rollInfluence, tagRollInfluence, 1.0f);
        capsule.write(this.radius, tagWheelRadius, 0.5f);
        capsule.write(this.restLength, tagRestLength, 1.0f);
        capsule.write(this.getBrake(), tagBrake, 0.0f);
        capsule.write(this.getEngineForce(), tagEngineForce, 0.0f);
        capsule.write(this.getRotationAngle(), tagRotationAngle, 0.0f);
        capsule.write(this.getSteerAngle(), tagSteerAngle, 0.0f);
        capsule.write(this.getSuspensionLength(), tagSuspensionLength, 0.0f);
    }

    private void applyInfo() {
        if (this.vehicleId != 0L) {
            VehicleWheel.applyInfo(this.vehicleId, this.wheelIndex, this.getSuspensionStiffness(), this.getWheelsDampingRelaxation(), this.getWheelsDampingCompression(), this.getFrictionSlip(), this.rollInfluence, this.getMaxSuspensionTravelCm(), this.getMaxSuspensionForce(), this.radius, this.isFront, this.restLength);
            assert (this.checkCopies());
        }
    }

    private static native void applyInfo(long var0, int var2, float var3, float var4, float var5, float var6, float var7, float var8, float var9, float var10, boolean var11, float var12);

    private static native float getBrake(long var0, int var2);

    private static native void getCollisionLocation(long var0, int var2, Vector3f var3);

    private static native void getCollisionNormal(long var0, int var2, Vector3f var3);

    private static native float getDeltaRotation(long var0, int var2);

    private static native float getEngineForce(long var0, int var2);

    private static native float getRadius(long var0, int var2);

    private static native float getRestLength(long var0, int var2);

    private static native float getRollInfluence(long var0, int var2);

    private static native float getRotationAngle(long var0, int var2);

    private static native float getSkidInfo(long var0, int var2);

    private static native float getSteerAngle(long var0, int var2);

    private static native float getSuspensionLength(long var0, int var2);

    private static native void getWheelLocation(long var0, int var2, Vector3f var3);

    private static native void getWheelRotation(long var0, int var2, Matrix3f var3);

    private static native boolean isFront(long var0, int var2);

    private static native void setRotationAngle(long var0, int var2, float var3);

    private static native void setSuspensionLength(long var0, int var2, float var3);
}

