/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.objects.infos;

import com.jme3.bullet.NativePhysicsObject;
import com.jme3.bullet.PhysicsSpace;
import com.jme3.bullet.objects.PhysicsCharacter;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Vector3f;
import com.jme3.util.clone.Cloner;
import com.jme3.util.clone.JmeCloneable;
import java.io.IOException;
import java.util.logging.Logger;
import jme3utilities.Validate;
import jme3utilities.math.MyVector3f;

public class CharacterController
extends NativePhysicsObject
implements JmeCloneable,
Savable {
    public static final Logger logger = Logger.getLogger(CharacterController.class.getName());
    private static final String tagAngularDamping = "angularDamping";
    private static final String tagAngularVelocity = "angularVelocity";
    private static final String tagFallSpeed = "fallSpeed";
    private static final String tagGhostSweepTest = "ghostSweepTest";
    private static final String tagGravityVector = "gravityVector";
    private static final String tagJumpSpeed = "jumpSpeed";
    private static final String tagLinearDamping = "linearDamping";
    private static final String tagLinearVelocity = "linearVelocity";
    private static final String tagMaxPenetrationDepth = "maxPenetrationDepth";
    private static final String tagMaxSlope = "maxSlope";
    private static final String tagPco = "pco";
    private static final String tagStepHeight = "stepHeight";
    private static final String tagUpDirection = "upDirection";
    private static final String tagWalkDirection = "walkDirection";
    private PhysicsCharacter pco;

    protected CharacterController() {
    }

    public CharacterController(PhysicsCharacter character) {
        Validate.nonNull((Object)character, (String)"collision object");
        this.pco = character;
        this.createController();
    }

    public void copyAll(CharacterController source) {
        this.setAngularDamping(source.getAngularDamping());
        this.setAngularVelocity(source.getAngularVelocity(null));
        this.setFallSpeed(source.getFallSpeed());
        this.setGravity(source.getGravity(null));
        this.setJumpSpeed(source.getJumpSpeed());
        this.setLinearDamping(source.getLinearDamping());
        this.setWalkDirection(source.getWalkDirection(null));
        this.setLinearVelocity(source.getLinearVelocity(null));
        this.setMaxPenetrationDepth(source.getMaxPenetrationDepth());
        this.setMaxSlope(source.getMaxSlope());
        this.setStepHeight(source.getStepHeight());
        this.setSweepTest(source.isUsingGhostSweepTest());
        this.setUp(source.getUpDirection(null));
    }

    public float getAngularDamping() {
        long controllerId = this.nativeId();
        float result = CharacterController.getAngularDamping(controllerId);
        return result;
    }

    public Vector3f getAngularVelocity(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long controllerId = this.nativeId();
        CharacterController.getAngularVelocity(controllerId, result);
        return result;
    }

    public float getFallSpeed() {
        long controllerId = this.nativeId();
        float result = CharacterController.getFallSpeed(controllerId);
        return result;
    }

    public Vector3f getGravity(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long controllerId = this.nativeId();
        CharacterController.getGravity(controllerId, result);
        return result;
    }

    public float getJumpSpeed() {
        long controllerId = this.nativeId();
        float result = CharacterController.getJumpSpeed(controllerId);
        return result;
    }

    public float getLinearDamping() {
        long controllerId = this.nativeId();
        float result = CharacterController.getLinearDamping(controllerId);
        return result;
    }

    public Vector3f getLinearVelocity(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long controllerId = this.nativeId();
        CharacterController.getLinearVelocity(controllerId, result);
        return result;
    }

    public float getMaxPenetrationDepth() {
        long controllerId = this.nativeId();
        float result = CharacterController.getMaxPenetrationDepth(controllerId);
        return result;
    }

    public float getMaxSlope() {
        long controllerId = this.nativeId();
        float result = CharacterController.getMaxSlope(controllerId);
        return result;
    }

    public float getStepHeight() {
        long controllerId = this.nativeId();
        float result = CharacterController.getStepHeight(controllerId);
        return result;
    }

    public Vector3f getUpDirection(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long controllerId = this.nativeId();
        CharacterController.getUpDirection(controllerId, result);
        return result;
    }

    public Vector3f getWalkDirection(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long controllerId = this.nativeId();
        CharacterController.getWalkOffset(controllerId, result);
        return result;
    }

    public boolean isUsingGhostSweepTest() {
        long controllerId = this.nativeId();
        boolean result = CharacterController.isUsingGhostSweepTest(controllerId);
        return result;
    }

    public void jump(Vector3f direction) {
        long controllerId = this.nativeId();
        CharacterController.jump(controllerId, direction);
    }

    public boolean onGround() {
        long controllerId = this.nativeId();
        boolean result = CharacterController.onGround(controllerId);
        return result;
    }

    public void reset(PhysicsSpace space) {
        long controllerId = this.nativeId();
        long spaceId = space.nativeId();
        CharacterController.reset(controllerId, spaceId);
    }

    public void setAngularDamping(float damping) {
        long controllerId = this.nativeId();
        CharacterController.setAngularDamping(controllerId, damping);
    }

    public void setAngularVelocity(Vector3f angularVelocity) {
        long controllerId = this.nativeId();
        CharacterController.setAngularVelocity(controllerId, angularVelocity);
    }

    public void setFallSpeed(float fallSpeed) {
        long controllerId = this.nativeId();
        CharacterController.setFallSpeed(controllerId, fallSpeed);
    }

    public void setGravity(Vector3f gravity) {
        long controllerId = this.nativeId();
        CharacterController.setGravity(controllerId, gravity);
    }

    public void setJumpSpeed(float jumpSpeed) {
        long controllerId = this.nativeId();
        CharacterController.setJumpSpeed(controllerId, jumpSpeed);
    }

    public void setLinearDamping(float damping) {
        long controllerId = this.nativeId();
        CharacterController.setLinearDamping(controllerId, damping);
    }

    public void setLinearVelocity(Vector3f velocity) {
        long controllerId = this.nativeId();
        CharacterController.setLinearVelocity(controllerId, velocity);
    }

    public void setMaxPenetrationDepth(float depth) {
        long controllerId = this.nativeId();
        CharacterController.setMaxPenetrationDepth(controllerId, depth);
    }

    public void setMaxSlope(float slopeRadians) {
        long controllerId = this.nativeId();
        CharacterController.setMaxSlope(controllerId, slopeRadians);
    }

    public void setStepHeight(float height) {
        long controllerId = this.nativeId();
        CharacterController.setStepHeight(controllerId, height);
    }

    public void setSweepTest(boolean useGhostSweepTest) {
        long controllerId = this.nativeId();
        CharacterController.setUseGhostSweepTest(controllerId, useGhostSweepTest);
    }

    public void setUp(Vector3f direction) {
        Validate.nonZero((Vector3f)direction, (String)"direction");
        long controllerId = this.nativeId();
        CharacterController.setUp(controllerId, direction);
    }

    public void setWalkDirection(Vector3f offset) {
        long controllerId = this.nativeId();
        CharacterController.setWalkDirection(controllerId, offset);
    }

    public void warp(Vector3f location) {
        long controllerId = this.nativeId();
        CharacterController.warp(controllerId, location);
    }

    public void cloneFields(Cloner cloner, Object original) {
        CharacterController old = (CharacterController)original;
        this.copyAll(old);
    }

    public PhysicsCharacter jmeClone() {
        try {
            PhysicsCharacter clone = (PhysicsCharacter)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException exception) {
            throw new RuntimeException(exception);
        }
    }

    public void read(JmeImporter importer) throws IOException {
        InputCapsule capsule = importer.getCapsule((Savable)this);
        this.pco = (PhysicsCharacter)capsule.readSavable(tagPco, null);
        this.createController();
        this.setAngularDamping(capsule.readFloat(tagAngularDamping, 0.0f));
        this.setAngularVelocity((Vector3f)capsule.readSavable(tagAngularVelocity, (Savable)new Vector3f()));
        this.setFallSpeed(capsule.readFloat(tagFallSpeed, 55.0f));
        this.setSweepTest(capsule.readBoolean(tagGhostSweepTest, true));
        Vector3f g = (Vector3f)capsule.readSavable(tagGravityVector, (Savable)new Vector3f(0.0f, -9.81f, 0.0f));
        this.setGravity(g);
        this.setJumpSpeed(capsule.readFloat(tagJumpSpeed, 10.0f));
        this.setLinearDamping(capsule.readFloat(tagLinearDamping, 0.0f));
        this.setWalkDirection((Vector3f)capsule.readSavable(tagWalkDirection, (Savable)new Vector3f()));
        this.setLinearVelocity((Vector3f)capsule.readSavable(tagLinearVelocity, (Savable)new Vector3f()));
        this.setMaxPenetrationDepth(capsule.readFloat(tagMaxPenetrationDepth, 0.2f));
        this.setMaxSlope(capsule.readFloat(tagMaxSlope, 0.7853982f));
        this.setStepHeight(capsule.readFloat(tagStepHeight, 1.0f));
        if (MyVector3f.isZero((Vector3f)g)) {
            this.setUp((Vector3f)capsule.readSavable(tagUpDirection, (Savable)new Vector3f(0.0f, 1.0f, 0.0f)));
        }
    }

    public void write(JmeExporter exporter) throws IOException {
        OutputCapsule capsule = exporter.getCapsule((Savable)this);
        capsule.write((Savable)this.pco, tagPco, null);
        capsule.write(this.getAngularDamping(), tagAngularDamping, 0.0f);
        capsule.write((Savable)this.getAngularVelocity(null), tagAngularVelocity, null);
        capsule.write(this.getFallSpeed(), tagFallSpeed, 55.0f);
        capsule.write(this.isUsingGhostSweepTest(), tagGhostSweepTest, true);
        Vector3f g = this.getGravity(null);
        capsule.write((Savable)g, tagGravityVector, (Savable)new Vector3f(0.0f, -9.81f, 0.0f));
        capsule.write(this.getJumpSpeed(), tagJumpSpeed, 10.0f);
        capsule.write(this.getLinearDamping(), tagLinearDamping, 0.0f);
        capsule.write((Savable)this.getWalkDirection(null), tagWalkDirection, null);
        capsule.write((Savable)this.getLinearVelocity(null), tagLinearVelocity, null);
        capsule.write(this.getMaxPenetrationDepth(), tagMaxPenetrationDepth, 0.2f);
        capsule.write(this.getMaxSlope(), tagMaxSlope, 0.7853982f);
        capsule.write(this.getStepHeight(), tagStepHeight, 1.0f);
        if (MyVector3f.isZero((Vector3f)g)) {
            capsule.write((Savable)this.getUpDirection(null), tagUpDirection, (Savable)new Vector3f(0.0f, 1.0f, 0.0f));
        }
    }

    private void createController() {
        long ghostId = this.pco.nativeId();
        long controllerId = CharacterController.create(ghostId);
        this.setNativeId(controllerId);
    }

    private static void freeNativeObject(long controllerId) {
        assert (controllerId != 0L);
        CharacterController.finalizeNative(controllerId);
    }

    private static native long create(long var0);

    private static native void finalizeNative(long var0);

    private static native float getAngularDamping(long var0);

    private static native void getAngularVelocity(long var0, Vector3f var2);

    private static native float getFallSpeed(long var0);

    private static native void getGravity(long var0, Vector3f var2);

    private static native float getJumpSpeed(long var0);

    private static native float getLinearDamping(long var0);

    private static native void getLinearVelocity(long var0, Vector3f var2);

    private static native float getMaxPenetrationDepth(long var0);

    private static native float getMaxSlope(long var0);

    private static native float getStepHeight(long var0);

    private static native void getUpDirection(long var0, Vector3f var2);

    private static native void getWalkOffset(long var0, Vector3f var2);

    private static native boolean isUsingGhostSweepTest(long var0);

    private static native void jump(long var0, Vector3f var2);

    private static native boolean onGround(long var0);

    private static native void reset(long var0, long var2);

    private static native void setAngularDamping(long var0, float var2);

    private static native void setAngularVelocity(long var0, Vector3f var2);

    private static native void setFallSpeed(long var0, float var2);

    private static native void setGravity(long var0, Vector3f var2);

    private static native void setJumpSpeed(long var0, float var2);

    private static native void setLinearDamping(long var0, float var2);

    private static native void setLinearVelocity(long var0, Vector3f var2);

    private static native void setMaxPenetrationDepth(long var0, float var2);

    private static native void setMaxSlope(long var0, float var2);

    private static native void setStepHeight(long var0, float var2);

    private static native void setUp(long var0, Vector3f var2);

    private static native void setUseGhostSweepTest(long var0, boolean var2);

    private static native void setWalkDirection(long var0, Vector3f var2);

    private static native void warp(long var0, Vector3f var2);
}

