/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.objects.infos;

import com.jme3.bullet.NativePhysicsObject;
import com.jme3.bullet.objects.PhysicsVehicle;
import com.jme3.math.Matrix3f;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.scene.Spatial;
import com.jme3.util.clone.Cloner;
import com.jme3.util.clone.JmeCloneable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RigidBodyMotionState
extends NativePhysicsObject
implements JmeCloneable {
    public static final Logger logger = Logger.getLogger(RigidBodyMotionState.class.getName());
    private boolean applyPhysicsLocal = false;
    private PhysicsVehicle vehicle = null;
    private Quaternion tmpInverseWorldRotation = new Quaternion();

    public RigidBodyMotionState() {
        long motionStateId = RigidBodyMotionState.createMotionState();
        super.setNativeId(motionStateId);
        logger.log(Level.FINE, "Created {0}", this);
    }

    public boolean applyTransform(Spatial spatial) {
        Quaternion localRotationQuat;
        Vector3f localLocation;
        long motionStateId = this.nativeId();
        boolean physicsLocationDirty = RigidBodyMotionState.applyTransform(motionStateId, localLocation = spatial.getLocalTranslation(), localRotationQuat = spatial.getLocalRotation());
        if (!physicsLocationDirty) {
            return false;
        }
        if (!this.applyPhysicsLocal && spatial.getParent() != null) {
            localLocation.subtractLocal(spatial.getParent().getWorldTranslation());
            localLocation.divideLocal(spatial.getParent().getWorldScale());
            this.tmpInverseWorldRotation.set(spatial.getParent().getWorldRotation()).inverseLocal().multLocal(localLocation);
            this.tmpInverseWorldRotation.mult(localRotationQuat, localRotationQuat);
            spatial.setLocalTranslation(localLocation);
            spatial.setLocalRotation(localRotationQuat);
        } else {
            spatial.setLocalTranslation(localLocation);
            spatial.setLocalRotation(localRotationQuat);
        }
        if (this.vehicle != null) {
            this.vehicle.updateWheels();
        }
        return true;
    }

    public Vector3f getLocation(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long motionStateId = this.nativeId();
        RigidBodyMotionState.getWorldLocation(motionStateId, result);
        assert (Vector3f.isValidVector((Vector3f)result));
        return result;
    }

    public long getObjectId() {
        long motionStateId = this.nativeId();
        return motionStateId;
    }

    public Matrix3f getOrientation(Matrix3f storeResult) {
        Matrix3f result = storeResult == null ? new Matrix3f() : storeResult;
        long motionStateId = this.nativeId();
        RigidBodyMotionState.getWorldRotation(motionStateId, result);
        return result;
    }

    public Quaternion getOrientation(Quaternion storeResult) {
        Quaternion result = storeResult == null ? new Quaternion() : storeResult;
        long motionStateId = this.nativeId();
        RigidBodyMotionState.getWorldRotationQuat(motionStateId, result);
        return result;
    }

    public boolean isApplyPhysicsLocal() {
        return this.applyPhysicsLocal;
    }

    public Transform physicsTransform(Transform storeResult) {
        Transform transform = storeResult == null ? new Transform() : storeResult.setScale(1.0f);
        long motionStateId = this.nativeId();
        RigidBodyMotionState.getWorldLocation(motionStateId, transform.getTranslation());
        RigidBodyMotionState.getWorldRotationQuat(motionStateId, transform.getRotation());
        return transform;
    }

    public void setApplyPhysicsLocal(boolean applyPhysicsLocal) {
        this.applyPhysicsLocal = applyPhysicsLocal;
    }

    public void setVehicle(PhysicsVehicle vehicle) {
        this.vehicle = vehicle;
    }

    public void cloneFields(Cloner cloner, Object original) {
        long motionStateId = RigidBodyMotionState.createMotionState();
        this.reassignNativeId(motionStateId);
        this.tmpInverseWorldRotation = (Quaternion)cloner.clone((Object)this.tmpInverseWorldRotation);
        this.vehicle = (PhysicsVehicle)cloner.clone((Object)this.vehicle);
    }

    public RigidBodyMotionState jmeClone() {
        try {
            RigidBodyMotionState clone = (RigidBodyMotionState)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException exception) {
            throw new RuntimeException(exception);
        }
    }

    private static void freeNativeObject(long stateId) {
        assert (stateId != 0L);
        RigidBodyMotionState.finalizeNative(stateId);
    }

    private static native boolean applyTransform(long var0, Vector3f var2, Quaternion var3);

    private static native long createMotionState();

    private static native void finalizeNative(long var0);

    private static native void getWorldLocation(long var0, Vector3f var2);

    private static native void getWorldRotation(long var0, Matrix3f var2);

    private static native void getWorldRotationQuat(long var0, Quaternion var2);
}

