/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.objects.infos;

import com.jme3.bullet.NativePhysicsObject;
import com.jme3.bullet.PhysicsSpace;
import com.jme3.bullet.objects.PhysicsVehicle;
import com.jme3.bullet.objects.VehicleWheel;
import com.jme3.bullet.objects.infos.VehicleTuning;
import com.jme3.math.Vector3f;
import java.util.logging.Logger;
import jme3utilities.Validate;

public class VehicleController
extends NativePhysicsObject {
    public static final Logger logger = Logger.getLogger(VehicleController.class.getName());
    private final PhysicsVehicle pco;

    public VehicleController(PhysicsVehicle vehicle, PhysicsSpace space) {
        Validate.nonNull((Object)vehicle, (String)"vehicle");
        Validate.nonNull((Object)space, (String)"space");
        this.pco = vehicle;
        long spaceId = space.nativeId();
        long rigidBodyId = vehicle.nativeId();
        VehicleTuning tuning = vehicle.getTuning();
        long tuningId = tuning.nativeId();
        long controllerId = VehicleController.createRaycastVehicle(spaceId, rigidBodyId, tuningId);
        super.setNativeId(controllerId);
    }

    public int addWheel(VehicleWheel wheel, VehicleTuning tuning) {
        Vector3f location = wheel.getLocation(null);
        Vector3f direction = wheel.getDirection(null);
        Vector3f axle = wheel.getAxle(null);
        float restLength = wheel.getRestLength();
        float radius = wheel.getRadius();
        boolean isFrontWheel = wheel.isFrontWheel();
        long controllerId = this.nativeId();
        long tuningId = tuning.nativeId();
        int result = VehicleController.addWheel(controllerId, location, direction, axle, restLength, radius, tuningId, isFrontWheel);
        return result;
    }

    public void applyEngineForce(VehicleWheel wheel, float force) {
        assert (this.pco.isInWorld());
        long controllerId = this.nativeId();
        int wheelIndex = wheel.getIndex();
        VehicleController.applyEngineForce(controllerId, wheelIndex, force);
        assert (wheel.getEngineForce() == force) : wheel.getEngineForce();
    }

    public void brake(VehicleWheel wheel, float impulse) {
        assert (this.pco.isInWorld());
        long controllerId = this.nativeId();
        int wheelIndex = wheel.getIndex();
        VehicleController.brake(controllerId, wheelIndex, impulse);
        assert (wheel.getBrake() == impulse) : wheel.getBrake();
    }

    public float castRay(VehicleWheel wheel) {
        assert (this.pco.isInWorld());
        long controllerId = this.nativeId();
        int wheelIndex = wheel.getIndex();
        float result = VehicleController.rayCast(controllerId, wheelIndex);
        return result;
    }

    public int countWheels() {
        long controllerId = this.nativeId();
        int result = VehicleController.getNumWheels(controllerId);
        return result;
    }

    public int forwardAxisIndex() {
        assert (this.pco.isInWorld());
        long controllerId = this.nativeId();
        int result = VehicleController.getForwardAxisIndex(controllerId);
        return result;
    }

    public float getCurrentVehicleSpeedKmHour() {
        assert (this.pco.isInWorld());
        long controllerId = this.nativeId();
        float result = VehicleController.getCurrentVehicleSpeedKmHour(controllerId);
        return result;
    }

    public Vector3f getForwardVector(Vector3f storeResult) {
        Vector3f result;
        Vector3f vector3f = result = storeResult == null ? new Vector3f() : storeResult;
        assert (this.pco.isInWorld());
        long controllerId = this.nativeId();
        VehicleController.getForwardVector(controllerId, result);
        return result;
    }

    public void resetSuspension() {
        assert (this.pco.isInWorld());
        long controllerId = this.nativeId();
        VehicleController.resetSuspension(controllerId);
    }

    public int rightAxisIndex() {
        assert (this.pco.isInWorld());
        long controllerId = this.nativeId();
        int result = VehicleController.getRightAxisIndex(controllerId);
        return result;
    }

    public void setCoordinateSystem(int rightAxisIndex, int upAxisIndex, int forwardAxisIndex) {
        Validate.axisIndex((int)rightAxisIndex, (String)"right axis");
        Validate.axisIndex((int)upAxisIndex, (String)"up axis");
        Validate.axisIndex((int)forwardAxisIndex, (String)"forward axis");
        long controllerId = this.nativeId();
        VehicleController.setCoordinateSystem(controllerId, rightAxisIndex, upAxisIndex, forwardAxisIndex);
    }

    public void setCoordinateSystem(Vector3f right, Vector3f up, Vector3f forward) {
        Validate.nonNull((Object)right, (String)"right");
        Validate.nonNull((Object)right, (String)"up");
        Validate.nonNull((Object)right, (String)"forward");
        long controllerId = this.nativeId();
        VehicleController.setupCoordinateSystem(controllerId, right, up, forward);
    }

    public void steer(VehicleWheel wheel, float angle) {
        assert (this.pco.isInWorld());
        long controllerId = this.nativeId();
        int wheelIndex = wheel.getIndex();
        VehicleController.steer(controllerId, wheelIndex, angle);
    }

    public int upAxisIndex() {
        assert (this.pco.isInWorld());
        long controllerId = this.nativeId();
        int result = VehicleController.getUpAxisIndex(controllerId);
        return result;
    }

    public void updateWheelTransform(VehicleWheel wheel) {
        long controllerId = this.nativeId();
        int wheelIndex = wheel.getIndex();
        boolean interpolate = true;
        VehicleController.updateWheelTransform(controllerId, wheelIndex, interpolate);
        wheel.updatePhysicsState();
    }

    private static void freeNativeObject(long controllerId) {
        assert (controllerId != 0L);
        VehicleController.finalizeNative(controllerId);
    }

    private static native int addWheel(long var0, Vector3f var2, Vector3f var3, Vector3f var4, float var5, float var6, long var7, boolean var9);

    private static native void applyEngineForce(long var0, int var2, float var3);

    private static native void brake(long var0, int var2, float var3);

    private static native long createRaycastVehicle(long var0, long var2, long var4);

    private static native void finalizeNative(long var0);

    private static native float getCurrentVehicleSpeedKmHour(long var0);

    private static native int getForwardAxisIndex(long var0);

    private static native void getForwardVector(long var0, Vector3f var2);

    private static native int getNumWheels(long var0);

    private static native int getRightAxisIndex(long var0);

    private static native int getUpAxisIndex(long var0);

    private static native float rayCast(long var0, int var2);

    private static native void resetSuspension(long var0);

    private static native void setCoordinateSystem(long var0, int var2, int var3, int var4);

    private static native void setupCoordinateSystem(long var0, Vector3f var2, Vector3f var3, Vector3f var4);

    private static native void steer(long var0, int var2, float var3);

    private static native void updateWheelTransform(long var0, int var2, boolean var3);
}

