/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.objects.infos;

import com.jme3.bullet.NativePhysicsObject;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.util.clone.Cloner;
import com.jme3.util.clone.JmeCloneable;
import java.io.IOException;
import java.util.logging.Logger;

public class VehicleTuning
extends NativePhysicsObject
implements JmeCloneable,
Savable {
    public static final Logger logger = Logger.getLogger(VehicleTuning.class.getName());
    private static final String tagFrictionSlip = "frictionSlip";
    private static final String tagMaxSuspensionForce = "maxSuspensionForce";
    private static final String tagMaxSuspensionTravelCm = "maxSuspensionTravelCm";
    private static final String tagSuspensionStiffness = "suspensionStiffness";
    private static final String tagWheelsDampingRelaxation = "wheelsDampingRelaxation";
    private static final String tagWheelsDampingCompression = "wheelsDampingCompression";
    private float frictionSlip = 10.5f;
    private float maxSuspensionForce = 6000.0f;
    private float maxSuspensionTravelCm = 500.0f;
    private float suspensionCompression = 0.83f;
    private float suspensionDamping = 0.88f;
    private float suspensionStiffness = 5.88f;

    public VehicleTuning() {
        this.create();
    }

    public float getFrictionSlip() {
        return this.frictionSlip;
    }

    public float getMaxSuspensionForce() {
        return this.maxSuspensionForce;
    }

    public float getMaxSuspensionTravelCm() {
        return this.maxSuspensionTravelCm;
    }

    public float getSuspensionCompression() {
        return this.suspensionCompression;
    }

    public float getSuspensionDamping() {
        return this.suspensionDamping;
    }

    public float getSuspensionStiffness() {
        return this.suspensionStiffness;
    }

    public void setFrictionSlip(float coeff) {
        this.frictionSlip = coeff;
        long tuningId = this.nativeId();
        VehicleTuning.setFrictionSlip(tuningId, coeff);
    }

    public void setMaxSuspensionForce(float maxForce) {
        this.maxSuspensionForce = maxForce;
        long tuningId = this.nativeId();
        VehicleTuning.setMaxSuspensionForce(tuningId, maxForce);
    }

    public void setMaxSuspensionTravelCm(float travelCm) {
        this.maxSuspensionTravelCm = travelCm;
        long tuningId = this.nativeId();
        VehicleTuning.setMaxSuspensionTravelCm(tuningId, travelCm);
    }

    public void setSuspensionCompression(float damping) {
        this.suspensionCompression = damping;
        long tuningId = this.nativeId();
        VehicleTuning.setSuspensionCompression(tuningId, damping);
    }

    public void setSuspensionDamping(float damping) {
        this.suspensionDamping = damping;
        long tuningId = this.nativeId();
        VehicleTuning.setSuspensionDamping(tuningId, damping);
    }

    public void setSuspensionStiffness(float stiffness) {
        this.suspensionStiffness = stiffness;
        long tuningId = this.nativeId();
        VehicleTuning.setSuspensionStiffness(tuningId, stiffness);
    }

    public void cloneFields(Cloner cloner, Object original) {
        this.unassignNativeObject();
        this.create();
    }

    public VehicleTuning jmeClone() {
        try {
            VehicleTuning clone = (VehicleTuning)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException exception) {
            throw new RuntimeException(exception);
        }
    }

    public void read(JmeImporter importer) throws IOException {
        InputCapsule capsule = importer.getCapsule((Savable)this);
        this.setSuspensionStiffness(capsule.readFloat(tagSuspensionStiffness, 5.88f));
        this.setSuspensionDamping(capsule.readFloat(tagWheelsDampingRelaxation, 0.88f));
        this.setSuspensionCompression(capsule.readFloat(tagWheelsDampingCompression, 0.83f));
        this.setFrictionSlip(capsule.readFloat(tagFrictionSlip, 10.5f));
        this.setMaxSuspensionTravelCm(capsule.readFloat(tagMaxSuspensionTravelCm, 500.0f));
        this.setMaxSuspensionForce(capsule.readFloat(tagMaxSuspensionForce, 6000.0f));
    }

    public void write(JmeExporter exporter) throws IOException {
        OutputCapsule capsule = exporter.getCapsule((Savable)this);
        capsule.write(this.suspensionStiffness, tagSuspensionStiffness, 5.88f);
        capsule.write(this.suspensionDamping, tagWheelsDampingRelaxation, 0.88f);
        capsule.write(this.suspensionCompression, tagWheelsDampingCompression, 0.83f);
        capsule.write(this.frictionSlip, tagFrictionSlip, 10.5f);
        capsule.write(this.maxSuspensionTravelCm, tagMaxSuspensionTravelCm, 500.0f);
        capsule.write(this.maxSuspensionForce, tagMaxSuspensionForce, 6000.0f);
    }

    private void create() {
        long tuningId = VehicleTuning.createNative();
        this.setNativeId(tuningId);
        VehicleTuning.setFrictionSlip(tuningId, this.frictionSlip);
        VehicleTuning.setMaxSuspensionForce(tuningId, this.maxSuspensionForce);
        VehicleTuning.setMaxSuspensionTravelCm(tuningId, this.maxSuspensionTravelCm);
        VehicleTuning.setSuspensionCompression(tuningId, this.suspensionCompression);
        VehicleTuning.setSuspensionDamping(tuningId, this.suspensionDamping);
        VehicleTuning.setSuspensionStiffness(tuningId, this.suspensionStiffness);
    }

    private static void freeNativeObject(long tuningId) {
        assert (tuningId != 0L);
        VehicleTuning.finalizeNative(tuningId);
    }

    private static native long createNative();

    private static native void finalizeNative(long var0);

    private static native void setFrictionSlip(long var0, float var2);

    private static native void setMaxSuspensionForce(long var0, float var2);

    private static native void setMaxSuspensionTravelCm(long var0, float var2);

    private static native void setSuspensionCompression(long var0, float var2);

    private static native void setSuspensionDamping(long var0, float var2);

    private static native void setSuspensionStiffness(long var0, float var2);
}

