/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.util;

import com.jme3.bullet.collision.PhysicsCollisionObject;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.collision.shapes.CompoundCollisionShape;
import com.jme3.bullet.collision.shapes.ConvexShape;
import com.jme3.bullet.collision.shapes.PlaneCollisionShape;
import com.jme3.bullet.collision.shapes.infos.ChildCollisionShape;
import com.jme3.bullet.debug.DebugMeshInitListener;
import com.jme3.bullet.debug.MeshCustomizer;
import com.jme3.bullet.util.DebugMeshCallback;
import com.jme3.bullet.util.DebugMeshKey;
import com.jme3.math.FastMath;
import com.jme3.math.Matrix3f;
import com.jme3.math.Plane;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.util.BufferUtils;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Logger;
import jme3utilities.MeshNormals;
import jme3utilities.MyMesh;
import jme3utilities.Validate;
import jme3utilities.math.MyBuffer;
import jme3utilities.math.MyVector3f;

public final class DebugShapeFactory {
    private static final float planeDebugMeshSideLength = 1500.0f;
    private static final float root2 = FastMath.sqrt((float)2.0f);
    public static final int highResolution = 1;
    public static final int lowResolution = 0;
    private static final int numAxes = 3;
    public static final Logger logger = Logger.getLogger(DebugShapeFactory.class.getName());
    private static final Vector3f translateIdentity = new Vector3f(0.0f, 0.0f, 0.0f);
    private static int maxVerticesToIndex = 6000;
    private static final Map<DebugMeshKey, Mesh> cache = Collections.synchronizedMap(new WeakHashMap(200));
    private static MeshCustomizer meshCustomizer;

    private DebugShapeFactory() {
    }

    public static void clearCache() {
        cache.clear();
    }

    public static int countCachedMeshes() {
        int result = cache.size();
        return result;
    }

    public static FloatBuffer debugVertices(CollisionShape shape, int meshResolution) {
        FloatBuffer result;
        Validate.nonNull((Object)shape, (String)"shape");
        Validate.inRange((int)meshResolution, (String)"mesh resolution", (int)0, (int)1);
        if (shape instanceof CompoundCollisionShape) {
            CompoundCollisionShape ccs = (CompoundCollisionShape)shape;
            result = DebugShapeFactory.createCompoundVertices(ccs, meshResolution);
        } else if (shape instanceof PlaneCollisionShape) {
            float halfExt = 1000.0f;
            result = DebugShapeFactory.createPlaneVertices((PlaneCollisionShape)shape, halfExt);
        } else {
            long shapeId = shape.nativeId();
            DebugMeshCallback callback = new DebugMeshCallback();
            DebugShapeFactory.getVertices(shapeId, meshResolution, callback);
            result = callback.getVertices();
        }
        assert (result.capacity() % 3 == 0) : result.capacity();
        return result;
    }

    public static Vector3f[] footprint(CollisionShape shape, Transform shapeToWorld, int meshResolution) {
        assert (!(shape instanceof CompoundCollisionShape));
        assert (!(shape instanceof PlaneCollisionShape));
        Validate.nonNull((Object)shapeToWorld, (String)"shape-to-world");
        Validate.inRange((int)meshResolution, (String)"mesh resolution", (int)0, (int)1);
        long shapeId = shape.nativeId();
        DebugMeshCallback callback = new DebugMeshCallback();
        DebugShapeFactory.getVertices(shapeId, meshResolution, callback);
        Vector3f[] cornerLocations = callback.footprint(shapeToWorld);
        return cornerLocations;
    }

    public static Mesh getDebugMesh(CollisionShape shape) {
        Validate.nonNull((Object)shape, (String)"shape");
        FloatBuffer floatBuffer = DebugShapeFactory.getDebugTriangles(shape, 0);
        Mesh result = new Mesh();
        result.setBuffer(VertexBuffer.Type.Position, 3, floatBuffer);
        result.updateBound();
        return result;
    }

    public static Spatial getDebugShape(CollisionShape shape) {
        DebugMeshInitListener noListener = null;
        Object result = shape == null ? null : (shape instanceof CompoundCollisionShape ? DebugShapeFactory.createNode((CompoundCollisionShape)shape, noListener, MeshNormals.None, 0) : DebugShapeFactory.createGeometry(shape, noListener, MeshNormals.None, 0));
        return result;
    }

    public static Spatial getDebugShape(PhysicsCollisionObject pco) {
        Geometry result;
        CollisionShape shape = pco.getCollisionShape();
        DebugMeshInitListener listener = pco.debugMeshInitListener();
        MeshNormals normals = pco.debugMeshNormals();
        int resolution = pco.debugMeshResolution();
        if (shape instanceof CompoundCollisionShape) {
            CompoundCollisionShape compound = (CompoundCollisionShape)shape;
            result = DebugShapeFactory.createNode(compound, listener, normals, resolution);
        } else {
            result = DebugShapeFactory.createGeometry(shape, listener, normals, resolution);
        }
        return result;
    }

    public static FloatBuffer getDebugTriangles(CollisionShape shape, int meshResolution) {
        FloatBuffer result;
        Validate.nonNull((Object)shape, (String)"shape");
        Validate.inRange((int)meshResolution, (String)"mesh resolution", (int)0, (int)1);
        if (shape instanceof CompoundCollisionShape) {
            CompoundCollisionShape ccs = (CompoundCollisionShape)shape;
            result = DebugShapeFactory.createCompoundTriangles(ccs, meshResolution);
        } else if (shape instanceof PlaneCollisionShape) {
            float halfExt = 1000.0f;
            result = DebugShapeFactory.createPlaneTriangles((PlaneCollisionShape)shape, halfExt);
        } else {
            long shapeId = shape.nativeId();
            DebugMeshCallback callback = new DebugMeshCallback();
            DebugShapeFactory.getTriangles(shapeId, meshResolution, callback);
            result = callback.getVertices();
        }
        assert (result.capacity() % 9 == 0) : result.capacity();
        return result;
    }

    public static void installMeshCustomizer(MeshCustomizer customizer) {
        meshCustomizer = customizer;
    }

    public static float maxDistance(CollisionShape shape, Transform transform, int meshResolution) {
        assert (!(shape instanceof CompoundCollisionShape));
        assert (!(shape instanceof PlaneCollisionShape));
        Validate.nonNull((Object)transform, (String)"transform");
        Validate.inRange((int)meshResolution, (String)"mesh resolution", (int)0, (int)1);
        long shapeId = shape.nativeId();
        DebugMeshCallback callback = new DebugMeshCallback();
        DebugShapeFactory.getVertices(shapeId, meshResolution, callback);
        float result = callback.maxDistance(transform);
        return result;
    }

    static float meshSideLength() {
        float result = 1500.0f;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeShapeFromCache(long shapeId) {
        Map<DebugMeshKey, Mesh> map = cache;
        synchronized (map) {
            for (DebugMeshKey key : cache.keySet()) {
                if (key.shapeId() != shapeId) continue;
                cache.remove(key);
            }
        }
    }

    public static void setIndexBuffers(boolean setting) {
        maxVerticesToIndex = setting ? Integer.MAX_VALUE : -1;
    }

    public static void setIndexBuffers(int maxVertices) {
        Validate.inRange((int)maxVertices, (String)"maxVertices", (int)-1, (int)Integer.MAX_VALUE);
        maxVerticesToIndex = maxVertices;
    }

    public static float volumeConvex(ConvexShape shape, int meshResolution) {
        Validate.inRange((int)meshResolution, (String)"mesh resolution", (int)0, (int)1);
        long shapeId = shape.nativeId();
        DebugMeshCallback callback = new DebugMeshCallback();
        DebugShapeFactory.getTriangles(shapeId, meshResolution, callback);
        float volume = callback.volumeConvex();
        assert (volume >= 0.0f) : volume;
        return volume;
    }

    private static FloatBuffer createCompoundTriangles(CompoundCollisionShape compoundShape, int meshResolution) {
        ChildCollisionShape[] children = compoundShape.listChildren();
        int numChildren = children.length;
        FloatBuffer[] bufferArray = new FloatBuffer[numChildren];
        Transform tmpTransform = new Transform();
        int totalFloats = 0;
        for (int childIndex = 0; childIndex < numChildren; ++childIndex) {
            ChildCollisionShape childShape = children[childIndex];
            CollisionShape shape = childShape.getShape();
            childShape.copyTransform(tmpTransform);
            FloatBuffer buffer = DebugShapeFactory.getDebugTriangles(shape, meshResolution);
            int numFloats = buffer.capacity();
            MyBuffer.transform((FloatBuffer)buffer, (int)0, (int)numFloats, (Transform)tmpTransform);
            bufferArray[childIndex] = buffer;
            totalFloats += numFloats;
        }
        FloatBuffer result = BufferUtils.createFloatBuffer((int)totalFloats);
        for (FloatBuffer buffer : bufferArray) {
            for (int position = 0; position < buffer.capacity(); ++position) {
                float value = buffer.get(position);
                result.put(value);
            }
        }
        assert (result.position() == result.capacity());
        return result;
    }

    private static FloatBuffer createCompoundVertices(CompoundCollisionShape compoundShape, int meshResolution) {
        ChildCollisionShape[] children = compoundShape.listChildren();
        int numChildren = children.length;
        FloatBuffer[] bufferArray = new FloatBuffer[numChildren];
        Transform tmpTransform = new Transform();
        int totalFloats = 0;
        for (int childIndex = 0; childIndex < numChildren; ++childIndex) {
            ChildCollisionShape childShape = children[childIndex];
            CollisionShape shape = childShape.getShape();
            childShape.copyTransform(tmpTransform);
            FloatBuffer buffer = DebugShapeFactory.debugVertices(shape, meshResolution);
            int numFloats = buffer.capacity();
            MyBuffer.transform((FloatBuffer)buffer, (int)0, (int)numFloats, (Transform)tmpTransform);
            bufferArray[childIndex] = buffer;
            totalFloats += numFloats;
        }
        FloatBuffer result = BufferUtils.createFloatBuffer((int)totalFloats);
        for (FloatBuffer buffer : bufferArray) {
            for (int position = 0; position < buffer.capacity(); ++position) {
                float value = buffer.get(position);
                result.put(value);
            }
        }
        assert (result.position() == result.capacity());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Geometry createGeometry(CollisionShape shape, DebugMeshInitListener listener, MeshNormals normals, int resolution) {
        Mesh mesh;
        assert (shape != null);
        assert (!(shape instanceof CompoundCollisionShape));
        assert (normals != null);
        assert (resolution >= 0) : resolution;
        assert (resolution <= 1) : resolution;
        DebugMeshKey key = new DebugMeshKey(shape, normals, resolution);
        Map<DebugMeshKey, Mesh> map = cache;
        synchronized (map) {
            mesh = cache.get(key);
            if (mesh == null) {
                mesh = shape instanceof PlaneCollisionShape ? DebugShapeFactory.createPlaneMesh((PlaneCollisionShape)shape, normals) : DebugShapeFactory.createMesh(shape, normals, resolution);
                if (meshCustomizer != null) {
                    mesh = meshCustomizer.customizeMesh(mesh);
                }
                if (listener != null) {
                    listener.debugMeshInit(mesh);
                }
                cache.put(key, mesh);
            }
        }
        Geometry geometry = new Geometry("Bullet debug", mesh);
        geometry.updateModelBound();
        return geometry;
    }

    private static Mesh createMesh(CollisionShape shape, MeshNormals normals, int resolution) {
        assert (resolution >= 0) : resolution;
        assert (resolution <= 1) : resolution;
        long shapeId = shape.nativeId();
        DebugMeshCallback callback = new DebugMeshCallback();
        DebugShapeFactory.getTriangles(shapeId, resolution, callback);
        Mesh mesh = new Mesh();
        mesh.setBuffer(VertexBuffer.Type.Position, 3, callback.getVertices());
        switch (normals) {
            case Facet: {
                mesh.setBuffer(VertexBuffer.Type.Normal, 3, callback.getFaceNormals());
                break;
            }
            case None: {
                break;
            }
            case Smooth: {
                mesh.setBuffer(VertexBuffer.Type.Normal, 3, callback.getFaceNormals());
                MyMesh.smoothNormals((Mesh)mesh);
                break;
            }
            case Sphere: {
                MyMesh.addSphereNormals((Mesh)mesh);
                break;
            }
            default: {
                String message = "normals = " + normals;
                throw new IllegalArgumentException(message);
            }
        }
        if (mesh.getVertexCount() <= maxVerticesToIndex) {
            mesh = MyMesh.addIndices((Mesh)mesh);
        }
        mesh.updateBound();
        mesh.setStatic();
        return mesh;
    }

    private static Node createNode(CompoundCollisionShape compoundShape, DebugMeshInitListener listener, MeshNormals normals, int resolution) {
        ChildCollisionShape[] children;
        assert (normals != null);
        assert (resolution >= 0) : resolution;
        assert (resolution <= 1) : resolution;
        Node node = new Node("Bullet debug");
        Vector3f scale = compoundShape.getScale(null);
        Matrix3f tmpRotation = new Matrix3f();
        Vector3f tmpOffset = new Vector3f();
        for (ChildCollisionShape child : children = compoundShape.listChildren()) {
            CollisionShape childShape = child.getShape();
            Geometry geometry = DebugShapeFactory.createGeometry(childShape, listener, normals, resolution);
            child.copyOffset(tmpOffset);
            tmpOffset.multLocal(scale);
            geometry.setLocalTranslation(tmpOffset);
            child.copyRotationMatrix(tmpRotation);
            geometry.setLocalRotation(tmpRotation);
            node.attachChild((Spatial)geometry);
        }
        node.updateGeometricState();
        return node;
    }

    private static Mesh createPlaneMesh(PlaneCollisionShape shape, MeshNormals normals) {
        int numVertices = 8;
        int numFloats = numVertices * 3;
        FloatBuffer posBuffer = BufferUtils.createFloatBuffer((int)numFloats);
        for (int sideIndex = 0; sideIndex < 2; ++sideIndex) {
            posBuffer.put(new float[]{0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, -1.0f, 0.0f});
        }
        assert (posBuffer.position() == numFloats);
        posBuffer.flip();
        Transform transform = DebugShapeFactory.planeTransform(shape);
        float scale = DebugShapeFactory.meshSideLength() / root2;
        transform.setScale(scale);
        MyBuffer.transform((FloatBuffer)posBuffer, (int)0, (int)numFloats, (Transform)transform);
        ByteBuffer indexBuffer = BufferUtils.createByteBuffer((byte[])new byte[]{2, 1, 0, 3, 2, 0, 5, 6, 7, 4, 5, 7});
        indexBuffer.clear();
        Mesh result = new Mesh();
        result.setBuffer(VertexBuffer.Type.Position, 3, posBuffer);
        result.setBuffer(VertexBuffer.Type.Index, 3, indexBuffer);
        if (normals != MeshNormals.None) {
            int i;
            Plane plane = shape.getPlane();
            Vector3f v1 = plane.getNormal();
            FloatBuffer normBuffer = BufferUtils.createFloatBuffer((int)numFloats);
            for (i = 0; i < 4; ++i) {
                normBuffer.put(v1.x).put(v1.y).put(v1.z);
            }
            for (i = 0; i < 4; ++i) {
                normBuffer.put(-v1.x).put(-v1.y).put(-v1.z);
            }
            normBuffer.flip();
            result.setBuffer(VertexBuffer.Type.Normal, 3, normBuffer);
        }
        result.updateBound();
        result.setStatic();
        return result;
    }

    private static FloatBuffer createPlaneTriangles(PlaneCollisionShape shape, float halfExtent) {
        assert (shape != null);
        assert (halfExtent > 0.0f) : halfExtent;
        FloatBuffer result = BufferUtils.createFloatBuffer((float[])new float[]{0.0f, 0.0f, -1.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 1.0f});
        int numFloats = result.capacity();
        Transform transform = DebugShapeFactory.planeTransform(shape);
        transform.setScale(halfExtent);
        MyBuffer.transform((FloatBuffer)result, (int)0, (int)numFloats, (Transform)transform);
        return result;
    }

    private static FloatBuffer createPlaneVertices(PlaneCollisionShape shape, float halfExtent) {
        assert (shape != null);
        assert (halfExtent > 0.0f) : halfExtent;
        FloatBuffer result = BufferUtils.createFloatBuffer((float[])new float[]{0.0f, 0.0f, -1.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, -1.0f, 0.0f});
        int numFloats = result.capacity();
        Transform transform = DebugShapeFactory.planeTransform(shape);
        transform.setScale(halfExtent);
        MyBuffer.transform((FloatBuffer)result, (int)0, (int)numFloats, (Transform)transform);
        return result;
    }

    private static Transform planeTransform(PlaneCollisionShape shape) {
        Transform result = new Transform();
        Plane plane = shape.getPlane();
        plane.getClosestPoint(translateIdentity, result.getTranslation());
        Vector3f v1 = plane.getNormal();
        Vector3f v2 = new Vector3f();
        Vector3f v3 = new Vector3f();
        MyVector3f.generateBasis((Vector3f)v1, (Vector3f)v2, (Vector3f)v3);
        result.getRotation().fromAxes(v1, v2, v3);
        return result;
    }

    private static native void getTriangles(long var0, int var2, DebugMeshCallback var3);

    private static native void getVertices(long var0, int var2, DebugMeshCallback var3);
}

