/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.minie;

import com.jme3.bullet.CollisionSpace;
import com.jme3.bullet.PhysicsSpace;
import com.jme3.bullet.debug.BulletDebugAppState;
import com.jme3.bullet.objects.PhysicsRigidBody;
import java.util.logging.Logger;

public class CcdFilter
implements BulletDebugAppState.DebugAppStateFilter {
    private static final Logger logger = Logger.getLogger(CcdFilter.class.getName());

    @Override
    public boolean displayObject(Object physicsObject) {
        if (physicsObject instanceof PhysicsRigidBody) {
            PhysicsRigidBody rigidBody = (PhysicsRigidBody)physicsObject;
            CollisionSpace space = rigidBody.getCollisionSpace();
            if (rigidBody.isDynamic() && space instanceof PhysicsSpace) {
                float threshold;
                float timeStep = ((PhysicsSpace)space).getAccuracy();
                float squaredSpeed = rigidBody.getSquaredSpeed();
                float squareMotion = squaredSpeed * timeStep * timeStep;
                if (squareMotion > (threshold = rigidBody.getCcdSquareMotionThreshold())) {
                    return true;
                }
            }
        }
        return false;
    }
}

