/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.minie;

import com.jme3.bullet.debug.BulletDebugAppState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Logger;
import jme3utilities.Validate;

public class FilterAll
implements BulletDebugAppState.DebugAppStateFilter {
    public static final Logger logger = Logger.getLogger(FilterAll.class.getName());
    private final boolean returnValue;
    private final Collection<Object> exceptions = new ArrayList<Object>(32);

    public FilterAll(boolean returnValue) {
        this.returnValue = returnValue;
    }

    public void addException(Object exception) {
        Validate.nonNull((Object)exception, (String)"exception");
        if (!this.exceptions.contains(exception)) {
            this.exceptions.add(exception);
        }
    }

    public void clearExceptions() {
        this.exceptions.clear();
    }

    public int countExceptions() {
        int result = this.exceptions.size();
        return result;
    }

    public boolean defaultReturnValue() {
        return this.returnValue;
    }

    public Object[] listExceptions() {
        int numExceptions = this.countExceptions();
        Object[] result = new Object[numExceptions];
        this.exceptions.toArray(result);
        return result;
    }

    public void removeException(Object exception) {
        Validate.nonNull((Object)exception, (String)"exception");
        boolean success = this.exceptions.remove(exception);
        assert (success);
    }

    @Override
    public boolean displayObject(Object physicsObject) {
        if (this.exceptions.contains(physicsObject)) {
            return !this.returnValue;
        }
        return this.returnValue;
    }
}

